/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.internal.AnsiRenderKt;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.OverflowWrap;
import com.github.ajalt.mordant.rendering.Renderable;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.rendering.ThemeKt;
import com.github.ajalt.mordant.rendering.Whitespace;
import com.github.ajalt.mordant.terminal.AnsiLevel;
import com.github.ajalt.mordant.terminal.DisabledTerminalCursor;
import com.github.ajalt.mordant.terminal.PrintTerminalCursor;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.terminal.TerminalColors;
import com.github.ajalt.mordant.terminal.TerminalCursor;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BU\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\b\b\u0002\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020%H\u0016J\u0010\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020#H\u0016J\u0010\u0010)\u001a\u00020%2\u0006\u0010(\u001a\u00020#H\u0016J\u0010\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,H\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006-"}, d2={"Lcom/github/ajalt/mordant/terminal/VirtualTerminal;", "Lcom/github/ajalt/mordant/terminal/Terminal;", "ansiLevel", "Lcom/github/ajalt/mordant/terminal/AnsiLevel;", "theme", "Lcom/github/ajalt/mordant/rendering/Theme;", "width", "", "height", "hyperlinks", "", "tabWidth", "stdoutInteractive", "stdinInteractive", "(Lcom/github/ajalt/mordant/terminal/AnsiLevel;Lcom/github/ajalt/mordant/rendering/Theme;IIZIZZ)V", "colors", "Lcom/github/ajalt/mordant/terminal/TerminalColors;", "getColors", "()Lcom/github/ajalt/mordant/terminal/TerminalColors;", "cursor", "Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "getCursor", "()Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "info", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "getInfo", "()Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getTabWidth", "()I", "getTheme", "()Lcom/github/ajalt/mordant/rendering/Theme;", "buffer", "", "clearBuffer", "", "println", "rawPrint", "message", "rawPrintln", "render", "lines", "Lcom/github/ajalt/mordant/rendering/Lines;", "mordant"})
public final class VirtualTerminal
implements Terminal {
    private final StringBuilder sb;
    @NotNull
    private final TerminalInfo info;
    @NotNull
    private final TerminalColors colors;
    @NotNull
    private final TerminalCursor cursor;
    @NotNull
    private final Theme theme;
    private final int tabWidth;

    public final void clearBuffer() {
        StringsKt.clear(this.sb);
    }

    @NotNull
    public final String buffer() {
        String string = this.sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    @Override
    @NotNull
    public TerminalInfo getInfo() {
        return this.info;
    }

    @Override
    @NotNull
    public TerminalColors getColors() {
        return this.colors;
    }

    @Override
    @NotNull
    public TerminalCursor getCursor() {
        return this.cursor;
    }

    @Override
    @NotNull
    public String render(@NotNull Lines lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        return AnsiRenderKt.renderLinesAnsi(lines, this.getInfo().getAnsiLevel(), this.getInfo().getAnsiHyperLinks());
    }

    @Override
    public void println() {
        this.sb.append("\n");
    }

    @Override
    public void rawPrintln(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.sb.append(message).append("\n");
    }

    @Override
    public void rawPrint(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        this.sb.append(message);
    }

    @Override
    @NotNull
    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public int getTabWidth() {
        return this.tabWidth;
    }

    public VirtualTerminal(@NotNull AnsiLevel ansiLevel, @NotNull Theme theme, int width, int height, boolean hyperlinks, int tabWidth, boolean stdoutInteractive, boolean stdinInteractive) {
        Intrinsics.checkNotNullParameter((Object)ansiLevel, "ansiLevel");
        Intrinsics.checkNotNullParameter(theme, "theme");
        this.theme = theme;
        this.tabWidth = tabWidth;
        boolean bl = this.getTabWidth() >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "tab width cannot be negative";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.sb = new StringBuilder();
        this.info = new TerminalInfo(width, height, ansiLevel, hyperlinks, stdoutInteractive, stdinInteractive);
        this.colors = new TerminalColors(this.getInfo().getAnsiLevel());
        this.cursor = stdinInteractive && stdinInteractive ? (TerminalCursor)new PrintTerminalCursor(this) : (TerminalCursor)DisabledTerminalCursor.INSTANCE;
    }

    public /* synthetic */ VirtualTerminal(AnsiLevel ansiLevel, Theme theme, int n, int n2, boolean bl, int n3, boolean bl2, boolean bl3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            ansiLevel = AnsiLevel.TRUECOLOR;
        }
        if ((n4 & 2) != 0) {
            theme = ThemeKt.getDEFAULT_THEME();
        }
        if ((n4 & 4) != 0) {
            n = 79;
        }
        if ((n4 & 8) != 0) {
            n2 = 24;
        }
        if ((n4 & 0x10) != 0) {
            boolean bl4 = bl = ansiLevel != AnsiLevel.NONE;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 4;
        }
        if ((n4 & 0x40) != 0) {
            boolean bl5 = bl2 = ansiLevel != AnsiLevel.NONE;
        }
        if ((n4 & 0x80) != 0) {
            bl3 = ansiLevel != AnsiLevel.NONE;
        }
        this(ansiLevel, theme, n, n2, bl, n3, bl2, bl3);
    }

    public VirtualTerminal() {
        this(null, null, 0, 0, false, 0, false, false, 255, null);
    }

    @Override
    @NotNull
    public String render(@Nullable Object message, @NotNull TextStyle style, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter(style, "style");
        Intrinsics.checkNotNullParameter((Object)whitespace, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        return Terminal.DefaultImpls.render(this, message, style, whitespace, align, overflowWrap2, width);
    }

    @Override
    @NotNull
    public String render(@NotNull Renderable renderable) {
        Intrinsics.checkNotNullParameter(renderable, "renderable");
        return Terminal.DefaultImpls.render(this, renderable);
    }

    @Override
    public void println(@Nullable Object message, @NotNull TextStyle style, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter(style, "style");
        Intrinsics.checkNotNullParameter((Object)whitespace, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        Terminal.DefaultImpls.println(this, message, style, whitespace, align, overflowWrap2, width);
    }

    @Override
    public void println(@NotNull Renderable renderable) {
        Intrinsics.checkNotNullParameter(renderable, "renderable");
        Terminal.DefaultImpls.println(this, renderable);
    }

    @Override
    public void printMarkdown(@NotNull String markdown, boolean showHtml) {
        Intrinsics.checkNotNullParameter(markdown, "markdown");
        Terminal.DefaultImpls.printMarkdown(this, markdown, showHtml);
    }

    @Override
    @NotNull
    public String renderMarkdown(@NotNull String markdown, boolean showHtml) {
        Intrinsics.checkNotNullParameter(markdown, "markdown");
        return Terminal.DefaultImpls.renderMarkdown(this, markdown, showHtml);
    }

    @Override
    @NotNull
    public Renderable parseMarkdown(@NotNull String markdown, boolean showHtml) {
        Intrinsics.checkNotNullParameter(markdown, "markdown");
        return Terminal.DefaultImpls.parseMarkdown(this, markdown, showHtml);
    }

    @Override
    public void success(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        Terminal.DefaultImpls.success(this, message, whitespace, align, overflowWrap2, width);
    }

    @Override
    public void danger(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        Terminal.DefaultImpls.danger(this, message, whitespace, align, overflowWrap2, width);
    }

    @Override
    public void warning(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        Terminal.DefaultImpls.warning(this, message, whitespace, align, overflowWrap2, width);
    }

    @Override
    @NotNull
    public String renderWarning(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        return Terminal.DefaultImpls.renderWarning(this, message, whitespace, align, overflowWrap2, width);
    }

    @Override
    public void info(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        Terminal.DefaultImpls.info(this, message, whitespace, align, overflowWrap2, width);
    }

    @Override
    public void muted(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        Terminal.DefaultImpls.muted(this, message, whitespace, align, overflowWrap2, width);
    }

    @Override
    public void print(@Nullable Object message, @NotNull TextStyle style, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter(style, "style");
        Intrinsics.checkNotNullParameter((Object)whitespace, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        Terminal.DefaultImpls.print(this, message, style, whitespace, align, overflowWrap2, width);
    }

    @Override
    public void print(@NotNull Renderable renderable) {
        Intrinsics.checkNotNullParameter(renderable, "renderable");
        Terminal.DefaultImpls.print(this, renderable);
    }

    @Override
    @NotNull
    public String renderSuccess(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        return Terminal.DefaultImpls.renderSuccess(this, message, whitespace, align, overflowWrap2, width);
    }

    @Override
    @NotNull
    public String renderDanger(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        return Terminal.DefaultImpls.renderDanger(this, message, whitespace, align, overflowWrap2, width);
    }

    @Override
    @NotNull
    public String renderInfo(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        return Terminal.DefaultImpls.renderInfo(this, message, whitespace, align, overflowWrap2, width);
    }

    @Override
    @NotNull
    public String renderMuted(@Nullable Object message, @NotNull Whitespace whitespace, @NotNull TextAlign align, @NotNull OverflowWrap overflowWrap2, @Nullable Integer width) {
        Intrinsics.checkNotNullParameter((Object)whitespace, "whitespace");
        Intrinsics.checkNotNullParameter((Object)align, "align");
        Intrinsics.checkNotNullParameter((Object)overflowWrap2, "overflowWrap");
        return Terminal.DefaultImpls.renderMuted(this, message, whitespace, align, overflowWrap2, width);
    }
}

