/* 
   copy runscr.exe to script.exe.
   public domain.
*/
#include <kpathsea/config.h>
#include <kpathsea/kpathsea.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <process.h>

#define SBUF   256
#define LBUF   1024
#define MAXARG 256

static int is_include_space(char *s)
{
  char *p;
  p = strchr(s, ' ');
  if(p) return 1;
  p = strchr(s, '\t');
  if(p) return 1;
  return 0;
}

char *getlname(char *name)
{
  char *path = NULL;
  char buff[SBUF];
  char buff2[SBUF];
  char *p, *fp;
  char *ptr, *tptr;

  strcpy(buff, name);
  for(p = buff; *p; p++) {
    if(IS_KANJI(p)) {
      p++;
      continue;
    }
    if(*p == '\\') *p = '/';
  }
  fp = buff;
  if(p = strrchr(fp, '/')) {
    p++;
    fp = p;
  }
  if(p = strrchr(fp, ':')) {
    p++;
    fp = p;
  }
  if((p = strrchr(fp, '.')) && (stricmp(p, ".exe") == 0))
    *p = '\0';
  strcpy(buff2, fp);
  strcat(buff2, ".exe");

  tptr = xstrdup(getenv("PATH"));
  for (ptr = tptr; *ptr; ptr++) {
    if(IS_KANJI(ptr)) {
      ptr++;
      continue;
    }
    if (*ptr == '\\') *ptr = '/';
  }

  ptr = tptr;
  for (p = tptr; *p ; p++) {
    if(*p == ';') {
      *p = '\0';
      while (*(ptr + strlen(ptr) - 1) == '/')
        *(ptr + strlen(ptr) - 1) = '\0';
      strcpy(buff, ptr);
      strcat(buff, "/");
      strcat(buff, buff2);
      if (_access(buff, 0) == 0) {
        path = xmalloc(strlen(ptr) + 1);
        strcpy(path, ptr);
        break;
      }
      ptr = p + 1;
    }
  }

  if(path == NULL) {
    while (*(ptr + strlen(ptr) - 1) == '/')
      *(ptr + strlen(ptr) - 1) = '\0';
    strcpy(buff, ptr);
    strcat(buff, "/");
    strcat(buff, buff2);
    if (_access(buff, 0) == 0) {
      path = xmalloc(strlen(ptr) + 1);
      strcpy(path, ptr);
    }
  }

  free(tptr);

  return path;
}

/* search for the script in the TeX bin directory */
int searchscr1(char *path, char *name, char *ext, char *dstname,
                int *interpreter, int val)
{
  char *fname;
  int  ret = 0;
  fname = concatn(path, "/", name, ext, NULL);
  if(_access(fname, 0) == 0) {
    strcpy(dstname, fname);
    *interpreter = val;
    ret = 1;
  }
  free(fname);
  return ret;
}

/* search for the script under $TEXMF/scripts// */
int searchscr2(char *name, char *ext, char *dstname,
                int *interpreter, int val)
{
  char *fname, *fullname;
  int  ret = 0;
  fname = concat(name, ext);
  fullname = kpse_find_file(fname, kpse_texmfscripts_format, 1);
  if(fullname) {
    strcpy(dstname, fullname);
    free(fullname);
    *interpreter = val;
    ret = 1;
  }
  free(fname);
  return ret;
}

__declspec(dllexport) int dllrunscrmain(int ac, char **av)
{
  int  i, ret;
  char *argv[MAXARG];
  char *p, *q;
  char *av0;
  char scrname[SBUF];
  FILE *f;
  char option[LBUF];
  int  interpreter;
  char cmdname[128];
  char cmdname2[128];
  int  use1stline = 0;

  char *fullcmdname;

  for(i=0; i < MAXARG; i++)
    argv[i] = NULL;

  kpse_set_program_name(av[0], NULL);
  av0 = kpse_program_name;

  if(stricmp(av0, "repstopdf") == 0) {
    strcpy(av0, "epstopdf");
    argv[3] = xmalloc(13);
    strcpy(argv[3], "--restricted");
  } else if(stricmp(av0, "rpdfcrop") == 0) {
    strcpy(av0, "pdfcrop");
    argv[3] = xmalloc(13);
    strcpy(argv[3], "--restricted");
  } else if(stricmp(av0, "latexdef") == 0) {
    strcpy(av0, "texdef");
    argv[3] = xmalloc(12);
    strcpy(argv[3], "--tex=latex");
  } else if(stricmp(av0, "cllualatex") == 0) {
    strcpy(av0, "cluttex");
    argv[3] = xmalloc(18);
    strcpy(argv[3], "--engine=lualatex");
  } else if(stricmp(av0, "clxelatex") == 0) {
    strcpy(av0, "cluttex");
    argv[3] = xmalloc(17);
    strcpy(argv[3], "--engine=xelatex");
  } else {
    argv[3] = xmalloc(2);
    strcpy(argv[3], " ");
  }

  cmdname[0] = '\0';
  cmdname2[0] = '\0';

  if(ac>MAXARG - 5) {
    fprintf(stderr, "Too many arguments.\n");
    exit (100);
  }

  p = getlname(av0);
  if(!p) {
    fprintf(stderr, "Failed to find script loader.\n");
    exit (100);
  }

  scrname[0] = '\0';

/* first search for script in the bin directory */
/* perl or generic (no suffix, .pl, .plx, .scr) */
  if(searchscr1(p, av0, "", scrname, &interpreter, 0))
    goto Found;
  if(searchscr1(p, av0, ".pl", scrname, &interpreter, 0))
    goto Found;
  if(searchscr1(p, av0, ".plx", scrname, &interpreter, 0))
    goto Found;
  if(searchscr1(p, av0, ".scr", scrname, &interpreter, 0))
    goto Found;

/* ruby (suffix .rb) */
  if(searchscr1(p, av0, ".rb", scrname, &interpreter, 1))
    goto Found;

/* python (suffix .py) */
  if(searchscr1(p, av0, ".py", scrname, &interpreter, 2))
    goto Found;

/* texlua (suffixes .lua, .tlu, .texlua) */
  if(searchscr1(p, av0, ".lua", scrname, &interpreter, 3))
    goto Found;
  if(searchscr1(p, av0, ".tlu", scrname, &interpreter, 3))
    goto Found;
  if(searchscr1(p, av0, ".texlua", scrname, &interpreter, 3))
    goto Found;

/* jarfile (suffix .jar) */
  if(searchscr1(p, av0, ".jar", scrname, &interpreter, 4))
    goto Found;

/* search script under $TEXMF/scripts */
/* perl */
  if(searchscr2(av0, ".pl", scrname, &interpreter, 0))
    goto Found;

/* ruby */
  if(searchscr2(av0, ".rb", scrname, &interpreter, 1))
    goto Found;

/* python */
  if(searchscr2(av0, ".py", scrname, &interpreter, 2))
    goto Found;

/* lua */
  if(searchscr2(av0, ".lua", scrname, &interpreter, 3))
    goto Found;
  if(searchscr2(av0, ".tlu", scrname, &interpreter, 3))
    goto Found;
  if(searchscr2(av0, ".texlua", scrname, &interpreter, 3))
    goto Found;

/* java */
  if(searchscr2(av0, ".jar", scrname, &interpreter, 4))
    goto Found;

/* general suffix .scr (assume perl) */
  if(searchscr2(av0, ".scr", scrname, &interpreter, 0))
    goto Found;

/* no suffix (assume perl) */
  if(searchscr2(av0, "", scrname, &interpreter, 0))
    goto Found;

/* in all other cases, we should use #! feature */
/* --- */

  if(!scrname[0]) {
    fprintf(stderr, "Failed to find script.\n");
    exit (100);
  }

/* read the first line of the script */
 Found:

  f = fopen(scrname, "r");
  if(!f) {
    fprintf(stderr, "No script.\n");
    exit (100);
  }

  for(i=0; i < LBUF; i++)
    option[i] = '\0';

  fgets(option, LBUF-1, f);
  fclose(f);
  i = (int)strlen(option);
  if(option[i-1] == '\n') option[i-1] = '\0';

/* we save options for interpreter in argv[1] */

  argv[1] = NULL;
  if((strstr(option, "perl")) ||
     (strstr(option, "Perl"))) {
    use1stline = 0;
    interpreter = 0;
  } else if(*option == '#' && *(option + 1) == '!') {
    p = option + 2;
    while(*p == ' ' || *p == '\t')
      p++;
    if(*p) {
      use1stline = 1;
      q = p;
      while(*p != ' ' && *p != '\t' && *p != '\0')
        p++;
      *p = '\0';
      strcpy(cmdname2, q);
      q = strrchr(cmdname2, '/');
      if (q) q++;
      else q = cmdname2;
      strcpy(cmdname, q);
      if(stricmp(cmdname, "env") == 0) {
        p++;
        while(*p == ' ' || *p == '\t')
          p++;
        q = p;
        while(*p != ' ' && *p != '\t' && *p != '\0')
          p++;
        *p = '\0';
        if(*q == '\0')
          use1stline = 0;
        else
          strcpy(cmdname, q);
      }
      p++;
      while(*p == ' ' || *p == '\t')
        p++;
      if(*p) {
        argv[1] = xmalloc(strlen(p) + 1);
        strcpy(argv[1], p);
      } else {
        argv[1] = xmalloc(2);
        strcpy(argv[1], " ");
      }
    }
  }

  if(!argv[1]) {
    argv[1] = xmalloc(2);
    strcpy(argv[1], " ");
  }

  if(use1stline) {
    if((q = strstr(cmdname, "perl")))
      interpreter = 0;
    else
      interpreter = 10000;
  }

  if(!use1stline) {
    if(interpreter == 0)
      strcpy(cmdname, "perl.exe");
    else if(interpreter == 1)
      strcpy(cmdname, "ruby.exe");
    else if(interpreter == 2)
      strcpy(cmdname, "python.exe");
    else if(interpreter == 3)
      strcpy(cmdname, "texlua.exe");
    else if(interpreter == 4)
      strcpy(cmdname, "java.exe");
    else {
      fprintf(stderr, "Unknown interpreter.\n");
      exit(100);
    }
  }

  if (interpreter == 4 ||
      (interpreter == 10000 && strstr(cmdname, "java"))) {
    free(argv[1]);
    argv[1] = xmalloc(5);
    strcpy(argv[1], "-jar");
  }

  if((p = getlname(cmdname)) == NULL) {
    fprintf(stderr, "Script interpreter is not found in PATH.\n");
    exit (100);
  }

  if ((strstr(cmdname, ".exe") == NULL) &&
      (strstr(cmdname, ".EXE") == NULL))
    strcat(cmdname, ".exe");

  argv[0] = xmalloc(strlen(cmdname) + 1);
  strcpy(argv[0], cmdname);
  if(is_include_space(scrname)) {
    argv[2] = concat3("\"", scrname, "\"");
  } else {
    argv[2] = xmalloc(strlen(scrname) + 1);
    strcpy(argv[2], scrname);
  }

  for(i=1; i < ac; i++) {
    if(is_include_space(av[i]) || strcmp(av[i], "") == 0) {
      argv[i+3] = concat3("\"", av[i], "\"");
    } else {
      argv[i+3] = xmalloc(strlen(av[i]) + 1);
      strcpy(argv[i+3], av[i]);
    }
  }
  argv[ac+3] = NULL;

  fullcmdname = concat3(p, "/", cmdname);


/*
fprintf(stderr, "\n%s\n", fullcmdname); 
for(i=0; i < ac + 3; i++) {
  if(argv[i])
    fprintf(stderr, "%s\n", argv[i]);
  else
    break;
}
exit (0);
*/


  ret = _spawnvp(_P_WAIT, fullcmdname, argv);

  free(fullcmdname);
  for(i=0; i < ac + 3; i++) {
    if(argv[i])
      free(argv[i]);
    else
      break;
  }

  return ret;
}
