/********************************************************************
*
* $Workfile:$
* $Revision: 1.1 $
* $Modtime:$
* $Author: svenwiegand $
*
* nderungen:
*	$History:$
*
*********************************************************************/

/********************************************************************
*
* Declarations for files generated by COM Interface Wrapper Wizard
* (CIWW)
*
* Copyright  2001 Sven Wiegand (sven.wiegand@web.de)
*
********************************************************************/


//-------------------------------------------------------------------
// class CInterfaceImplementationWrapper
//-------------------------------------------------------------------

template<class T>
CInterfaceImplementationWrapper<T>::CInterfaceImplementationWrapper(AFX_MODULE_STATE *pModuleState, BOOL bNoDelete /*= FALSE*/)
:	m_pModuleState(pModuleState),
	m_pGetModuleStateFunction(NULL),
	m_lRef(1),
	m_bNoDelete(bNoDelete),
	m_pOwner(NULL)
{
	ASSERT(m_pModuleState);
}


template<class T>
CInterfaceImplementationWrapper<T>::CInterfaceImplementationWrapper(GET_MODULE_STATE_FUNCTION pGetModuleStateFunction, BOOL bNoDelete /*= FALSE*/)
:	m_pModuleState(NULL),
	m_pGetModuleStateFunction(pGetModuleStateFunction),
	m_lRef(1),
	m_bNoDelete(bNoDelete),
	m_pOwner(NULL)
{
	ASSERT(m_pGetModuleStateFunction);
}


template<class T>
CInterfaceImplementationWrapper<T>::CInterfaceImplementationWrapper(AFX_MODULE_STATE *pModuleState, IUnknown *pOwner)
:	m_pModuleState(pModuleState),
	m_pGetModuleStateFunction(NULL),
	m_lRef(1),
	m_bNoDelete(FALSE)
{
	ASSERT(m_pModuleState);
	ASSERT(pOwner);
	m_pOwner = pOwner;
}


template<class T>
CInterfaceImplementationWrapper<T>::CInterfaceImplementationWrapper(GET_MODULE_STATE_FUNCTION pGetModuleStateFunction, IUnknown *pOwner)
:	m_pModuleState(NULL),
	m_pGetModuleStateFunction(pGetModuleStateFunction),
	m_lRef(1),
	m_bNoDelete(FALSE)
{
	ASSERT(m_pGetModuleStateFunction);
	ASSERT(pOwner);
	m_pOwner = pOwner;
}


template<class T>
CInterfaceImplementationWrapper<T>::~CInterfaceImplementationWrapper()
{
	// your AddRef()/Release() calls are not well balanced
	ASSERT(m_pOwner || (m_bNoDelete && m_lRef == 1) || (!m_bNoDelete && m_lRef == 0));
}


template<class T>
void CInterfaceImplementationWrapper<T>::SetOwner(IUnknown *pOwner)
{
	m_pOwner = pOwner;
}


template<class T>
CInterfaceImplementationWrapper<T>::operator T*()
{
	return GetInterface();
}


template<class T>
IUnknown* CInterfaceImplementationWrapper<T>::GetInterfaceById(REFIID riid)
{
	if (riid == IID_IUnknown)
		return GetInterface();
	else if (riid == __uuidof(T))
		return GetInterface();
	else
		return NULL;
}


template<class T>
ULONG CInterfaceImplementationWrapper<T>::NonDelegatingAddRef()
{
	LONG	lRef = InterlockedIncrement((long*)&m_lRef);
	if (m_bNoDelete)
		return 2;
	else
		return lRef;
}


template<class T>
ULONG CInterfaceImplementationWrapper<T>::NonDelegatingRelease()
{
	// your AddRef()/Release() calls are not well balanced
	ASSERT(m_lRef > 0);

	ULONG	lRef = InterlockedDecrement((long*)&m_lRef);

	if (m_bNoDelete)
		return 1;

	if (lRef == 0)
		delete this;

	return lRef;
}


template<class T>
HRESULT CInterfaceImplementationWrapper<T>::NonDelegatingQueryInterface(REFIID riid, void **ppv)
{
	// use internal implementation
	if (ppv == NULL)
		return E_FAIL;

	*ppv = GetInterfaceById(riid);

	if (*ppv == NULL)
		return E_NOINTERFACE;

	AddRef();
	return S_OK;
}


template<class T>
ULONG CInterfaceImplementationWrapper<T>::AddRef()
{
	if (m_pOwner)
		return m_pOwner->AddRef();
	else
		return NonDelegatingAddRef();
}


template<class T>
ULONG CInterfaceImplementationWrapper<T>::Release()
{
	if (m_pOwner)
		return m_pOwner->Release();
	else
		return NonDelegatingRelease();
}


template<class T>
HRESULT CInterfaceImplementationWrapper<T>::QueryInterface(REFIID riid, void **ppv)
{
	if (m_pOwner)
		return m_pOwner->QueryInterface(riid, ppv);
	else
		return NonDelegatingQueryInterface(riid, ppv);
}


template<class T>
AFX_MODULE_STATE* CInterfaceImplementationWrapper<T>::GetModuleState()
{
	if (m_pModuleState)
		return m_pModuleState;
	else if (m_pGetModuleStateFunction)
		return m_pGetModuleStateFunction();
	else
	{
		ASSERT(FALSE);
		return NULL;
	}
}

//-------------------------------------------------------------------
// class CDispatchInterfaceImplementationWrapper
//-------------------------------------------------------------------

template<class T>
CDispatchInterfaceImplementationWrapper<T>::CDispatchInterfaceImplementationWrapper(AFX_MODULE_STATE *pModuleState, REFGUID rguidTypeLibrary, USHORT usVerMajor, USHORT usVerMinor, BOOL bNoDelete /*= FALSE*/)
:	CInterfaceImplementationWrapper<T>(pModuleState, bNoDelete)
{
	InitTypeInfo(rguidTypeLibrary, usVerMajor, usVerMinor);
}


template<class T>
CDispatchInterfaceImplementationWrapper<T>::CDispatchInterfaceImplementationWrapper(GET_MODULE_STATE_FUNCTION pGetModuleStateFunction, REFGUID rguidTypeLibrary, USHORT usVerMajor, USHORT usVerMinor, BOOL bNoDelete /*= FALSE*/)
:	CInterfaceImplementationWrapper<T>(pGetModuleStateFunction, bNoDelete)
{
	InitTypeInfo(rguidTypeLibrary, usVerMajor, usVerMinor);
}


template<class T>
CDispatchInterfaceImplementationWrapper<T>::CDispatchInterfaceImplementationWrapper(AFX_MODULE_STATE *pModuleState, REFGUID rguidTypeLibrary, USHORT usVerMajor, USHORT usVerMinor, IUnknown *pOwner)
:	CInterfaceImplementationWrapper<T>(pModuleState, pOwner)
{
	InitTypeInfo(rguidTypeLibrary, usVerMajor, usVerMinor);
}


template<class T>
CDispatchInterfaceImplementationWrapper<T>::CDispatchInterfaceImplementationWrapper(GET_MODULE_STATE_FUNCTION pGetModuleStateFunction, REFGUID rguidTypeLibrary, USHORT usVerMajor, USHORT usVerMinor, IUnknown *pOwner)
:	CInterfaceImplementationWrapper<T>(pGetModuleStateFunction, pOwner)
{
	InitTypeInfo(rguidTypeLibrary, usVerMajor, usVerMinor);
}


template<class T>
CDispatchInterfaceImplementationWrapper<T>::~CDispatchInterfaceImplementationWrapper()
{
	m_pTypeInfo->Release();
}


template<class T>
HRESULT CDispatchInterfaceImplementationWrapper<T>::GetTypeInfoCount(UINT *pctinfo)
{
	ASSERT(pctinfo);
	*pctinfo = 1;
	return S_OK;
}


template<class T>
HRESULT CDispatchInterfaceImplementationWrapper<T>::GetTypeInfo(UINT iTInfo, LCID lcid, ITypeInfo **ppTInfo)
{
	ASSERT(iTInfo == 0 && ppTInfo != 0);
	(*ppTInfo = m_pTypeInfo)->AddRef();
	return S_OK;
}


template<class T>
HRESULT CDispatchInterfaceImplementationWrapper<T>::GetIDsOfNames(REFIID riid, LPOLESTR *rgszNames, UINT cNames, LCID lcid, DISPID *rgid)
{
	ASSERT(riid == IID_NULL);
	return m_pTypeInfo->GetIDsOfNames(rgszNames, cNames, rgid);
}


template<class T>
HRESULT CDispatchInterfaceImplementationWrapper<T>::Invoke(DISPID id, REFIID riid, LCID lcid, WORD wFlags, DISPPARAMS *pDispParams, VARIANT *pVarResult, EXCEPINFO *pExcepInfo, UINT *puArgErr)
{
	ASSERT(riid == IID_NULL);
	return m_pTypeInfo->Invoke((PVOID)GetInterface(), id, wFlags, pDispParams, pVarResult, pExcepInfo, puArgErr);
}


template<class T>
IUnknown* CDispatchInterfaceImplementationWrapper<T>::GetInterfaceById(REFIID riid)
{
	if (riid == IID_IDispatch)
		return GetInterface();
	else
		return CInterfaceImplementationWrapper<T>::GetInterfaceById(riid);
}


template<class T>
void CDispatchInterfaceImplementationWrapper<T>::InitTypeInfo(REFGUID rguidTypeLibrary, USHORT usVerMajor, USHORT usVerMinor)
{
	ITypeLib	*ptl = 0;
	HRESULT hr = LoadRegTypeLib(rguidTypeLibrary, usVerMajor, usVerMinor, 0, &ptl);
	ASSERT(SUCCEEDED(hr));
	if (!SUCCEEDED(hr))
		AfxThrowComException(hr);

	hr = ptl->GetTypeInfoOfGuid(__uuidof(T), &m_pTypeInfo);
	ptl->Release();
	ASSERT(SUCCEEDED(hr));
	if (!SUCCEEDED(hr))
		AfxThrowComException(hr);
}


//-------------------------------------------------------------------
// class CInterfaceCallingWrapper
//-------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////
// construction/destruction

template<class T>
CInterfaceCallingWrapper<T>::CInterfaceCallingWrapper()
{}


template<class T>
CInterfaceCallingWrapper<T>::CInterfaceCallingWrapper(T *p, BOOL bIncrementRefCount /*= FALSE*/)
{
	Attach(p, bIncrementRefCount);
}


template<class T>
CInterfaceCallingWrapper<T>::CInterfaceCallingWrapper(const CInterfaceCallingWrapper<T> &iw)
:	m_p(iw.GetP())
{}


template<class T>
CInterfaceCallingWrapper<T>::CInterfaceCallingWrapper(IUnknown *pUnknown, BOOL bIncrementRefCount /*= FALSE*/, BOOL bThrowException /*= FALSE*/)
{
	if (!pUnknown)
	{
		if (bThrowException)
			AfxThrowComException(E_POINTER);
		return;
	}

	T				*p;
	HRESULT	hr = pUnknown->QueryInterface(__uuidof(T), (void**)&p);
	if (hr == S_OK)
	{
		Attach(p, bIncrementRefCount);
		p->Release();	// decrement what QueryInterface() has incremented
	}
	else if (bThrowException)
		AfxThrowComException(hr);
}


template<class T>
CInterfaceCallingWrapper<T>::~CInterfaceCallingWrapper()
{}

/////////////////////////////////////////////////////////////////////
// operators

template<class T>
CInterfaceCallingWrapper<T>::operator T*()
{
	return m_p;
}


template<class T>
T& CInterfaceCallingWrapper<T>::operator*()
{
	return *m_p;
}


template<class T>
T* CInterfaceCallingWrapper<T>::operator->()
{
	return m_p.p;
}


template<class T>
T* CInterfaceCallingWrapper<T>::operator=(T *p)
{
	Attach(p, TRUE);
	return m_p;
}


template<class T>
bool CInterfaceCallingWrapper<T>::operator!() const
{
	return !m_p;
}


template<class T>
bool CInterfaceCallingWrapper<T>::operator==(T *p) const
{
	return p == m_p.p;
}


/////////////////////////////////////////////////////////////////////
// operations

template<class T>
BOOL CInterfaceCallingWrapper<T>::Attach(T *p, BOOL bIncrementRefCount /*= FALSE*/)
{
	// There is already an interface attached.
	// Call Detach() first.
	ASSERT(!m_p);
	if (m_p)
		return FALSE;
	
	if (!p)
		return FALSE;

	m_p.Attach(p);
	if (bIncrementRefCount)
		m_p.p->AddRef();

	return TRUE;
}


template<class T>
T* CInterfaceCallingWrapper<T>::Detach(BOOL bDecrementRefCount /*= FALSE*/)
{
	if (m_p && bDecrementRefCount)
		m_p.p->Release();

	return m_p.Detach();
}


template<class T>
T* CInterfaceCallingWrapper<T>::CopyTo()
{
	T	*p;
	if (m_p.CopyTo(&p) == S_OK)
		return p;
	else
		return NULL;
}


template<class T>
HRESULT CInterfaceCallingWrapper<T>::CoCreateInstance(REFCLSID rclsid, LPUNKNOWN pUnkOuter /*= NULL*/, DWORD dwClsContext /*= CLSCTX_ALL*/)
{
	return m_p.CoCreateInstance(rclsid, pUnkOuter, dwClsContext);
}


template<class T>
HRESULT CInterfaceCallingWrapper<T>::CoCreateInstance(LPCTSTR lpszProgId, LPUNKNOWN pUnkOuter /*= NULL*/, DWORD dwClsContext /*= CLSCTX_ALL*/)
{
	BSTR		bstrProgId = CString(lpszProgId).AllocSysString();
	HRESULT	hr = m_p.CoCreateInstance(bstrProgId, pUnkOuter, dwClsContext);
	SysFreeString(bstrProgId);
	return hr;
}


template<class T>
IUnknown* CInterfaceCallingWrapper<T>::QueryInterface(REFIID riid, BOOL bThrowException /*= FALSE*/)
{
	IUnknown	*p = NULL;
	HRESULT		hr = m_p.p->QueryInterface(riid, (void**)&p);
	if (hr != S_OK && bThrowException)
		AfxThrowComException(hr, m_p.p, &__uuidof(T));

	return p;
}


template<class T>
T* CInterfaceCallingWrapper<T>::P()
{
	return m_p;
}


template<class T>
T* CInterfaceCallingWrapper<T>::GetP() const
{
	return m_p;
}


//-------------------------------------------------------------------
// class CCoClass
//-------------------------------------------------------------------

template<class T>
CCoClassWrapper<T>::CCoClassWrapper(REFCLSID ClsId)
:	m_ClsId(ClsId)
{}


template<class T>
CCoClassWrapper<T>::~CCoClassWrapper()
{}


template<class T>
HRESULT CCoClassWrapper<T>::Create(DWORD dwClassContext /*= CLSCTX_ALL*/)
{
	ASSERT(!m_p);
	if (m_p)
		return E_FAIL;

	return m_p.CoCreateInstance(m_ClsId, NULL, dwClassContext);
}


template<class T>
void CCoClassWrapper<T>::Detach()
{
	ASSERT(m_p);
	if (!m_p)
		return;

	m_p.Release();
	m_p.Detach();
}


template<class T>
T* CCoClassWrapper<T>::DefaultInterface()
{
	return m_p;
}