---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, symboles,  
              opérateur de logique floue, opérateur, logique floue
---

# Où trouver des opérateurs de logique floue ?

Voici ce que propose Vincent Henn le 12 avril 1995 pour avoir 
des commandes simples générant ces opérateurs (avec une légère mise à jour
des extensions et commandes pour les adapter aux commandes actuelles).  
Le code a été mis à jour pour utiliser `babel` puisque l'option 
de classe `french` est passée, et pour utiliser `fontenc` avec encodage `T1`.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

  \newcommand{\fmin}{\mathop{\flou{\min }}}
  \newcommand{\fmax}{\mathop{\flou{\max }}}
  \newcommand{\V}{\mathop{\mathrm V\kern 0pt}}
  \newcommand{\ET}{\mathrel{\mathrm{ET}}}
  \newcommand{\OU}{\mathrel{\mathrm{OU}}}
  \newcommand{\Sim}{\mathop{\mathrm S \kern 0pt}}
  \newcommand{\hauteur}{\mathop{\mathrm h\kern 0pt}}
  \newcommand{\card}[1]{\| #1 \|}
  \newcommand{\flou}[1]{\ensuremath{\widetilde{#1}}}
  \newcommand{\Poss}{\mathop{\Pi}}
  \newcommand{\Nec}{\mathop{\mathrm N\kern 0pt}}
  \newcommand{\poss}{\operatorname{Poss}}
  \newcommand{\nec}{\operatorname{Nec}}
  \newcommand{\serie}[3]{%
  %  #1 -> le nom de la variable
  %  #2 -> l'indice de début
  %  #3 -> l'indice de fin
  \ensuremath{{#1}_{#2},\ldots,{#1}_{#3}}}

\begin{document}
Voici les différentes commandes générées par ces définitions :
\begin{itemize}
  \item $\fmin$, $\fmax$ ;
  \item $V$, $\ET$, $\OU$ ;
  \item $\Sim$ ;
  \item $\hauteur$ ;
  \item $\card{A}$, $\flou{A}$ ;
  \item $\Poss$, $\poss$ ;
  \item $\Nec$, $\nec$ ;
  \item $\serie{x}{1}{n}$.
\end{itemize}
\end{document}
```