%%
%% This is file `armymemo.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% armymemo.dtx  (with options: `package')
%% 
%% This is a generated file.
%% 
%% Copyright (C) 2011 George L. Allen
%% Copyright (C) 2019 Christian J. Sharpsten
%% 
%% This program is free software; you can redistribute it and/or modify
%% it under the terms of the GNU General Public License as published by
%% the Free Software Foundation; either version 2 of the License, or
%% (at your option) any later version.
%% 
%% This program is distributed in the hope that it will be useful,
%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%% GNU General Public License for more details.
%% 
%% You should have received a copy of the GNU General Public License along
%% with this program; if not, write to the Free Software Foundation, Inc.,
%% 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%% 
\NeedsTeXFormat{LaTeX2e}[2016/02/01]
\ProvidesPackage{armymemo}
    [2019/01/12 v1.0.0 U.S. Army Memorandum Class]
\LoadClass[letterpaper,12pt,oneside]{article}
\RequirePackage{datetime}
\RequirePackage{fancyhdr}
\RequirePackage{graphicx}
\RequirePackage{hanging}
\RequirePackage{tikz}
\RequirePackage[letterpaper,margin=1in,includefoot]{geometry}
\RequirePackage{fontspec}
\defaultfontfeatures{Mapping=tex-text}
\setmainfont{Arial}
\RequirePackage{ragged2e} \RaggedRight
\setlength{\parskip}{\baselineskip}
\setlength{\parindent}{0pt}
\widowpenalty=10000
\clubpenalty=10000
\brokenpenalty=10000
\newdateformat{armydate}{\THEDAY{} \monthname[\THEMONTH] \THEYEAR}
\newcommand*{\department}[1]{\gdef\am@department{#1}}
\newcommand*{\unit}[1]{\gdef\am@unit{#1}}
\newcommand*{\unitaddress}[1]{\gdef\am@unitaddress{#1}}
\newcommand*{\unitcity}[1]{\gdef\am@unitcity{#1}}
\department{DEPARTMENT OF THE ARMY}
\newcommand*{\am@unit}{\ClassError{armymemo}{No \@backslashchar unit given}{}}
\newcommand*{\am@unitaddress}{\ClassError{armymemo}{No \@backslashchar unitaddress given}{}}
\newcommand*{\am@unitcity}{\ClassError{armymemo}{No \@backslashchar unitcity given}{}}
\newcommand*{\officesymbol}[1]{\gdef\am@officesymbol{#1}}
\newcommand*{\memothru}[1]{\gdef\am@memothru{#1}}
\newcommand*{\memofor}[1]{\gdef\am@memofor{#1}}
\newcommand*{\subject}[1]{\gdef\am@subject{#1}}
\newcommand*{\enclosures}[1]{\gdef\am@enclosures{#1}}
\newcommand*{\am@officesymbol}{\ClassError{armymemo}{No \@backslashchar officesymbol given}{}}
\global\let\am@memothru\relax     % optional
\newcommand*{\am@memofor}{\ClassError{armymemo}{No \@backslashchar memofor given}{}}
\newcommand*{\am@subject}{\ClassError{armymemo}{No \@backslashchar subject given}{}}
\global\let\am@enclosures\relax   % optional
\newcounter{ami}
\newcounter{amii}[ami]
\newcounter{amiii}[amii]
\newcommand*{\@amitem}[2]{\hspace{#1}\makebox[0.25in][l]{#2}}
\newcommand*{\ami}{\refstepcounter{ami}\@amitem{0in}{\arabic{ami}. }}
\newcommand*{\amii}{\refstepcounter{amii}\@amitem{0.25in}{\alph{amii}. }}
\newcommand*{\amiii}{\refstepcounter{amiii}\@amitem{0.5in}{(\arabic{amiii}) }}
\newcommand{\makeheader}{
  \thispagestyle{plain}
  \pagestyle{body}
  \am@officesymbol\hfill\armydate\@date\\~\\~\\
  \ifdefvoid{\am@memothru}{
    MEMORANDUM FOR \am@memofor\\~\\
  }{
    MEMORANDUM THRU \am@memothru\\~\\
    FOR \am@memofor\\~\\
  }
  SUBJECT: \am@subject\\~\\~\\
}
\newcommand{\makesigblock}[3]{
  \setlength{\parskip}{0pt}
  \begin{minipage}[t]{\textwidth}
    \vspace{3\baselineskip}
    \ifdefvoid{\am@enclosures}{}{
      \parbox[t]{0.28\textwidth}{Encl:\\
        \begin{hangparas}{0.25in}{1}
          \am@enclosures
        \end{hangparas}
      }
    }
    \hfill\parbox[t]{0.5\textwidth}{%
      \MakeUppercase{#1}\\
      \MakeUppercase{#2}\\
      #3
    }
  \end{minipage}
}
\fancypagestyle{plain}{
  \fancyhf{}
  \setlength{\headheight}{56pt}

  \lhead{
    {\begin{tikzpicture}[remember picture, overlay]
      \node[yshift=20pt] at (0,0) {\includegraphics[height=1in]{dodlogo.eps}};
    \end{tikzpicture}}
  }

  \chead{
    {\begin{sffamily}\begin{bfseries}
      {\footnotesize\MakeUppercase{\am@department}} \\
      {\scriptsize
        \MakeUppercase{\am@unit} \\
        \MakeUppercase{\am@unitaddress} \\
        \MakeUppercase{\am@unitcity} \\
      }
    \end{bfseries}\end{sffamily}}
  }

  \renewcommand{\headrulewidth}{0pt}
  \renewcommand{\footrulewidth}{0pt}
}
\fancypagestyle{body}{
  \setlength{\headheight}{30pt}

  \lhead[]{
    \am@officesymbol\\
    SUBJECT: \am@subject
  }
  \fancyfoot[C]{\thepage}

  \renewcommand{\headrulewidth}{0pt}
  \renewcommand{\footrulewidth}{0pt}
}
\endinput
%%
%% End of file `armymemo.cls'.
