/**/


call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


parse arg language texmf source options



say 'msg:Babel'


bin      = texmf||'\os2tex\bin'
tfm      = texmf||'\fonts\tfm'
tex      = texmf||'\tex'
doc      = texmf||'\doc'
fmt      = bin

target   = texmf||'\tex\generic\babel'

exec     = bin||'\tex.exe'


install = texmf||'\os2tex\install'


if Pos("InstallFiles", options) > 0 then do


   install||'\kdir '||target
   'md '||tex
   'md '||tex||'\generic'
   'md '||tex||'\generic\babel'

   if directory(texmf||'\tex\generic')="" then do
      say "err:Beim Verzeichniswechsel nach "||texmf||"\tex\generic ist ein Fehler aufgetreten!"
      exit 1
   end



   install||'\unzip '||source||'\l2babel.zip'


   say 'msg:Babel babel.ins'

   exec||' -pf '||bin||' -po '||target||' -pi '||target||';'||tex||'\latex\base;'||bin||' '||'babel.ins'


   if directory(texmf)="" then do
      say "err:Beim Verzeichniswechsel nach "||texmf||" ist ein Fehler aufgetreten!"
      exit 1
   end


   install||'\kdir doc\generic\babel'
   'md '||doc
   'md '||doc'\generic'
   'md '||doc'\generic\babel'

   'copy '||target||'\*.txt '||doc||'\generic\babel'
   'copy '||target||'\*.bbl '||doc||'\generic\babel'
   'copy '||target||'\*.dvi '||doc||'\generic\babel'

   'del '||target||'\*.txt'
   'del '||target||'\*.bbl'
   'del '||target||'\*.dvi'



/*

   do i=1 to 3

      say 'msg:Erzeuge Babel-Referenzhandbuch Lauf 'i' von 3'
      exec||' -r -ff latex.fmt -pf '||bin||' -po '||doc||'\latex\babel'||' -pi '||tex||';'||doc||'\latex\babel;'||bin||' -pt '||tfm||' '||'babel.drv'

   end


   do i=1 to 3

      if i=3 then do
         bin||'\makeindex '||doc||'\latex\babel\user.idx'
      end

      say 'msg:Erzeuge Babel-Benutzerhandbuch Lauf 'i' von 3'
      exec||' -r -ff latex.fmt -pf '||bin||' -po '||doc||'\latex\babel'||' -pi '||tex||';'||doc||'\latex\babel;'||bin||' -pt '||tfm||' '||'user.drv'

   end


*/


end


if Pos("CreateObjects", options) > 0 then do

   classname = 'WPProgram'
   objtitle  = 'babel [J. Braams]'
   location  = '<OS2TEX_MISC_FOLDER>'
   setup     = 'EXENAME='texmf'\os2tex\bin\dvi.exe;PROGTYPE=PM;STARTUPDIR='texmf'\os2tex\bin;OBJECTID=<OS2TEX_babel_user.dvi>;PARAMETERS='texmf'\doc\generic\babel\user.dvi'
   duplicate = 'replace'



   rc = SysCreateObject(classname,objtitle,location,setup,duplicate)

   if rc = 0 then do
      exit 1
   end

end



if Pos("InstallFiles", options) > 0 then do


   'del '||target||'\*.ins'
   'del '||target||'\*.dtx'

end






