/*# --------------------------------------------------------------------------
###  package    = "FTETX"
###  version    = "0.04"
###  date       = "1997/08/20"
###  filename   = "./CONTRIB/FTETX004/SRC/TXLAUNCH.003/fn.h"
###  local      = "NO"
### --------------------------------------------------------------------------
###  txlaunch-version = "0.03"
### -------------------------- Copyright (c) 1997, Oliver John von Zydowitz */

#ifndef __FN_H__
#define __FN_H__


/* --- EMX section --------------------------------------------------------- */
#ifdef __EMX__

#define _FN_MAX_DRIVE _MAX_DRIVE
#define _FN_MAX_DIR   _MAX_DIR
#define _FN_MAX_FNAME _MAX_FNAME
#define _FN_MAX_EXT   _MAX_EXT
#define _FN_MAX_PATH  _MAX_PATH

#endif /* __EMX__ */


/* --- DJGPP section ------------------------------------------------------ */
#ifdef __DJGPP__

#define _FN_MAX_DRIVE MAXDRIVE      /* maybe these should change        */
#define _FN_MAX_DIR   MAXDIR        /* Delories constants are a bit low */
#define _FN_MAX_FNAME MAXFILE       /* are they right ? */
#define _FN_MAX_EXT   MAXEXT
#define _FN_MAX_PATH  MAXPATH

#endif /* __DJGPP__ */


/* --- LINUX section --------------------------------------------------------- */
#ifdef __LINUX__

#define _FN_MAX_DRIVE 1            /* no drives, but space for a 0 */
#define _FN_MAX_DIR   PATH_MAX
#define _FN_MAX_FNAME NAME_MAX
#define _FN_MAX_EXT   NAME_MAX
#define _FN_MAX_PATH  PATH_MAX

#endif /* __LINUX__ */



/* ----------------------------------------------------------------------- */

void FN_SetPathDelim      (PSZ pszName, char delim);
void FN_MakeStd           (PSZ pszName);
void FN_GetAbsWD          (PPSZ pszCwd);
void FN_SetAbsWD          (PSZ  szCwd);
void FN_MakeAbs2          (PPSZ pszAbs, PSZ szRel, PSZ szFrom);
void FN_MakeAbs           (PPSZ pszAbs, PSZ szRel, PSZ szFrom);
void FN_MakeAbsPath       (PPSZ pszAbs, PSZ szRel, PSZ szFrom);
void FN_SplitPath         (PPSZ pszDrv, PPSZ pszPath, PPSZ pszBase, PPSZ pszExt,
                           PSZ szFileName );
void FN_GetName           (PPSZ pszName, PSZ szFileName);
void FN_GetDrvPath        (PPSZ pszDrvPath, PSZ szFileName);

#define FN_GetDrv(x,n)  FN_SplitPath(x, NULL, NULL, NULL, n)
#define FN_GetPath(x,n) FN_SplitPath(NULL, x, NULL, NULL, n)
#define FN_GetBase(x,n) FN_SplitPath(NULL, NULL, x, NULL, n)
#define FN_GetExt(x,n)  FN_SplitPath(NULL, NULL, NULL, x, n)

void FN_GetPath2          (PPSZ pszPath, PSZ szFileName);

#endif /* __FN_H__ */

/*------------------------------------------------------------------------- */
