/*
 * Decompiled with CFR 0.152.
 */
package nts.io;

import nts.io.CntxLoggable;
import nts.io.CntxLoggableEnum;
import nts.io.Log;

public final class CntxLog {
    private final int maxDepth;
    private final int maxCount;
    private final String prefix;
    private int count = 0;

    public void addItems(Log log, CntxLoggableEnum items) {
        if (this.prefix.length() <= this.maxDepth) {
            while (this.count <= this.maxCount && items.hasMoreContextLoggables()) {
                log.endLine().add(this.prefix);
                if (this.count++ == this.maxCount) {
                    log.add("etc.");
                    continue;
                }
                items.nextContextLoggable().addOn(log, this);
            }
        } else if (this.count <= this.maxCount && items.hasMoreContextLoggables()) {
            log.add(" []");
        }
    }

    private void addItem(Log log, CntxLoggable item) {
        if (this.prefix.length() <= this.maxDepth) {
            if (this.count <= this.maxCount) {
                log.endLine().add(this.prefix);
                if (this.count++ == this.maxCount) {
                    log.add("etc.");
                } else {
                    item.addOn(log, this);
                }
            }
        } else if (this.count <= this.maxCount) {
            log.add(" []");
        }
    }

    private CntxLog descendant(char p) {
        return new CntxLog(this.maxDepth, this.maxCount, this.prefix + p);
    }

    public void addOn(Log log, CntxLoggableEnum items, char p) {
        this.descendant(p).addItems(log, items);
    }

    public void addOn(Log log, CntxLoggable item, char p) {
        this.descendant(p).addItem(log, item);
    }

    public void addOn(Log log, CntxLoggableEnum items) {
        this.addOn(log, items, '.');
    }

    public void addOn(Log log, CntxLoggable item) {
        this.addOn(log, item, '.');
    }

    public static void addItems(Log log, CntxLoggableEnum items, int md, int mc) {
        new CntxLog(md, mc).addItems(log, items);
    }

    public static void addItem(Log log, CntxLoggable item, int md, int mc) {
        new CntxLog(md, mc).addItem(log, item);
    }

    private CntxLog(int md, int mc, String p) {
        this.maxDepth = md;
        this.maxCount = mc;
        this.prefix = p;
    }

    private CntxLog(int md, int mc) {
        this.maxDepth = md;
        this.maxCount = mc;
        this.prefix = "";
    }
}

