/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import nts.base.BoolPar;
import nts.command.AssignPrim;
import nts.command.CommandBase;
import nts.command.FrozenToken;
import nts.command.InpTokChecker;
import nts.command.Macro;
import nts.command.MacroBody;
import nts.command.PrefixPrim;
import nts.command.ReadInput;
import nts.command.ReadToksChecker;
import nts.command.SentinelToken;
import nts.command.Token;
import nts.command.Tokenizer;

public class ReadPrim
extends AssignPrim {
    private transient HashMap table;
    private final Token FROZEN_END_READ = new FrozenToken("endread", null);

    private void initTable() {
        this.table = new HashMap(23);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.initTable();
    }

    public ReadInput get(int num) {
        return (ReadInput)this.table.get(new Integer(num));
    }

    private ReadInput replace(int num, ReadInput input) {
        return this.table.put(new Integer(num), input);
    }

    public void set(int num, ReadInput input) {
        ReadInput old = this.replace(num, input);
        if (old != input && old != null) {
            old.close();
        }
    }

    public boolean eof(int num) {
        return this.get(num) == null;
    }

    protected void assign(Token src, boolean glob) {
        BoolPar canExpand = new BoolPar();
        int num = CommandBase.scanInt();
        if (!CommandBase.scanKeyword("to")) {
            CommandBase.error("MissingToForRead");
        }
        Token def = PrefixPrim.definableToken();
        MacroBody.Buffer buf = new MacroBody.Buffer();
        InpTokChecker savedChk = CommandBase.setTokenChecker(new ReadToksChecker(buf, def));
        ReadInput input = this.get(num);
        int balance = 0;
        int ln = 0;
        if (input == null) {
            input = CommandBase.getIOHandler().defaultRead(num);
        }
        do {
            Token tok;
            CommandBase.getTokStack().push(new SentinelToken(this.FROZEN_END_READ));
            Tokenizer tokenizer = input.nextTokenizer(def, ln++);
            if (tokenizer != null) {
                CommandBase.getTokStack().push(tokenizer);
            } else {
                this.set(num, null);
                tokenizer = input.emptyLineTokenizer();
                CommandBase.getTokStack().push(tokenizer);
                if (balance > 0) {
                    CommandBase.runAway("definition", buf);
                    CommandBase.error("EOFinRead", CommandBase.esc("read"));
                    balance = 0;
                }
            }
            while ((tok = CommandBase.nextRawToken()) != this.FROZEN_END_READ) {
                if (balance < 0) continue;
                if (tok.matchLeftBrace()) {
                    ++balance;
                } else if (tok.matchRightBrace() && --balance < 0) continue;
                buf.append(tok);
            }
            CommandBase.getTokStack().dropPop();
        } while (balance > 0);
        CommandBase.setTokenChecker(savedChk);
        def.define(new Macro(buf.toMacroBody(), 0), glob);
    }

    public ReadPrim(String name) {
        super(name);
        this.initTable();
    }
}

