/*
 * LaTeD Version 1.1
 * (c) Gene Ressler 1993, 94, 97
 *   de8827@trotter.usma.edu
 *
 * LaTeD is a graphical editor for drawings in the LaTeX "picture" 
 * environment.  It runs under MSDOS or in a Windows DOS box.  The
 * distribution includes full sources, including LaTeX source for 
 * its documentation.
 *
 * No warranty of this software is expressed or implied by the author.
 *
 * Copy and use this program freely for any purpose except for sale
 * of the program (including the source code) itself.  That is, 
 * no one can copy this program for the purpose of providing it to 
 * another person in exchange for money or other compensation, even 
 * if this program is only part of the exchange.
 *
 * All copies of computer source code in this distribution, whether
 * copies in whole or in part, must have this notice attached.
 */

/* DIALOG.C --- Dialog panels. 

   If enabled flag for dialog item is not set, 
   item is ignored completely. I.e. we use this
   to keep Yes, No, Ok, Cancel buttons in the
   message dialog and use only those required
   in the current invokation. */
#include <stdlib.h>
#include <graphics.h>
#include "window.h"
#include "key.h"

/* Standard bitmaps. */
#include "bitmap\ok.c"
#include "bitmap\cancel.c"
#include "bitmap\yes.c"
#include "bitmap\no.c"
/* Following must be square and of equal size. */
#include "bitmap\larrow.c"
#include "bitmap\rarrow.c"
#include "bitmap\uarrow.c"
#include "bitmap\darrow.c"
#include "bitmap\slider.c"
#include "bitmap\color.c"

enum {

dialog_border_width = 2,
dialog_border_color = cBLACK,
dialog_bg_color = cWHITE,
dialog_bottom_margin = 8,

};

int bool_val[] = { 0, 1 };

typedef void (*ITEM_CONSTRUCTOR)(void *item, int x, int y, WINDOW parent);
static ITEM_CONSTRUCTOR constructor_tbl[] = {
  (ITEM_CONSTRUCTOR)open_button,
  (ITEM_CONSTRUCTOR)open_checks,
  (ITEM_CONSTRUCTOR)open_edit_box,
  (ITEM_CONSTRUCTOR)open_radio,
  (ITEM_CONSTRUCTOR)open_scrollbar,
  (ITEM_CONSTRUCTOR)open_selector,
  (ITEM_CONSTRUCTOR)open_table,
  (ITEM_CONSTRUCTOR)open_text,
};

#if diN != sizeof constructor_tbl/sizeof(ITEM_CONSTRUCTOR)
#error Constructor table inconsistent.
#endif

/* This assumes the dialog window itself 
   (and not a subwindow) unsets the focus 
   when the user types tab. */
LOCAL(void) advance_focus(DIALOG d, WINDOW from)
{
  int f, n, i;
  DIALOG_ITEM di;
  WINDOW item;

  n = d->n_items;

  /* See if window that gave up focus is in 
     this dialog, else advance from -1. */
  for (f = n - 1; f >= 0; --f)
    if (from == d->items[f].item)
      break;
  
  /* Set focus to next item that's enabled. */  
  for (i = 0; i < n; ++i) {

    /* Advance f depending on type of dialog. */
    ++f;
    if (d_status_p(d, dMODAL)) {
      if (f == n) f = 0;
    }
    else {
      if (f == n) {
	unset_focus(&d->window);
	return;
      }
    }

    /* See if we can advance here. */
    di = &d->items[f];
    item = di->item;
    if (di_status_p(di, diENABLED) && event_enabled_p(item, eGAIN_FOCUS)) {
      set_focus(item);
      return;
    }
  }
}

LOCAL(void) handle_map(EVENT e)
{
  DIALOG d = (DIALOG)e->map.window;

  if (d_status_p(d, dMODAL)) {
    push_root_window(&d->window, 1);
    push_hotkey_root(&d->window);
    advance_focus(d, NULL);
  }
}

LOCAL(void) handle_unmap(EVENT e)
{
  if (d_status_p((DIALOG)e->map.window, dMODAL)) {
    pop_hotkey_root();
    pop_root_window();
  }
}

BeginDefDispatch(dialog)
  Dispatch(eMAP, handle_map)
  Dispatch(eUNMAP, handle_unmap)
  DispatchAction(eGAIN_FOCUS, advance_focus((DIALOG)e->focus.window, e->focus.other_window))
EndDefDispatch(dialog)

int run_modal_dialog(DIALOG d)
{
  int reply;

  /* Force lose-focus events of ancestor. */
  set_focus(NULL);
  d->status |= bit(dMODAL);
  map_window(&d->window);
  reply = run();
  return reply;
}

void stop_modal_dialog(DIALOG d, int rtn)
{
  unmap_window(&d->window);
  d->status &= notbit(dMODAL);
  stop(rtn);
}

void open_dialog(DIALOG d, int x, int y, WINDOW parent)
{
  int wx, /* wy, */ x0, /* y0, */ width, height, y_ofs;
  DIALOG_ITEM di, end;
  WINDOW w;

  /* Make window too big and shrink it later. */
  open_window(&d->window, parent, 0, 0, parent->width, parent->height,
	      dialog_border_width, dialog_border_color, dialog_bg_color, 
	      bit(eMAP)|bit(eUNMAP)|bit(eGAIN_FOCUS));
  SetDispatch(&d->window, dialog);
  set_window_save_under(&d->window);

  y_ofs = d->title == NULL ? 0 : header_bar_height();
  x0 = parent->width;
  /* y0 = parent->height; */
  width = height = 0;
  for (di = d->items, end = di + d->n_items; di < end; ++di) {
    if (di_status_p(di, diENABLED)) {
      w = di->item;
      (*constructor_tbl[di->type])(w, di->x, di->y + y_ofs, &d->window);
      map_window(w);
      x0 = min(x0, wx = window_x(w));
      /* y0 = min(y0, wy = window_y(w)); */
      width = max(width, wx + w->width);
      height = max(height, /* wy */ window_y(w) + w->height);
    }
  }
  d->window.width = width + x0;
  d->window.height = height + dialog_bottom_margin; /* y0 - y_ofs; */
  locate_window(&d->window, x, y, 1);
  if (d->title != NULL) {
    HEADER h = make_header_bar(&d->title, &d->window);
    map_window(&h->window);
  }
}

/* Surrender keyboard action closure for tables and editboxes. 
   Assumes table/editbox window passed as environment. */

#pragma argsused

void surrender_focus_action(char *unused, ENV env) 
{ 
  unset_focus((WINDOW)env);
}
