#ifndef _RSXW32_H
#define _RSXW32_H

#ifdef __EMX__
#include <alloca.h>
#else /* DJGPP */
#ifndef alloca
extern void *(alloca) (unsigned);
#define alloca(x)  __builtin_alloca(x)
#endif
#endif

typedef unsigned short	USHORT;
typedef unsigned long	ULONG;
typedef unsigned short * stackw;
typedef long (*LONGCALLBACK)();

int	_sys_init_selectors(void);
int	_sys_free_selectors(void);
void	rsxw32_uninit(void);

/* for thunking */
ULONG	_wincall(ULONG fnct, ULONG module, ULONG param, char count);
ULONG	_rsx_32to16(void *pointer32);
void *	_rsx_16to32(unsigned long fp);

extern ULONG _rsxw32_callback;
extern ULONG _rsxw32_ds;
extern ULONG _sys_heap_begin;
extern ULONG _sys_heap_end;
extern ULONG _sys_base_addr;
extern ULONG _sys_last_addr;
extern ULONG _sys_first_sel;

#define INT_RESOURCE 0xFFFF

#define M_WINMAIN_INIT			0
#define M_LOAD_WNDFNCT			1
#define M_LOAD_ABORTPROC		2
#define M_LOAD_DDECALLBACK		3
#define M_LOAD_DRIVERPROC		4
#define M_LOAD_ENUMCHILDPROC		5
#define M_LOAD_ENUMFONTFAMPROC		6
#define M_LOAD_ENUMFONTSPROC		7
#define M_LOAD_ENUMMETAFILEPROC 	8
#define M_LOAD_ENUMOBJECTSPROC		9
#define M_LOAD_ENUMPROPFIXEDPROC       10
#define M_LOAD_ENUMPROPMOVABLEPROC     11
#define M_LOAD_ENUMTASKWNDPROC	       12
#define M_LOAD_ENUMWINDOWSPROC	       13
#define M_LOAD_GRAYSTRINGPROC	       14
#define M_LOAD_LINEDDAPROC	       15
#define M_LOAD_LOADPROC 	       16
#define M_LOAD_TIMERPROC	       17

#define MAGIC_INIT  0
#define USER	    1
#define GDI	    2
#define KERNEL	    3
#define KEYBOARD    4
#define SOUND	    5
#define COMM	    6
#define TOOLHELP    7
#define COMMDLG     8
#define SHELL	    9
#define VER	    10
#define DDEML	    11
#define LZEXPAND    12
#define OLESVR	    13
#define OLECLI	    14
#define MMSYSTEM    25
#define CTL3D	    16
#define CTL3DV2     17
#define STRESS	    18
#define OLE2	    19
#define ODBC	    20
#define WINSOCK     21
#define PENWIN	    22
#define LAST_LIB    29	/* you can patch rsxw for free libs */

/* --- stack parameter --- */
#define NOSTACK unsigned _st=0; char _count=0
#define STACKWORDS(words) \
    stackw _st = (stackw) alloca( (words) * sizeof(USHORT)); \
    void *_ps = _st; \
    char _count = words

/* --- push parameter --- */
#define PUSH_WORD(ARG)	    *((USHORT *)_ps)++ = (USHORT)(ARG)
#define PUSH_LONG(ARG)	    *((ULONG *)_ps)++ = ((ARG)>>16)|((ARG)<<16)
#define PUSH_LPNULL	    *((ULONG *)_ps)++ = 0
#define PUSH_LPSTR(ARG)     PUSH_LONG(_rsx_32to16((void *)(ARG)));

/* --- call parameter --- */
#define WINCALL(fnc,mod)    _wincall(fnc, mod, (unsigned)_st, _count)
#define SV_CALL(fnc,par)    _wincall(fnc, MAGIC_INIT, par, 0)

/* seg,off */
#define SET_SEG_OFF(name, seg, off)			    \
	{ unsigned long ptr = _rsx_32to16((void *)name);    \
	  seg = ptr >> 16;				    \
	  off = ptr & 0xFFFF; }

#endif /* _SYSCALL_H */
