#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "enumw.h"

#define IDC_LIST 500

static OLDFONTENUMPROC lpfnEnumFonts;
static WNDENUMPROC lpfnEnumWindows;
static FONTENUMPROC lpfnEnumFontFam;

static char szAppname[]="enumw";
static HWND hWindow;
static HWND hListWnd;
static HINSTANCE hInstance;


LOGFONT logFont = {
    12,
    0,
    0,
    0,
    400,
    FALSE,
    FALSE,
    FALSE,
    OEM_CHARSET,
    OUT_DEFAULT_PRECIS,
    CLIP_DEFAULT_PRECIS,
    DEFAULT_QUALITY,
    FIXED_PITCH | FF_MODERN,
    ""
};

/* As we dont use UNICODE, we have to define this here */ 
int WINAPI lstrlenW(LPCWSTR lpString);

BOOL CALLBACK EnumLangsFunc(HANDLE hModule, LPCTSTR lpType, 
	LPCTSTR lpName, WORD wLang, LONG lParam)
{
	HANDLE hResInfo;
	char *szBuffer;
	char szText[256];
	int cbString = 0;
	BOOL bDialog = FALSE;

	szBuffer = szText;

	if ((ULONG)lpType & 0xFFFF0000) {
        		cbString = sprintf(szBuffer, "Type: %s", lpType);
	}
	else {
		USHORT uType = (USHORT)(ULONG)lpType;
		switch (uType){
		case RT_ACCELERATOR:
	        		strcpy(szBuffer, "Type: Accelartor");
			break;
		case RT_BITMAP:
	        		strcpy(szBuffer, "Type: Bitmap");
			break;
		case RT_DIALOG:
			bDialog = TRUE;
	        		strcpy(szBuffer, "Type: Dialog");
			break;
		case RT_FONT:
	        		strcpy(szBuffer, "Type: Font");
			break;
		case RT_FONTDIR:
	        		strcpy(szBuffer, "Type: Fontdir");
			break;
		case RT_MENU:
	        		strcpy(szBuffer, "Type: Menu");
			break;
		case RT_RCDATA:
	        		strcpy(szBuffer, "Type: RCDATA");
			break;
		case RT_STRING: 
	        		strcpy(szBuffer, "Type: Strings");
			break;
		case RT_MESSAGETABLE: 
	        		strcpy(szBuffer, "Type: Messages");
			break;
		case RT_CURSOR: 
	        		strcpy(szBuffer, "Type: Cursor");
			break;
		case RT_GROUP_CURSOR: 
	        		strcpy(szBuffer, "Type: G Cursor");
			break;
		case RT_ICON:
	        		strcpy(szBuffer, "Type: Icon");
			break;
		case RT_GROUP_ICON:
	        		strcpy(szBuffer, "Type: G Icon");
			break;
		case RT_VERSION:{
	        		strcpy(szBuffer, "Type: Version");
			break;
		}
		default:
			cbString = sprintf(szBuffer, "Type: %u", uType);
		}
	}
	szBuffer = szText +strlen(szText);

	hResInfo = FindResourceEx(hModule, lpType, lpName, wLang);

	if (bDialog) {
		HGLOBAL hGlobal;
		LPVOID lpRes;
		LPDLGTEMPLATE lpdt;
		LPDLGITEMTEMPLATE lpdit;
		LPWORD lpw;
		LPWSTR lpwsz;
		char szConvert[256];
		int items;
		int i;

		hGlobal = LoadResource(hModule, hResInfo);
		lpRes = LockResource(hGlobal);
		if (lpRes != (LPVOID)(((ULONG)lpRes +3) & ~3))
			MessageBox(hWindow, "Resource at wrong alignment", NULL, MB_OK);

		lpdt = (LPDLGTEMPLATE)lpRes;
		items = lpdt->cdit;
		lpw = (LPWORD) (lpdt + 1);

		/* Is there a menu of any kind? */
		if (*lpw == 0)
			/* no menu */
			lpw++;
		else if (*lpw == 0xFFFF)
			lpw += 2;
		else {
			lpwsz = (LPWSTR) lpw;
			/*WideCharToMultiByte(CP_OEMCP, 0, lpwsz, -1, 
			szConvert, 256, NULL, FALSE);*/
			lpw = (LPWORD) (lpwsz + lstrlenW(lpwsz) + 1);
		}
			
		/* Is there a window definition of any kind? */
		if (*lpw == 0)
			/* standard dialog */
			lpw++;
		else if (*lpw == 0xFFFF)
			lpw += 2;
		else {
			lpwsz = (LPWSTR) lpw;
			/*WideCharToMultiByte(CP_OEMCP, 0, lpwsz, -1, 
			szConvert, 256, NULL, FALSE);*/
			lpw = (LPWORD) (lpwsz + lstrlenW(lpwsz) + 1);
		}
			
		/* dialog title */
		lpwsz = (LPWSTR) lpw;
		WideCharToMultiByte(CP_OEMCP, 0, lpwsz, -1, 
			szConvert, 256, NULL, FALSE);
		lpw = (LPWORD) (lpwsz + lstrlenW(lpwsz) + 1);

		/* Is there a font definition? */
		if ((lpdt->style & DS_SETFONT) == DS_SETFONT){
			lpw++;
			lpwsz = (LPWSTR) lpw;
			/*WideCharToMultiByte(CP_OEMCP, 0, lpwsz, -1, 
				szConvert, 256, NULL, FALSE);*/
			lpw = (LPWORD) (lpwsz + lstrlenW(lpwsz) + 1);
		}

		cbString = sprintf(szBuffer, "\t Title = %s\tItems =%u (%u,%u,%u,%u)",
			szConvert, items,  lpdt->x,  lpdt->y,  lpdt->cx,  lpdt->cy); 
		SendMessage(hListWnd, LB_ADDSTRING, 0, (LPARAM)szText);

		/* Loop over every dialog item in the dialog */
		for (i = 0; i < items; i++){
			/* reset buffer */
			szBuffer = szText;

			/* round up to the next 32-bit boundary */
			lpw = (LPWORD)(((ULONG)lpw +3) & ~3);

			lpdit = (LPDLGITEMTEMPLATE) lpw;
			lpw = (LPWORD) (lpdit + 1);

			/* control class name */
			 if (*lpw == 0xFFFF)
				lpw += 2;
				/* Flag out 0x8000 to get the byte value */
			else {
				lpwsz = (LPWSTR) lpw;
				/*WideCharToMultiByte(CP_OEMCP, 0, lpwsz, -1, 
				szConvert, 256, NULL, FALSE);*/
				lpw = (LPWORD) (lpwsz + lstrlenW(lpwsz) + 1);
			}

			/* round up to the next 16-bit boundary */
			lpw = (LPWORD)(((ULONG)lpw +1) & ~1);

			/* control title */
			 if (*lpw == 0xFFFF){
				szConvert[0] = 0;
				lpw += 2;
			}
			else {
				lpwsz = (LPWSTR) lpw;
				WideCharToMultiByte(CP_OEMCP, 0, lpwsz, -1, 
				szConvert, 256, NULL, FALSE);
				lpw = (LPWORD) (lpwsz + lstrlenW(lpwsz) + 1);
			}

			/* Skip creation data if there is any */
			lpw++; 

			cbString = sprintf(szBuffer, "\t ID = %u  %s (%u,%u,%u,%u)",
				lpdit->id, szConvert, lpdit->x,  lpdit->y,  lpdit->cx,  lpdit->cy);
			SendMessage(hListWnd, LB_ADDSTRING, 0, (LPARAM)szText);
		}
	}
	else {
		if ((ULONG)lpName & 0xFFFF0000) {
			cbString = sprintf(szBuffer, "\tName: %s", lpName);
		}
		else {
			cbString = sprintf(szBuffer, "\tName: %u",  (USHORT)(ULONG)lpName);
	    	}
		szBuffer = szText + strlen(szText);

		cbString = sprintf(szBuffer, "\tLanguage: %u", (USHORT)wLang);
		szBuffer = szText + strlen(szText);
		
		cbString = sprintf(szBuffer, "\t Size = %lu hResInfo = %lx",
               		SizeofResource(hModule, hResInfo), (ULONG)hResInfo);
		SendMessage(hListWnd, LB_ADDSTRING, 0, (LPARAM)szText);
	}


	return TRUE;
}

BOOL CALLBACK EnumNamesFunc(HANDLE hModule, LPCTSTR lpType, 
	LPTSTR lpName, LONG lParam)
{
	return EnumResourceLanguages(hModule, lpType, lpName, 
		(ENUMRESLANGPROC)EnumLangsFunc, lParam);
}

BOOL CALLBACK EnumTypesFunc(HANDLE hModule, LPTSTR lpType, LONG lParam)
{
	return EnumResourceNames(hModule, lpType, 
		(ENUMRESNAMEPROC)EnumNamesFunc, lParam);
}

static void do_enumres(HWND hwnd)
{
	HMODULE hExe;
	SendMessage(hListWnd,LB_RESETCONTENT,0,0);
	SendMessage(hListWnd,WM_SETREDRAW,0,0);

	/* hExe = (HMODULE) NULL; */ 
	hExe = LoadLibrary("winedit.exe");
	if (!EnumResourceTypes(hExe, (ENUMRESTYPEPROC)EnumTypesFunc, 0))
		MessageBox(hwnd, "EnumRes failed", NULL, MB_OK);

	InvalidateRect(hListWnd,NULL,TRUE);
	SendMessage(hListWnd,WM_SETREDRAW,1,0);
	UpdateWindow(hListWnd);
}


int CALLBACK EnumFontsProc (
    const LOGFONT * lpFont,
    const TEXTMETRIC * lpTM,
    int style,
    LPARAM str)
{
    if (lpTM->tmPitchAndFamily & TMPF_FIXED_PITCH)
        SendMessage(hListWnd, LB_ADDSTRING, 0, (LPARAM) lpFont->lfFaceName);
    return 1;

}

int CALLBACK EnumFontFamProc (
    const ENUMLOGFONT *lpFont,
    const NEWTEXTMETRIC *lpTM,
    int type,
    LPARAM str)
{
    if (type & TRUETYPE_FONTTYPE)
        SendMessage(hListWnd, LB_ADDSTRING, 0, (LPARAM)lpFont->elfFullName);

    return 1;
}

void display_window(HWND hWnd, int level)
{
    static char text[256];
    static char class[256];
    RECT r;
    char *buf;
    int i;

    buf = text;

    for (i=0; i<(int)level; i++) {
	*buf++ = ' ';
	*buf++ = ' ';
	*buf++ = ' ';
	*buf++ = ' ';
    }
    sprintf(buf, "%08lX    ", (LONG) hWnd);
    buf = text + strlen(text);

    if (GetClassName(hWnd, class, 256)) {
	sprintf(buf, "[%s]    ", class);
	buf = text + strlen(text);
    }
    GetWindowRect(hWnd, &r);
    sprintf(buf, "(%ld,%ld,%ld,%ld)    ", r.left, r.top, r.right, r.bottom);
    buf = text + strlen(text);
    if (GetWindowText(hWnd, class, 256)) {
	sprintf(buf, "<%s>", class);
	buf = text + strlen(text);
    }
    if (level == 0)
    {
        HINSTANCE hInst = (HINSTANCE) GetWindowLong(hWnd, GWL_HINSTANCE);
	if (GetModuleFileName(hInst, class, 256))
	    sprintf(buf,"    %s", class);
    }

    /* we must convert 32bit flat pointer to 16bit far pointer */
    SendMessage(hListWnd, LB_ADDSTRING, 0, (LPARAM)text);
}

static HWND seen[1024] = {0};

BOOL CALLBACK EnumWindowsProc(HWND hWnd, LPARAM level)
{
    HWND *ps;
    int i;
    static int num_wnd = 0;

    /* cheap check for duplicates */
    for (i=0, ps=seen; i<num_wnd; i++, ps++)
	if (hWnd == *ps)
	    return 1;
    if (num_wnd < 1024)
	seen[num_wnd++] = hWnd;

    display_window(hWnd, level);
    EnumChildWindows(hWnd, lpfnEnumWindows, level+1);
    return 1;	/* keep going */

}

void doPaint(HWND hwnd)
{
    HFONT hFont, hOldFont;
    HDC hdc;

    hdc = GetDC(hwnd);
    TextOut(hdc, 0, 0, "          ", 10);
    hFont = CreateFontIndirect(&logFont);
    hOldFont= SelectObject(hdc, hFont);
    TextOut(hdc, 0, 0, "Hallo", 5);
    SelectObject(hdc, hOldFont);
    DeleteObject(hFont);
    ReleaseDC(hwnd, hdc);
}

static void do_enumfonts(HWND hwnd)
{
    HDC hdc;

    SendMessage(hListWnd,LB_RESETCONTENT,0,0);
    SendMessage(hListWnd,WM_SETREDRAW,0,0);

    hdc = GetDC(hwnd);
    if (! EnumFonts(hdc, NULL, lpfnEnumFonts, 0))
        MessageBox(hwnd, "EnumFonts failed", NULL, MB_OK);
    ReleaseDC(hwnd, hdc);

    InvalidateRect(hListWnd,NULL,TRUE);
    SendMessage(hListWnd,WM_SETREDRAW,1,0);
    UpdateWindow(hListWnd);
}

static void do_enumfontfam(HWND hwnd)
{
    HDC hdc;

    SendMessage(hListWnd,LB_RESETCONTENT,0,0);
    SendMessage(hListWnd,WM_SETREDRAW,0,0);

    hdc = GetDC(hwnd);
    if (! EnumFontFamilies(hdc, NULL, lpfnEnumFontFam, 0))
        MessageBox(hwnd, "EnumFontFam failed", NULL, MB_OK);
    ReleaseDC(hwnd, hdc);

    InvalidateRect(hListWnd,NULL,TRUE);
    SendMessage(hListWnd,WM_SETREDRAW,1,0);
    UpdateWindow(hListWnd);
}

static void do_enumwindows(HWND hwnd)
{
    SendMessage(hListWnd,LB_RESETCONTENT,0,0);
    SendMessage(hListWnd,WM_SETREDRAW,0,0);

    memset(seen, 0, sizeof(seen));
    if (! EnumWindows(lpfnEnumWindows, 0))
        MessageBox(hwnd, "EnumWindows failed", NULL, MB_OK);

    InvalidateRect(hListWnd,NULL,TRUE);
    SendMessage(hListWnd,WM_SETREDRAW,1,0);
    UpdateWindow(hListWnd);
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
	case WM_SIZE:
            MoveWindow(hListWnd,10,10,LOWORD(lParam)-20,HIWORD(lParam)-20,TRUE);
            return 0;

	case WM_CREATE:
	    lpfnEnumFonts = (OLDFONTENUMPROC)
		    MakeProcInstance((FARPROC) EnumFontsProc, hInstance);
	    lpfnEnumFontFam = (FONTENUMPROC)
		    MakeProcInstance((FARPROC) EnumFontFamProc, hInstance);
	    lpfnEnumWindows = (WNDENUMPROC)
		    MakeProcInstance((FARPROC) EnumWindowsProc, hInstance);
            return 0;

	case WM_DESTROY:
            SendMessage(hListWnd,LB_RESETCONTENT,0,0);
	    FreeProcInstance((FARPROC)lpfnEnumFonts);
	    FreeProcInstance((FARPROC)lpfnEnumFontFam);
	    FreeProcInstance((FARPROC)lpfnEnumWindows);
	    PostQuitMessage(0);
            return 0;

	case WM_COMMAND:
	    switch (wParam) {
		case IDM_FONTS:
                    do_enumfonts(hwnd);
                    return 0;
		case IDM_FONTFAM:
                    do_enumfontfam(hwnd);
                    return 0;
		case IDM_WINDOWS:
                    do_enumwindows(hwnd);
                    return 0;
		case IDM_RESOURCES:
                    do_enumres(hwnd);
                    return 0;
		case IDM_ABOUT:
                    MessageBox(hwnd,
                        "EnumW 1.1 test application\n"
                        "\n"
                        " Rainer Schnitker\n"
                        " Fred Kiefer",
                        szAppname, MB_OK | MB_ICONINFORMATION);
                    return 0;
		case IDC_LIST:
                    if (HIWORD(lParam) != LBN_DBLCLK)
			break;
		    else {
			WPARAM index = SendMessage(
			    hListWnd,
			    LB_GETCURSEL,
                            0,0);
			SendMessage(
			    hListWnd,
			    LB_GETTEXT,
			    index,
                            (LPARAM) &logFont.lfFaceName);
			doPaint(hwnd);
                        return 0;
                    }
                break;
            } /* switch wparam */

    } /* switch message */

    return DefWindowProc(hwnd, message, wParam, lParam);

}

BOOL InitApplication(HINSTANCE hInstance)
{
    WNDCLASS wc;

    wc.style = 0;
    wc.lpfnWndProc = WndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(hInstance, szAppname);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  szAppname;
    wc.lpszClassName = szAppname;

    return RegisterClass(&wc);
}

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
    RECT Rect;
    HANDLE hFont;

    hWindow = CreateWindow(
	szAppname,
	"ENUM TEST",
	WS_OVERLAPPEDWINDOW,
	CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
	NULL, NULL,
	hInstance,
	NULL);

    if (!hWindow)
        return (0);

    GetClientRect(hWindow, &Rect);

    hListWnd =
        CreateWindow (
	"Listbox",
	NULL ,
	(LBS_STANDARD & ~LBS_SORT) | LBS_HASSTRINGS | 
	LBS_NOREDRAW | LBS_USETABSTOPS |
	WS_VISIBLE | WS_BORDER | WS_VSCROLL | WS_CHILD,
        10, 10, Rect.right-Rect.left-20, Rect.bottom-Rect.top-20,
	hWindow,
        (HMENU) IDC_LIST,
	hInstance,
        0);

    if (!hListWnd) {
	DestroyWindow(hWindow);
        return (0);
    }

    ShowWindow(hWindow, nCmdShow);
    UpdateWindow(hWindow);

    hFont=GetStockObject(SYSTEM_FIXED_FONT);
    SendMessage(hListWnd, WM_SETFONT, (WPARAM) hFont, TRUE);

    return TRUE;
}

int WINAPI WinMain (
    HINSTANCE hInst,
    HINSTANCE hPrevInst,
    LPSTR lpszCmdParam,
    int nCmdShow)
{
    MSG msg;

    hInstance = hInst;
    if (!InitApplication(hInstance)) {
	MessageBox(NULL,"register class",NULL,MB_OK);
	return (FALSE);
    }
    if (!InitInstance(hInstance, nCmdShow)) {
	MessageBox(NULL,"create window",NULL,MB_OK);
	return (FALSE);
    }

    while (GetMessage(&msg, NULL, 0, 0)) {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
    }
    return msg.wParam;
}
