/* sigprocm.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

int __sigprocmask(int how, const sigset_t *set, sigset_t *oset)
{
    EMXPROCESS *proc = _rsxnt_get_process_ptr();
    sigset_t new_set, old_set = proc->sig_blocked;

    if (set) {
	new_set = *set;

	switch (how) {
	    case SIG_BLOCK:
		proc->sig_blocked |= new_set;
		break;
	    case SIG_UNBLOCK:
		proc->sig_blocked &= ~new_set;
		break;
	    case SIG_SETMASK:
		proc->sig_blocked = new_set;
		break;
	    default:
		return _rsxnt_errno(EINVAL);
	}
    }
    if (oset) {
	*oset = old_set;
    }
#ifdef EMX_SYS_LIB
	_rsxnt_check_signals();
#endif
    return 0;
}
