/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl
 * 
 *	FILE: "cpptcl_info.cc"
 *									  created: 26/6/96 {12:15:16 pm} 
 *								  last update: 27/10/97 {6:51:03 pm} 
 *	Author:	Vince Darley
 *	E-mail:	<darley@fas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www:	<http://www.fas.harvard.edu/~darley/>
 *	
 *	See	header file	for	further	information
 * ###################################################################
 */


#include "cpptcl_info.h"

void cpptcl_info::free_completion_mem(void) {
	if(max_completion) 
		delete [] max_completion;
	if(orig_command)
		delete [] orig_command;
	max_completion = 0;
	orig_command = 0;
}
	
int cpptcl_info::parse_tcl_command(tcl_args& arg) {
	if(arg("","return maximum length common prefix for last completion")
	   =="maxCompletion") {
	     arg >> done;
	     NO_EXCEPTIONS(arg);
	     tcl_ << max_completion << result;
	     return tcl_;
	} else if(arg("object","is this a Cpptcl object")
			  =="isCpptcl") {
	     arg >> arg.tmp_chars >> done;
	     NO_EXCEPTIONS(arg);
		 tcl_base* o = tcl_.FindObject(arg.tmp_chars);
		 tcl_ << (o ? 1 : 0) << result;
		 return tcl_;
	} else if(arg("","return length of command which was completed","orig")
			  =="origCommand") {
	     arg >> done;
	     NO_EXCEPTIONS(arg);
		 tcl_ << orig_command << result;
		 return tcl_;
	} else if(arg("","name and e-mail address for bug reports")=="author") {
	     arg >> done;
	     NO_EXCEPTIONS(arg);
		 tcl_ << "Vince Darley <mailto:darley@fas.harvard.edu>" << result;
		 return tcl_;
	} else if(arg("","web page for online documentation","web")=="webPage") {
		arg >> done;
		NO_EXCEPTIONS(arg);
		tcl_ << "http://www.fas.harvard.edu/~darley/EvoXandCpptcl.html" 
			 << result;
		return tcl_;
	} else if(arg("object cmd",
				  "find help for a command on a Cpptcl object")=="help"){
		tcl_base* o = 0;
		arg >> o;
		if(!o) {
			// little hack.  If there's no meta_object then we must
			// dump out immediately, else we continue.
			arg >> done;
		}
		NO_EXCEPTIONS(arg);
		tcl_args copy(arg, o);		
		copy.start_help_check();
		o->tcl_command_entry_point(copy);
		copy.end_help_check();
		// set status to TCL_OK;
		tcl_.reset();
		return tcl_;
	} else if(arg("?-withargs? object ?cmd ... cmd?",
				  "complete a command on a Cpptcl object")=="complete"){
		// Check for the optional flag
		bool with_arguments = false;
		if (!strcmp(arg.peek(),"-withargs")){
			arg == "-withargs";
			with_arguments = true;
		}
		tcl_base* o = 0;
		arg >> o;
		if(!o) {
			// little hack.  If there's no object then we must
			// dump out immediately, else we continue.
			arg >> done;
		}
		
		NO_EXCEPTIONS(arg);
		tcl_args copy(arg, o);		
		copy.start_completion_check(with_arguments);
		o->tcl_command_entry_point(copy);
		tcl_ << append;
		if(copy.completion_type != tcl_args::No_completion && 
			copy.completion_type != tcl_args::Already_complete) {
			// sort the list
			tcl_obj o(tcl_.interpreter());
			o << list_mode_on 
			  << "split" << tcl_.result() << "\n\r" 
			  << list_mode_off << eval;
			/* 
			 * o << list_mode_on
			 *   << "return" << cmd << "join" 
			 *   << cmd << "lindex" << o.result() << 0 << end_cmd 
			 *   << cmd << "join" << cmd << "lsort"
			 *   << cmd << "lrange" << o.result() << 1 << "end" << end_cmd
			 *   << end_cmd << "\n" << end_cmd << "\n" << end_cmd 
			 *   << list_mode_off << eval;
			 */
			o << "return [lindex {" << o.result()
			  << "} 0]\\n[join [lsort [lrange {"
			  << o.result() << "} 1 end]] \\n]" << eval;
		}
		// set status to TCL_OK;
		tcl_.reset();
		// Now we should extract the correct completion and remember it
		// max_completion = ...
		free_completion_mem();
		tcl_obj os;
		os << copy.parsed_so_far << copy.completion << ends;
		orig_command = new char[copy.completion_orig_len+1];
		strncpy(orig_command, os.str(), copy.completion_orig_len);
		orig_command[copy.completion_orig_len] = '\0';
		
		max_completion = new char[copy.completion_extra_len+1];
		strncpy(max_completion, os.str()+copy.completion_orig_len, 
		        copy.completion_extra_len);
		max_completion[copy.completion_extra_len] = '\0';
		copy.end_completion_check();
		return tcl_;
	} else
	    return tcl_object::parse_tcl_command(arg);
}		
