## -*-Tcl-*- (install)
 # ###################################################################
 #  Vince's Additions - an extension package for Alpha
 # 
 #  FILE: "newDocument.tcl"
 #                                    created: 18/9/97 {4:47:39 pm} 
 #                                last update: 1/3/1999 {11:50:38 pm} 
 #  Author: Vince Darley
 #  E-mail: <darley@fas.harvard.edu>
 #    mail: Division of Engineering and Applied Sciences, Harvard University
 #          Oxford Street, Cambridge MA 02138, USA
 #     www: <http://www.fas.harvard.edu/~darley/>
 #  
 # Copyright (c) 1997-1998  Vince Darley, all rights reserved
 # 
 # See the file "license.terms" for information on usage and redistribution
 # of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 # ###################################################################
 ##

alpha::extension newDocument 0.1.2 {
    namespace eval newDocument {}
    set newDocument::handlers(Alpha) new
    # use this binding to open a new template document
    newPref binding newDocument "/N<O" newDocument "" file::newDocument
    # handler of new documents
    newPref var newDocumentHandler "Alpha" newDocument "" newDocument::handlers array
    # open untitled windows directly without asking for templates etc.
    newPref flag untitledDocsAreEmpty 1 newDocument
    # prompt for the name of new documents
    newPref flag newDocNamePrompt 1 newDocument
    package::addPrefsDialog newDocument
} uninstall {this-file} maintainer {
    "Vince Darley" darley@fas.harvard.edu <http://www.fas.harvard.edu/~darley/>
} help {
    A nicer way to make new documents
}

ensureset {newDocTypes(New Email Message)} mailNewMsg
ensureset {newDocTypes(New Ftp Connection)} ftpPromptBrowse
ensureset {newDocTypes(New File-set)} newFileset
ensureset {newDocTypes(New Web Browser)} wwwParseFile

proc file::newDocument {args} {
    global newDocTypes newDocumentmodeVars newDocument::handlers
    if {$args == "" && $newDocumentmodeVars(newDocNamePrompt)} {
	if {[catch {set args [eval [list prompt "Please enter a name for the new document window" \
	  "Untitled" "Or open:"] \
	  [lsort -ignore [array names newDocTypes]] "\(-" "Untitled"]}]} {
	    return
	}
	if {[info exists newDocTypes($args)]} {
	    $newDocTypes($args)
	    return ""
	}
	if {$args == "Untitled"} {
	    if {$newDocumentmodeVars(untitledDocsAreEmpty)} {
		new
		return
	    }
	    set args ""
	} else {
	    set args [list "-n" $args] 
	}
    }
    set handler [set newDocument::handlers($newDocumentmodeVars(newDocumentHandler))]
    if {[catch {eval $handler $args}]} {
	if {[info commands $handler] == ""} {
	    alertnote "Your new document handler was poorly set.  I'll reset it."
	    # handler poortly set
	    global modifiedArrayElements
	    set newDocumentmodeVars(newDocumentHandler) Alpha
	    lappend modifiedArrayElements [list newDocumentHandler newDocumentmodeVars]
	    eval new $args
	} else {
	    alertnote "Your new document handler '$handler' caused an error."
	}
    }
    return ""
}



