/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.auxparser.AuxFileParser;
import net.sourceforge.texlipse.builder.AbstractBuilder;
import net.sourceforge.texlipse.builder.AdaptableBuilder;
import net.sourceforge.texlipse.builder.BuilderCoreException;
import net.sourceforge.texlipse.builder.BuilderRegistry;
import net.sourceforge.texlipse.builder.ProgramRunner;
import net.sourceforge.texlipse.builder.TexlipseBuilder;
import net.sourceforge.texlipse.model.ReferenceContainer;
import net.sourceforge.texlipse.model.ReferenceEntry;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import net.sourceforge.texlipse.viewer.ViewerManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Shell;

public class TexBuilder
extends AbstractBuilder
implements AdaptableBuilder {
    private boolean biblatexMode = false;
    private String biblatexBackend = null;
    private ProgramRunner latex;
    private ProgramRunner bibtex;
    private ProgramRunner makeIndex;
    private ProgramRunner makeIndexNomencl;
    private String output;
    private boolean stopped;
    private int alternative;

    public TexBuilder(int i, String outputFormat, int alt) {
        super(i);
        this.output = outputFormat;
        this.latex = null;
        this.bibtex = null;
        this.makeIndex = null;
        this.alternative = alt;
        this.isValid();
    }

    public boolean isValid() {
        if (this.latex == null || !this.latex.isValid()) {
            this.latex = BuilderRegistry.getRunner("tex", this.output, this.alternative);
        }
        if (this.bibtex == null || !this.bibtex.isValid()) {
            if (!this.biblatexMode || this.biblatexBackend == null || "bibtex".equals(this.biblatexBackend)) {
                this.bibtex = BuilderRegistry.getRunner("bib", "aux", 0);
            } else if (this.biblatexMode && "biber".equals(this.biblatexBackend)) {
                this.bibtex = BuilderRegistry.getRunner("bcf", "bbl", 0);
            }
        }
        if (this.makeIndex == null || !this.makeIndex.isValid()) {
            this.makeIndex = BuilderRegistry.getRunner("idx", "ind", 0);
        }
        if (this.makeIndexNomencl == null || !this.makeIndexNomencl.isValid()) {
            this.makeIndexNomencl = BuilderRegistry.getRunner("nlo", "nls", 0);
        }
        return this.latex != null && this.latex.isValid() && this.bibtex != null && this.bibtex.isValid() && this.makeIndex != null && this.makeIndex.isValid();
    }

    public String getOutputFormat() {
        return this.latex.getOutputFormat();
    }

    public String getSequence() {
        return this.latex.getProgramName();
    }

    public void stopRunners() {
        this.latex.stop();
        this.bibtex.stop();
        this.makeIndex.stop();
        this.makeIndexNomencl.stop();
        this.stopped = true;
    }

    private boolean askUserForContinue(IProject project) throws CoreException {
        Object c = project.getSessionProperty(new QualifiedName(null, "AlwaysContinueBuilding"));
        if (c == null) {
            Shell shell = TexlipsePlugin.getCurrentWorkbenchPage().getActiveEditor().getSite().getShell();
            final StringBuffer toggle = new StringBuffer();
            final StringBuffer returnCode = new StringBuffer();
            shell.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialogWithToggle mess = MessageDialogWithToggle.openOkCancelConfirm((Shell)TexlipsePlugin.getCurrentWorkbenchPage().getActiveEditor().getSite().getShell(), (String)TexlipsePlugin.getResourceString("builderErrorDuringBuildTitle"), (String)TexlipsePlugin.getResourceString("builderErrorDuringBuild"), (String)TexlipsePlugin.getResourceString("builderErrorDuringBuildToggle"), (boolean)false, null, null);
                    if (mess.getToggleState()) {
                        toggle.append(true);
                    }
                    if (mess.getReturnCode() == 1) {
                        returnCode.append(false);
                    }
                }
            });
            if (toggle.length() > 0) {
                if (returnCode.length() > 0) {
                    project.setSessionProperty(new QualifiedName(null, "AlwaysContinueBuilding"), (Object)new Boolean(false));
                } else {
                    project.setSessionProperty(new QualifiedName(null, "AlwaysContinueBuilding"), (Object)new Boolean(true));
                }
            }
            return returnCode.length() <= 0;
        }
        Boolean b = (Boolean)c;
        return b != false;
    }

    private String getAuxFileName(IProject project) {
        IFile tmpFile;
        String auxFileName = TexlipseProperties.getProjectProperty((IResource)project, "mainTexFile");
        String s = TexlipseProperties.getProjectProperty((IResource)project, "partialBuild");
        if (s != null && (tmpFile = (IFile)TexlipseProperties.getSessionProperty((IResource)project, "partialFile")) != null) {
            auxFileName = tmpFile.getProjectRelativePath().toPortableString();
        }
        auxFileName = auxFileName.replaceFirst("\\.tex$", "\\.aux");
        return auxFileName;
    }

    private void extractLabels(AuxFileParser afp) {
        ReferenceContainer labelC = (ReferenceContainer)TexlipseProperties.getSessionProperty((IResource)afp.getProject(), "labelContainer");
        if (labelC != null) {
            String tempPath = TexlipseProperties.getProjectProperty((IResource)afp.getProject(), "tempDir");
            String correctedAuxFileName = String.valueOf(tempPath) + File.separator + afp.getRootAuxFile();
            labelC.addRefSource(correctedAuxFileName, new LinkedList<ReferenceEntry>());
            labelC.organize();
            labelC.updateRefSource(correctedAuxFileName, afp.getLabels());
        }
    }

    private void clearMarkers(IProject project) {
        try {
            project.deleteMarkers(TexlipseBuilder.MARKER_TYPE, false, 2);
            project.deleteMarkers(TexlipseBuilder.LAYOUT_WARNING_TYPE, false, 2);
        }
        catch (CoreException coreException) {}
    }

    public void buildResource(IResource resource) throws CoreException {
        String[] bibs;
        this.stopped = false;
        if (Platform.getOS().equals("win32")) {
            this.monitor.subTask("Closing output document");
            ViewerManager.closeOutputDocument();
            this.monitor.worked(5);
        }
        IProject project = resource.getProject();
        boolean parseAuxFiles = TexlipsePlugin.getDefault().getPreferenceStore().getBoolean("builderParseAuxFiles");
        String auxFileName = this.getAuxFileName(project);
        IFile auxFile = project.getFile(auxFileName);
        List<String> oldCitations = null;
        if (!this.biblatexMode && parseAuxFiles && auxFile.exists()) {
            AuxFileParser afp = new AuxFileParser(project, auxFileName);
            oldCitations = afp.getCitations();
        }
        this.monitor.subTask("Building document");
        try {
            this.latex.run(resource);
        }
        catch (BuilderCoreException builderCoreException) {}
        this.monitor.worked(10);
        if (this.stopped) {
            return;
        }
        String runBib = (String)TexlipseProperties.getSessionProperty((IResource)project, "rerunBibtex");
        Boolean bibChange = (Boolean)TexlipseProperties.getSessionProperty((IResource)project, "bibFilesChanged");
        IResource runIdx = this.findIndex(project, resource);
        IResource runNomencl = this.findNomencl(project, resource);
        String rerun = (String)TexlipseProperties.getSessionProperty((IResource)resource.getProject(), "rerunLatex");
        if (parseAuxFiles && auxFile.exists()) {
            List<String> newCitations;
            AuxFileParser afp = new AuxFileParser(project, auxFileName);
            if (!this.biblatexMode && !(newCitations = afp.getCitations()).equals(oldCitations)) {
                bibChange = new Boolean(true);
            }
            this.extractLabels(afp);
        }
        if ((bibs = (String[])TexlipseProperties.getSessionProperty((IResource)project, "bibFiles")) != null && bibs.length > 0 && (runBib != null || bibChange != null)) {
            this.bibtex.run(resource);
            if (this.stopped) {
                return;
            }
            this.monitor.worked(10);
            TexlipseProperties.setSessionProperty((IResource)project, "rerunBibtex", null);
            TexlipseProperties.setSessionProperty((IResource)project, "bibFilesChanged", null);
            if (runIdx != null) {
                this.makeIndex.run(resource);
                if (this.stopped) {
                    return;
                }
                this.monitor.worked(10);
            }
            if (runNomencl != null) {
                this.makeIndexNomencl.run(resource);
                if (this.stopped) {
                    return;
                }
                this.monitor.worked(10);
            }
            try {
                this.latex.run(resource);
            }
            catch (BuilderCoreException builderCoreException) {}
            if (this.stopped) {
                return;
            }
            this.monitor.worked(10);
            this.clearMarkers(project);
            try {
                this.latex.run(resource);
            }
            catch (BuilderCoreException builderCoreException) {}
            if (this.stopped) {
                return;
            }
            this.monitor.worked(10);
        } else if (rerun != null || runIdx != null || runNomencl != null) {
            if (runIdx != null) {
                this.makeIndex.run(resource);
                if (this.stopped) {
                    return;
                }
                this.monitor.worked(10);
            }
            if (runNomencl != null) {
                this.makeIndexNomencl.run(resource);
                if (this.stopped) {
                    return;
                }
                this.monitor.worked(10);
            }
            try {
                this.latex.run(resource);
            }
            catch (BuilderCoreException builderCoreException) {}
            if (this.stopped) {
                return;
            }
            this.monitor.worked(10);
            TexlipseProperties.setSessionProperty((IResource)resource.getProject(), "rerunLatex", null);
        }
    }

    public void updateBuilder(IProject project) {
        String blBEVal;
        Boolean newBiblatexMode = (Boolean)TexlipseProperties.getSessionProperty((IResource)project, "biblatexMode");
        String newBiblatexBackend = (String)TexlipseProperties.getSessionProperty((IResource)project, "biblatexBackend");
        boolean blModeVal = newBiblatexMode != null;
        String string = blBEVal = newBiblatexBackend != null ? newBiblatexBackend : "";
        if (blModeVal != this.biblatexMode || this.biblatexMode && !blBEVal.equals(this.biblatexBackend)) {
            this.bibtex = null;
        }
        this.biblatexMode = blModeVal;
        this.biblatexBackend = newBiblatexBackend;
    }

    private IResource findIndex(IProject project, IResource source) {
        String name;
        String idxName;
        IResource idxFile;
        IContainer srcDir = TexlipseProperties.getProjectSourceDir(project);
        if (srcDir == null) {
            srcDir = project;
        }
        if ((idxFile = srcDir.findMember(idxName = String.valueOf((name = source.getName()).substring(0, name.length() - source.getFileExtension().length())) + "idx")) == null) {
            return null;
        }
        IFile outFile = TexlipseProperties.getProjectOutputFile(project);
        if (outFile.getLocalTimeStamp() > idxFile.getLocalTimeStamp()) {
            return null;
        }
        return idxFile;
    }

    private IResource findNomencl(IProject project, IResource source) {
        String name;
        String nomenclName;
        IResource idxFile;
        IContainer srcDir = TexlipseProperties.getProjectSourceDir(project);
        if (srcDir == null) {
            srcDir = project;
        }
        if ((idxFile = srcDir.findMember(nomenclName = String.valueOf((name = source.getName()).substring(0, name.length() - source.getFileExtension().length())) + "nlo")) == null) {
            return null;
        }
        IFile outFile = TexlipseProperties.getProjectOutputFile(project);
        if (outFile.getLocalTimeStamp() > idxFile.getLocalTimeStamp()) {
            return null;
        }
        return idxFile;
    }
}

