/****************************************************************************
  PROJECT: MusixTeX PreProcessor
  FILE   : inote.cc
  AUTHOR : J. C. Nieuwenhuizen

  copyright (c) FlowerSoft 1995
--*/
 
#include "init.h"
#include "inote.h"
#include "mpp.h"

NoteNameArray noteNames( ( 7 + 1 ) * 5 );

#ifndef NO_RUNTIME
#define NOTENAMES_RUNTIME
#endif

#ifdef NOTENAMES_RUNTIME

#include "textdata.h"
//#include "string.h"
//#include "integer.h"
#include <stdlib.h>            // atoi

#define NOTE_INIT "note.ini"

void initNoteNames()
{
//    TextDataFile notes( NOTE_INIT );
    String initName = execPrefix;
    initName += NOTE_INIT;
    TextDataFile notes( initName );
    
    while ( notes )
        {
        TextRecord& note = notes++;
#if 0 // take no risk // ndef COMMA_RIGHT_TO_LEFT
        noteNames.put( *new NoteName( note++, atoi( note++ ), 
            atoi( note++ ), atoi( note++ ) ) );
#else
        const char* name = note++;
        int pitch = atoi( note++ );
        int height = atoi( note++ );
        int offset = atoi( note++ );
        noteNames.put( *new NoteName( name, pitch, height, offset ) );
#endif        
        }
}

#else // not NOTENAMES_RUNTIME // 


void initNoteNames()
{
    #include "notecc.ini"
}

#endif // not NOTENAMES_RUNTIME //
