/****************************************************************************
  PROJECT: MusixTeX PreProcessor
  FILE   : duration.h
  AUTHOR : J. C. Nieuwenhuizen

  copyright (c) FlowerSoft 1995
--*/
#ifndef __DURATION_H
#define __DURATION_H

#ifndef __OBJECT_H
#include "object.h"
#endif

extern const int DURATION_WHOLE;

#if defined( __TURBOC__ ) && ( __TURBOC__ >= 0x300 )
#if !defined ( __NPLET_MAX )
#define __NPLET_MAX
extern const int NPLET_MAX;
#endif
#else // ! turboc 3.0
extern const int NPLET_MAX;
#endif

extern int onePlet;
class istream;
class ostream;
class InitiateBeam;
class Staff;

/****************************************************************************
  class Duration
--*/
/*
   duration of a (note contains a duration) note
   fundamentel unit -> see duration.cc
 */
class Duration : public Object 
{
//friend class Note;             // to read dots

 public:                        // note, meter
    int dots;
    int multiplicity;

 private:
    InitiateBeam& beam;
    int xDuration;
    int _nPlet;
    
    int _getFrom( istream& is );
    virtual int getFrom( Staff& staff );
    int getNumber( istream& is );
    int log2( const int x ) const;

 public:
    const char* alpha() const;
    int duration() const;
    static int getNPletFrom( Staff& staff );
    int noteSkip() const;
    int nPlet() const;
    int ord() const;
    const char* spacing() const;
    virtual void printOn( ostream& os ) const;

    Duration( const Duration& duration );
//    Duration( const int x, const int d = 0, int& n = onePlet );
    Duration( const int x, const int d = 0, int n = 1 );
    Duration( istream& is );
    Duration( Staff& staff );
    virtual ~Duration();
};
//-- class Duration  //

#endif // __DURATION_H  //
