/*
 * Decompiled with CFR 0.152.
 */
package LogFilter;

import LogFilter.View;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JOptionPane;

class UserSettings {
    View view;
    int x = 30;
    int y = 30;
    int height = 466;
    int width = 580;
    int min_pt_overfull;
    boolean fonterror = true;
    boolean fontwarning = true;
    boolean overfull_hbox = true;
    boolean underfull_hbox = true;
    boolean vbox = true;
    boolean float_warning = true;
    boolean nofile_error = true;
    boolean reference_error = true;
    boolean latex_warning = true;
    boolean fixme_note = true;
    boolean fixme_warning = true;
    boolean fixme_error = true;
    String logfilename = "";
    String editorexe = "";
    String editorargs = "";

    UserSettings(View view) throws IOException {
        try {
            this.view = view;
            Properties properties = new Properties();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream("logfilter.conf"));
            properties.load(bufferedInputStream);
            bufferedInputStream.close();
            this.x = Integer.parseInt(properties.getProperty("x"));
            this.y = Integer.parseInt(properties.getProperty("y"));
            this.width = Integer.parseInt(properties.getProperty("width"));
            this.height = Integer.parseInt(properties.getProperty("height"));
            this.logfilename = properties.getProperty("logfilename");
            this.editorexe = properties.getProperty("editorexe");
            this.editorargs = properties.getProperty("editorargs");
            this.min_pt_overfull = Integer.parseInt(properties.getProperty("min_pt_overfull"));
            this.fonterror = Boolean.valueOf(properties.getProperty("fonterror"));
            this.fontwarning = Boolean.valueOf(properties.getProperty("fontwarning"));
            this.overfull_hbox = Boolean.valueOf(properties.getProperty("overfull_hbox"));
            this.underfull_hbox = Boolean.valueOf(properties.getProperty("underfull_hbox"));
            this.vbox = Boolean.valueOf(properties.getProperty("vbox"));
            this.float_warning = Boolean.valueOf(properties.getProperty("float_warning"));
            this.nofile_error = Boolean.valueOf(properties.getProperty("nofile_error"));
            this.reference_error = Boolean.valueOf(properties.getProperty("reference_error"));
            this.latex_warning = Boolean.valueOf(properties.getProperty("latex_warning"));
            this.fixme_note = Boolean.valueOf(properties.getProperty("fixme_note"));
            this.fixme_warning = Boolean.valueOf(properties.getProperty("fixme_warning"));
            this.fixme_error = Boolean.valueOf(properties.getProperty("fixme_error"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "Can not find the config file! Generating a new one", "LogFilter: Information", 1);
            this.save();
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "The config file is corrupt! Generating a new one", "LaTeXLogFilter: Alert!", 0);
            this.save();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(null, "The config file is corrupt! Generating a new one", "LogFilter: Alert!", 0);
            this.save();
        }
        catch (Exception exception) {
            System.out.println("Please report this exception to the author of the program" + exception);
            JOptionPane.showMessageDialog(null, "The config file is corrupt! Generating a new one", "LogFilter: Alert!", 0);
            this.save();
        }
    }

    void save() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("logfilter.conf");
            Properties properties = new Properties();
            if (this.view.isVisible()) {
                this.x = this.view.getX();
                this.y = this.view.getY();
                this.width = this.view.getWidth();
                this.height = this.view.getHeight();
            }
            properties.setProperty("x", "" + this.x);
            properties.setProperty("y", "" + this.y);
            properties.setProperty("width", "" + this.width);
            properties.setProperty("height", "" + this.height);
            properties.setProperty("logfilename", this.logfilename);
            properties.setProperty("editorexe", this.editorexe);
            properties.setProperty("editorargs", this.editorargs);
            properties.setProperty("min_pt_overfull", "" + this.min_pt_overfull);
            properties.setProperty("fonterror", "" + this.fonterror);
            properties.setProperty("fontwarning", "" + this.fontwarning);
            properties.setProperty("overfull_hbox", "" + this.overfull_hbox);
            properties.setProperty("underfull_hbox", "" + this.underfull_hbox);
            properties.setProperty("vbox", "" + this.underfull_hbox);
            properties.setProperty("float_warning", "" + this.float_warning);
            properties.setProperty("nofile_error", "" + this.nofile_error);
            properties.setProperty("reference_error", "" + this.reference_error);
            properties.setProperty("latex_warning", "" + this.latex_warning);
            properties.setProperty("fixme_note", "" + this.fixme_note);
            properties.setProperty("fixme_warning", "" + this.fixme_warning);
            properties.setProperty("fixme_error", "" + this.fixme_error);
            properties.store(fileOutputStream, "LogFilter v0.90 ");
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            JOptionPane.showMessageDialog(null, "The config file can not be saved!", "LogFilter: Alert!", 0);
        }
    }

    public String toString() {
        return "editorexe " + this.editorexe + "\n";
    }
}

