/* this a common windows interface file (wint.c) that is supposed to sit
   between explicit windows interfaces files that are specific to the
   particular windowing system/user interface, e.g., MOTIF, and the
   body of gplot. Since this may be usd on some very strange OS's
   we'll avoid malloc if possible
*/
#include <stdio.h>
extern void info_error(); /* in the window specific interface */
extern int cgm_goto(); /* in io.c */
/* CGM specifics */
#include "defs.h"
#define version_str "4.3"
static struct info_struct new_info;
static struct one_opt new_opt[opt_size];
static int (*do_command)(), (*get_command)();	/* useful pointers */
static unsigned char *start_mem = NULL;	/* for holding commands, data */
static int mem_size = 512 * 1000;	/* intial mem we will use */
/* now the big locals, the structures which keep track of the CGM state */
static struct 	mf_d_struct 	glbl1;	/* the class 1 elements */
static struct 	pic_d_struct 	glbl2, dflt2;	/* the class 2 elements */
static struct 	control_struct	glbl3, dflt3;	/* the class 3 elements */
static struct 	attrib_struct	glbl5, dflt5;	/* the class 5 elements */
/* and now the arrays of function pointer, filled in externally by the
   device initialisation routine */
static int (*delim[Delim_Size])();	/* delimiter functions */
static int (*mfdesc[MfDesc_Size])();	/* metafile descriptor functions */
static int (*pdesc[PDesc_Size])();	/* page descriptor functions */
static int (*mfctrl[Control_Size])();	/* mf control functions */
static int (*gprim[GPrim_Size])();	/* graphical primitives */
static int (*attr[Att_Size])();		/* the attribute functions */
static int (*escfun[Esc_Size])();	/* the escape functions */
static int (*extfun[Ext_Size])();	/* the external functions */
static int (*ctrl[Delim_Size])();	/* external controller functions */
extern void s_defaults();		/* in utils.c */
#define MAX_PAGES 1000 /* max no of pages we'll use */
static struct ad_struct page_ads[MAX_PAGES], last_ad, save_ad;
static int cmd_len, to_screen = 0, do_list = 0, random_file, curr_page,
  top_page;
static char cmd_line[max_str];
/* initialise things */
wint_initialise(argc, argv)
     int argc;
     char **argv;
{
  /* need to set the option defaults */
  strcpy(cmd_line, "GPT");
  if (!parse_cline(cmd_line, argc, argv, &to_screen,
		   &do_list, &new_info, new_opt)){
    info_error("couldn't parse the command line !");
    return(0);
  }
  new_opt[(int) nindex].set = 1; /* no indexing yet */
  return(1);
}
/* routine to actually open the input file */
int wopen_file(result, clear_format, setup_call)
     char *result; /* pointer to file name */
     int clear_format; /* what format file ? (0 = binary, 1 = clear text) */
     int (*setup_call)(); /* the device setup call */
{
  char got_name[max_str];
  char in_fname[max_str];		/* the input file name */
  char open_name[max_str];	/* the opened file name */
  char def_name[max_str];		/* default output file specification */
  char full_oname[max_str];	/* full input file specification */
  extern cgm_setup(), ccgm_setup();	/* binary and clear text setup */
  extern get_cmd(), get_clear();		/* get next command */
  extern cgm_command(), do_clear();	/* do the command */
  static int (*end_call)() = NULL;
  static int called_before = 0;

  if (called_before && end_call) (*end_call)(top_page); /* close up device */


  /* open the input file */
  got_name[0] = '\0';
  strcpy(got_name, result);
  to_screen = 1;
  if (!open_input_file(got_name, open_name, !to_screen,
		       clear_format ? ".cgmc" : ".cgm",
		       full_oname, &new_info, clear_format,
		       &random_file)) {
    info_error("couldn't open input file");
    return(0);
  } 
  /* setup the emulation package */
  em_setup(new_opt, &new_info, 
	   &glbl1, &glbl2, &glbl3, &glbl5, delim, mfdesc, pdesc, mfctrl, 
	   gprim, attr, escfun, extfun, ctrl, NULL, NULL);
  
  /* now go ask the device what it thinks */
  (*setup_call)(new_opt, &new_info, 
	   &glbl1, &glbl2, &glbl3, &glbl5, delim, mfdesc, pdesc, mfctrl, 
	   gprim, attr, escfun, extfun, ctrl, NULL, NULL);
  
  /* we override the close out call */
  end_call = delim[(int) E_Mf];
  delim[(int) E_Mf] = NULL;
  ++called_before;

  /* and come to a conclusion */
  consult_device(new_opt, &new_info);
  
  /* set the defaults */
  s_defaults(&glbl1, &dflt2, &dflt3, &dflt5, &glbl5, 1.0);
  
  
  /* setup the command interpreters */
  if (clear_format) {
    if (!ccgm_setup(do_list, full_oname, version_str, &new_info, 
		    new_opt, &glbl1, &glbl2, &dflt2, &glbl3, &dflt3, &glbl5, 
		    &dflt5, delim, mfdesc, pdesc, mfctrl, gprim, attr, escfun, 
		    extfun, ctrl)) {
      info_error("couldn't setup clear text");
      return(0);
    } else {	/* setup pointers */
      get_command = get_clear;
      do_command = do_clear;
    }
  }
  else {
    if (!cgm_setup(do_list, full_oname, version_str, &new_info, 
		   new_opt, &glbl1, &glbl2, &dflt2, &glbl3, &dflt3, &glbl5, 
		   &dflt5, delim, mfdesc, pdesc, mfctrl, gprim, attr, escfun, 
		   extfun, ctrl, random_file)) {
      info_error("couldn't setup binary\n");
      return(0);
    } else {	/* setup pointers */
      get_command = get_cmd;
      do_command = cgm_command;
    }
  }
  /* allocate main memory */
  start_mem = (unsigned char *) allocate_mem(mem_size, 0);
  if (!start_mem) {
    info_error("couldn't allocate memory");
    return(0);
  }
  /* start up the page array */
  for (curr_page=0; curr_page<MAX_PAGES; ++curr_page) {
    page_ads[curr_page].r_ad = 0;
    page_ads[curr_page].b_ad = 0;
    page_ads[curr_page].offset = 0;
  }
  curr_page = top_page = 0;
  wdraw_next_page(0); /* draw the first page */
  return(1);
}
/* do the next picture */
wdraw_next_page(page_offset)
     int page_offset;
{
  int p_len;	/* parameter length */
  int class, element, cmd_ret, page_wanted;

  page_wanted = curr_page + page_offset;
  if (page_wanted < 0) {
    info_error("no previous pages");
    return(0);
  }
  if (top_page && (page_wanted >= top_page)) {
    info_error("no more pages");
    return(0);
  }

  /* do we need to reset the position */
  if (page_offset) {
    cgm_goto(page_ads + page_wanted);  /* need to reset position */
    curr_page = page_wanted;
  }
  /* do the main loop while there is both input and not end picture */
  while  ((p_len = (*get_command)(&start_mem, &mem_size, &last_ad)) >= 0) {
    /* get the class and element */
    if (!(cmd_ret = (*do_command)(start_mem, p_len,
				   &last_ad, &class, &element))) break;
    /* check various cases */
    if ((class == 0) && (element == (int) B_Pic)) { /* begin picture */
      save_ad.b_ad = last_ad.b_ad;
      save_ad.r_ad = last_ad.r_ad;
      save_ad.offset = last_ad.offset;
    }
    if ((class == 0) && (element == (int) E_Mf)) break; /* end metafile */
    if ((class == 0) && (element == (int) E_Pic)) break; /* end picture */
  }
  
  /* not finished because of end picture ? */
  if ((class == 0) && (element == (int) E_Mf)) {
    info_error("End of file"); 
    top_page = curr_page;
    return(0);
  } else if ((p_len < 0) || !cmd_ret) {
    info_error("Premature end of file");
    top_page = curr_page;
    return(0);
  } else { /* all ok */
    page_ads[curr_page].b_ad = save_ad.b_ad;
    page_ads[curr_page].r_ad = save_ad.r_ad;
    page_ads[curr_page].offset = save_ad.offset;
    ++curr_page;
  }
  return(1);
}
