########################################################################
# sgmlspl script for a *supplemented* version of SGMLS.pm that, when
#    reading an nsgmls ESIS with empty tag labels, provides detection
#    of defined-empty elements with the method  $element->defempty .
#
# Document Type: article (GELLMU)
# Output: text/xml
# Edited by: William F. Hammond
# Begun: 20 June 2006
#
########################################################################

use strict;
use warnings;

our $WhoAmI = "xplaingart.pl";
our $utf8On = 0;
if((exists $ENV{"GELLMU_UTF8"}) && ($ENV{"GELLMU_UTF8"} == 1)){
    use utf8;
    $utf8On = 1;
    print STDERR "  ***  xplaingart.pl: UTF-8 Library\n";
}
else{
print STDERR $0, " *** ", $WhoAmI, "\n";
};
# use SGMLS;			# Use the SGMLS package.
# use SGMLS::Output;		# Use stack-based output.

# Global variables

our $dtdfpi = "-//GNU GPL: William F. Hammond//DTD GELLMU XML 0.7.0//EN";
our $dtdurl = "http://www.albany.edu/~hammond/gellmu/xml/xgellmu.dtd";
our $encoding="ISO-8859-1";  # text encoding of XML output
our $eltdepth=0;
our $eltser=0;
our $maxeltdepth=0;
our @currserial=();
our @agpar=();
our @agseq=();
our @oppar=();
our @opseq=();
our $eqnkey="";
our $eqnser="";
our $eqntag="";
our $asstid="";
our $asstkey="";
our $asstname="";
our $asstser="";
our $asststyle="";
our $tabdepth=0;
our @taburowflag=();
our $bibkey="";
our $biblabel="";
our $citekey="";
our $citenote="";
our $xmlinput=0;
our $stemname="";

our $pname = $0;
$pname =~ s/^.*\///;
our $usage = 
    "Usage:  " . $pname . " < {nsgmls-ESIS}  " . "[ -e={text-encoding} ]\n";
our $arglen = scalar(@ARGV);
print STDERR "No. of args: " . $arglen . "\n";
if ($arglen >= 2){
    print STDERR $usage;
    exit(1);
}
elsif(($arglen == 1) && ($ARGV[0] =~ /^-e=/ )){
    my $tenc = $ARGV[0];
    $tenc =~ s/^-e=//;
    $encoding = $tenc;
    print STDERR "Encoding argument: ", $encoding, "\n";
}
elsif($arglen == 1){
    print STDERR "Unrecognized first argument: ", $ARGV[0], "\n";
    exit(1);
}
else{
    if((exists $ENV{"GELLMU_Encoding"}) && ($ENV{"GELLMU_Encoding"} ne "")){
	$encoding = $ENV{"GELLMU_Encoding"};
	print STDERR "Using ENV-GELLMU_Encoding: ", $encoding, "\n";
    }
    elsif($utf8On == 1){
        print STDERR "UTF-8 Coding implied by use of UTF-8 library\n";
        $encoding = "UTF-8";
    };
};

print STDERR "Final encoding value: ", $encoding, "\n";

if($encoding eq "ISO-8859-1"){
    $dtdfpi = "-//GNU GPL: William F. Hammond//DTD GELLMU XML 0.7.6//EN";
    $dtdurl = "http://www.albany.edu/~hammond/gellmu/xml/xgellmu.dtd";
    print STDERR "Encoding switch for ISO-8859-1\n";
}
elsif($encoding eq "UTF-8"){
    $dtdfpi = "-//GNU GPL: William F. Hammond//DTD GELLMU XML 0.7.6L//EN";
    $dtdurl = "http://www.albany.edu/~hammond/gellmu/xml/axgellmu.dtd";
    print STDERR "Encoding switch for UTF-8\n";
}
else{
    print STDERR '*** Encoding spec "' . $encoding . "\" not recognized\n";
    exit(2);
};

our $styledir = "../webstyle";
if((exists $ENV{"GELLMU_StyleDir"}) && ($ENV{"GELLMU_StyleDir"} ne "")){
    $styledir = $ENV{"GELLMU_StyleDir"};
};
our $cssurl = $styledir . "/gellmuart.css";

# brk0 is created when the string "\\" appears followed by white space
#    in GELLMU source.  It's content in SGML is "(firstcell,(tabampcell)*)",
#    which is identical to the content model for "taburow".
#    Both "firstcell" and "tabampcell" are allowed to be empty, and
#    none of "brk0", "firstcell", tabampcell", and "taburow" are required
#    to have open or close tags (except for the standard rule in SGML
#    about when an opentag can be omitted, i.e., only where it is required).
#    So "brk0" can be defacto empty.
#
# The meaning for "article" XML of "brk0" and friends depends on the parent
#    of "brk0" as follows:
#
#      Parent         Meaning of "brk0"       Meaning of "firstcell"
#
#      tabubody          taburow                (real) firstcell
#      tabampcell        taburow                (real) firstcell
#      firstcell         taburow                (real) firstcell
#      verblist          nln                    contains nln content    
#      addr              aln                    contains aln content
#      arraybody         arrayrow               firstacell
#      matrix            mxrow                  firstacell
#      eqnabody          eqnrow                 eqnleft
#      [other]           brk [an empty]         [nil]
#
# The content of "brk0" is not pushed, though the content of "firstcell"
# is pushed, except when its parent is "arrbody" or "eqnabody".
#
# Please note that the contents of "verlist" must be safe, not raw
# verbatim.  However, the front "gellmu-verblist" for "gellmu-trans" will
# convert a raw section "\n\\begin{verbatim}\n . . . \n\\end{verbatim}\n"
# to a "verblist" automatically.  (With "gellmu-verblist" just use "\n"
# inside the raw zone for a newline.  Do not use "\\" there for a newline.
#
# GELLMU also has a regular pre-historic "verbatim", whose contents must
# also be safe, that should not be confused with "verblist".  The use of
# "verblist" is recommended.
#
# See also the code for "firstcell" below.
#
sgml('<brk0>', sub{
    $eltser++;
    $eltdepth++;
    if($maxeltdepth < $eltdepth){$maxeltdepth = $eltdepth;};
    $currserial[$eltdepth] = $eltser;
    my $pan = $_[0]->parent->name;
    if($pan eq "verblist"){
	output("<nln\n>");
    }
    elsif($pan eq "addr"){
	output("<aln\n>");
    }
    elsif($pan eq "tabubody"){
	output("<taburow\n>");
    }
    elsif($pan eq "arrbody"){
	push_output('string');
    }
    elsif($pan eq "eqnabody"){  # cf. code for eqnrow
	push_output('string');
    }
    else{
	output("<brk\n/> ");
    };
});
sgml('</brk0>', sub{
    my $pan = $_[0]->parent->name;
    if($pan eq "verblist"){
	output("</nln\n>");
    }
    elsif($pan eq "addr"){
	output("</aln\n>");
    }
    elsif($pan eq "tabubody"){
	if(($taburowflag[$tabdepth]) && ($taburowflag[$tabdepth] == 1)){
	    $taburowflag[$tabdepth] = 0;
	};
	output("</taburow\n>");
    }
    elsif($pan eq "arrbody"){
	my $os = "";
	my $pos = pop_output;
	if(!(defined $pos)){$pos = "";};
	$os = $os . "<arrayrow\n>" . $pos . "</arrayrow>";
	output($os);
    }
    elsif($pan eq "eqnabody"){
	my $pos = pop_output;
	if(!(defined $pos)){$pos = "";};
	my $os = "";
	$os = $os . "<eqnrow\n>";
	$os = $os . $pos;
	$os = $os . "</eqnrow\n>";
	output($os);
    };
    $eltdepth--;
});

sgml('<ag0>', sub{
    my $parentser = $currserial[$eltdepth];
    if(!($parentser)){
	print STDERR "*** WARNING: currserial of parent not defined\n";
	print STDERR "***   elt. ag0, parent " . $_[0]->parent->name . "\n";
    };
    $agseq[$parentser]++;
    $eltser++;
    $eltdepth++;
    if($maxeltdepth < $eltdepth){$maxeltdepth = $eltdepth;};
    $currserial[$eltdepth] = $eltser;
    $agseq[$eltser] = 0;
    $opseq[$eltser] = 0;
    $agpar[$eltdepth] = $_[0]->parent->name;
    push_output('string');
});
sgml('</ag0>', sub{
    $eltdepth--;
    my $parentser = $currserial[$eltdepth];
    my $pos = pop_output;
    if(!(defined $pos)){$pos = "";};
    my $agname = "ag0";
    my $os = "";
    my ($elt, $ev) = @_;
    my $pan = $elt->parent->name;
    if($pan eq "frac"){
	if($agseq[$parentser] == 1){
	    $agname = "numr";
	}
	elsif($agseq[$parentser] == 2){
	    $agname = "denm";
	}
	else{
	    print STDERR "ERROR: Too many arguments for frac";
	};
    }
    elsif($pan eq "binom"){
	if($agseq[$parentser] == 1){
	    $agname = "binu";
	}
	elsif($agseq[$parentser] == 2){
	    $agname = "binl";
	}
	else{
	    print STDERR "ERROR: Too many arguments for binom";
	};
    }
    elsif($pan eq "mscript"){
	if($agseq[$parentser] == 1){
	    $agname = "expr";
	}
	elsif($agseq[$parentser] == 2){
	    $agname = "uleft";
	}
	elsif($agseq[$parentser] == 3){
	    $agname = "lleft";
	}
	elsif($agseq[$parentser] == 4){
	    $agname = "lright";
	}
	elsif($agseq[$parentser] == 5){
	    $agname = "uright";
	}
	else{
	    print STDERR $WhoAmI, ': ERROR -- Too many args (',
	    $agseq[$parentser] , ') for mscript at line ', $ev->line, "\n";
	};
    }
    elsif($pan eq "setOf"){
	if($agseq[$parentser] == 1){
	    $agname = "parm";
	}
	elsif($agseq[$parentser] == 2){
	    $agname = "cond";
	}
	else{
	    print STDERR $WhoAmI, ': ERROR -- Too many args (',
	    $agseq[$parentser], ') for setOf at line ', $ev->line, "\n";
	};
    }
    elsif($pan =~ /^(overset|underset)$/){
	if($agseq[$parentser] == 1){
	    $agname = "deco";
	}
	elsif($agseq[$parentser] == 2){
	    $agname = "expr";
	}
	else{
	    print STDERR $WhoAmI, ': ERROR -- Too many args (',
	    $agseq[$parentser], ") for $pan at line ", $ev->line, "\n";
	};
    }
    elsif($pan eq "assthead"){
	$agname = "asstname";
	$asstname = $pos;
    }
    elsif($pan eq "documentclass"){
	$agname = "dclass";
    }
    elsif($pan eq "cite"){
	$agname = "citekey";
	$citekey = $pos;
    }
    elsif($pan eq "sqrt"){
	$agname = "radicand";
    }
    elsif($pan eq "bibhead"){
	$agname = "bibkey";
    }
    elsif($pan eq "arrhead"){
	$agname = "arrcols";
    }
    elsif($pan eq "anch"){
	$agname = "anchv";
    }
    elsif($pan eq "ftanch"){
	$agname = "ftanchv";
    }
    elsif($pan eq "alabel"){
	$agname = "anchv";
    }
    elsif($pan eq "vect"){
	$agname = "coord";
    }
    elsif($pan eq "tabuhead"){
	$agname = "tabharg";
    }
    elsif($pan =~ /^(table|tableb|tablec|tablech|mtable)$/){
	$agname = "tabarg";
    }
  elsif($pan =~ /^(section|subsection|subsubsection|paragraph|subparagraph)$/){
	$agname = "shead";
    }
  elsif($pan =~ /^(Section|Subsection|Subsubsection|Paragraph|Subparagraph)$/){
	$agname = "shead";
    }
    else{
	print STDERR "xplaingart.pl WARNING: Unknown argument (ag0) in ",
	$pan, "\n";
	$agname = "UnKnownArgument";
    };
    $os = "<" . $agname . "\n>" . $pos . "</" . $agname . ">";
    output($os);
});

sgml('<op0>', sub{
    my $parentser = $currserial[$eltdepth];
    $opseq[$parentser]++;
    $eltser++;
    $eltdepth++;
    if($maxeltdepth < $eltdepth){$maxeltdepth = $eltdepth;};
    $currserial[$eltdepth] = $eltser;
    $agseq[$eltser] = 0;
    $opseq[$eltser] = 0;
    $oppar[$eltdepth] = $_[0]->parent->name;
    push_output('string');
});
sgml('</op0>', sub{
    $eltdepth--;
    my $parentser = $currserial[$eltdepth];
    my $pos = pop_output;
    if(!(defined $pos)){$pos = "";};
    my $opname = "op0";
    my $opattrs = "";
    my $os = "";
    my ($elt, $ev) = @_;
    my $pan = $elt->parent->name;
    if($pan eq "documentclass"){
	$opname = "dstyle";
    }
    elsif($pan eq "vect"){
	$opname = "csep";
    }
    elsif($pan eq "cite"){
	$opname = "citenote";
	$citenote = $pos;
    }
    elsif($pan eq "sqrt"){
	$opname = "radx";
    }
    elsif($pan eq "bibhead"){
	$opname = "biblabel";
    }
    elsif($pan eq "item"){
	my $gpan = $_[0]->parent->parent->name;
	if($gpan =~ /^(description|booklist)$/){
	    $os = "<itemlabel" . $opattrs . "\n>" . $pos
		. "</itemlabel\n>";
	    output($os);
	    return;
	}
	else{
	    $opname = "itemlabel";
	};
    }
    elsif($pan eq "eqnarray"){
	if($opseq[$parentser] == 1){
	    $opname = "eqnkey";
	    $eqnkey = $pos;
	}
	elsif($opseq[$parentser] == 2){
	    $opname = "eqnser";
	    $eqnser = $pos;
	}
	elsif($opseq[$parentser] == 3){
	    $opname = "eqntag";
	    $eqntag = $pos;
	}
	else{
	    print STDERR "xmlgart WARNING: incorrect value of opseq in ",
	    $pan, "\n";
	};
    }
    elsif($pan eq "equation"){
	if($opseq[$parentser] == 1){
	    $opname = "eqnkey";
	    $eqnkey = $pos;
	}
	elsif($opseq[$parentser] == 2){
	    $opname = "eqnser";
	    $eqnser = $pos;
	}
	elsif($opseq[$parentser] == 3){
	    $opname = "eqntag";
	    $eqntag = $pos;
	}
	else{
	    print STDERR "xmlgart WARNING: incorrect value of opseq in ",
	    $pan, "\n";
	};
    }
    elsif($pan eq "assthead"){
	if($agseq[$parentser] > 0){
	    $opname = "asstid";
	    $asstid = $pos;
	}
	else{
	    if($opseq[$parentser] == 1){
		$opname = "asstkey";
		$asstkey = $pos;
	    }
	    elsif($opseq[$parentser] == 2){
		$opname = "asstser";
		$asstser = $pos;
	    }
	    else{
		print STDERR "xplaingart.pl WARNING: Element $pan (ser. ",
		$parentser, "): Incorrect calling sequence\n";
	    };
	};
    }
    elsif($pan =~ /(tabuhead|[Tt]abular|[Tt]able|[Mm]atrix)/){
	$opname = "tabopt";
    }
    elsif($pan eq "anch"){
	$opname = "anchref";
    }
    elsif($pan eq "ftanch"){
	$opname = "ftancht";
    }
    elsif($pan eq "alabel"){
	$opname = "intref";
    }
  elsif($pan =~ /^(section|subsection|subsubsection|paragraph|subparagraph)$/){
	if($opseq[$parentser] == 1){
	    $opname = "sopt";
	}
	elsif($opseq[$parentser] == 2){
	    $opname = "sprefix";
	}
	elsif($opseq[$parentser] == 3){
	    $opname = "sunit";
	}
	else{
	    print STDERR $WhoAmI, ': ERROR -- Too many options (',
	    $opseq[$parentser] , ') for $pan at line ', $ev->line, "\n";
	};
    }
  elsif($pan =~ /^(Section|Subsection|Subsubsection|Paragraph|Subparagraph)$/){
	if($opseq[$parentser] == 1){
	    $opname = "sopt";
	}
	elsif($opseq[$parentser] == 2){
	    $opname = "sprefix";
	}
	elsif($opseq[$parentser] == 3){
	    $opname = "sunit";
	}
	else{
	    print STDERR $WhoAmI, ': ERROR -- Too many options (',
	    $opseq[$parentser] , ') for $pan at line ', $ev->line, "\n";
	};
    }
    else{
	print STDERR "xplaingart.pl WARNING: Unknown option (op0) in ",
	$pan, "\n";
	$opname = "UnKnownOption";
    };
    $os = "<" . $opname . $opattrs . "\n>" . $pos . "</" . $opname . ">";
    output($os);
});

sgml('<lg0>', sub{
    $eltser++;
    $eltdepth++;
    if($maxeltdepth < $eltdepth){$maxeltdepth = $eltdepth;};
    $currserial[$eltdepth] = $eltser;
    $agseq[$eltser] = 0;
    $opseq[$eltser] = 0;
    push_output('string');
});
sgml('</lg0>', sub{
    $eltdepth--;
    my $os = "";
    my $pos = pop_output;
    if(!(defined $pos)){$pos = "";};
    my $par = $_[0]->parent;
    my $pan = $par->name;
    my $gpan = $par->parent->name;
    if(($pan =~ /^(tabarg|tabharg)$/)
       || (($pan eq "ag0")
	   && ($gpan  =~ /^(table|tabular|tabuhead|array|arrhead)/))){
	$os = "{" . $pos . "}";
    }
    else{
	$os = "<lgg\n>" . $pos . "</lgg>";
    };
    output($os);
});

#
# Generic Element Handlers.
#
sgml('start', sub{
    $eltdepth = 0;
    my $os = "";
    $os = $os . "<?xml version=\"1.0\" encoding=\"" . $encoding
	. '" standalone="yes"' . "?>\n";
    $os = $os . "<?xml-stylesheet type=\"text/css\"\n";
    $os = $os . "   href=\"" . $cssurl . "\"?>\n";
    $os = $os . "<!DOCTYPE article\n  PUBLIC \"" . $dtdfpi . "\"\n  \""
              . $dtdurl . "\">\n";
    output($os);
});
sgml('end', sub{
    if (!($eltdepth == 0)){
	print STDERR "WARNING: Coding error in sgmlspl file: ", $WhoAmI,
        "\n    eltdepth not balanced; ending with value ", $eltdepth, ".\n";
    };
    if($tabdepth != 0){
	print STDERR "WARNING: Coding error in sgmlspl file: ", $WhoAmI,
        "\n    tabdepth not balanced; ending with value ", $tabdepth, ".\n";
    };
    print STDERR "  No. of elts.: ", $eltser,
                 "; max elt. depth ", $maxeltdepth, "\n";
    output("\n");
});

sgml('start_element', sub{
    $eltser++;
    $eltdepth++;
    if($maxeltdepth < $eltdepth){$maxeltdepth = $eltdepth;};
    $currserial[$eltdepth] = $eltser;
    my ($element, $event) = @_;
    my $name = $element->name;
    my $oname = $name;
    my $pan = "";
    unless($eltdepth == 1){
	$pan = $element->parent->name;
    };
    my $os = "";
    my $close = "";
    my $post = "";
    if(($name eq "trb") || ($name eq "trc")){
	$oname = "tr";
    }
    elsif(($name eq "tdb") || ($name eq "tdc")){
	$oname = "td";
    }
    elsif($name eq "lg0"){
	$oname = "lgg";
    }
    elsif($name eq "assertion"){
	$asstid = "";
	$asstkey = "";
	$asstser = "";
    }
    elsif(($name eq "item") && ($pan eq "booklist")){
	$oname = "ditem";
    }
    else{
	;
    };
    my $open= "<" . $oname;
    my $osatt = "";
#    my $clcn = ">\n";
    my $clcm = "\n>";
    my $clc = $clcm;
    my @attn = ();
    my @atty = ();
    my @attv = ();
    my $jj = 0;
    my $nat = get_attributes($element, \@attn, \@atty, \@attv);
    if($nat > 0){
	$jj = 0;
	while($jj < $nat){
	    if(($atty[$jj] =~ /CDATA|TOKEN/ ) && ($attv[$jj] ne "")){
		$osatt = $osatt . " " . $attn[$jj] . '="' . $attv[$jj] . '"';
	    };
	    $jj++;
	};
    };
    if($element->defempty){
	if( ($name eq "nul") && ($pan eq "mathsym") ){
	    return;
	};
#	$clcn = " />\n";
	$clcm = "\n/>";
	$clc = $clcm;
    }
    else{
	$agseq[$eltser] = 0;
	$opseq[$eltser] = 0;
	if($name eq "article"){
	    # article has no other attributes to consider
	    $osatt = "";
	    my $stem = $_[0]->attribute("stem")->value;
	    if($stem ne ""){
		$stemname = $stem;
		# my $stempat = "^.*/";
		# $stemname =~ s/$stempat//;
		$osatt = " stem=\"" . $stemname . "\"";
	    }
	    else{
		print STDERR
         "xplaingart.pl WARNING: \"stem\" attribute of root element not found\n";
	    };
	}
	elsif($name =~ /^(tabular|array)$/){
	    $tabdepth++;
	    $taburowflag[$tabdepth] = 0;
	}
	elsif($name eq "firstcell"){
	    unless(($pan =~ /^(taburow|arrayrow|mxrow|eqnrow)$/) ||
	     (($pan eq "brk0") && ($element->parent->parent->name
			    =~ /^(tabubody|arrbody|matrix|eqnabody)$/))){
		return;
	    };
	}
	elsif($name eq "Discard"){
	    output("<Discard>");
	    push_output('nul');
	}
	elsif($name eq "documentclass"){
	    push_output('string');
	    return;
	}
	else{
	    ;
	};
    };
    $open = $open . $osatt . $clc;
    $os = $close . $open . $post;
    output($os);
});
sgml('end_element', sub{
    $eltdepth--;
    my ($element, $event) = @_;
    my $name = $element->name;
    my $oname = $name;
    my $pan = "";
    unless($name eq "article"){
	$pan = $element->parent->name;
    };
    my $pos = "";
    my $os = "";   # But mainly here use $pclose and $close
    my $pclose = ""; # Popped output and consequences
    my $close = "";  # Output string beginning with closetag
    my $clcm = "\n>";     # was:   my $clcn = ">\n";
    my $clc = ">";
    if(!$element->defempty){
	if($name eq "article"){
	    ;
	}
	elsif(($name eq "trb") || ($name eq "trc")){
	    $oname = "tr";
	}
	elsif(($name eq "tdb") || ($name eq "tdc")){
	    $oname = "tdr";
	}
	elsif($name eq "lg0"){
	    $oname = "lgg";
	}
	elsif(($name eq "item") && ($pan eq "booklist")){
	    $oname = "ditem";
	}
	elsif($name =~ /^(tabular|array)$/){
	    $tabdepth--;
	}
	elsif($name eq "firstcell"){
	    unless(($pan =~ /^(taburow|arrayrow|mxrow|eqnrow)$/) ||
	     (($pan eq "brk0") && ($element->parent->parent->name
			    =~ /^(tabubody|arrbody|matrix|eqnabody)$/))){
		return;
	    };
	}
	elsif($name eq "Discard"){
	    pop_output;
	}
	elsif($name eq "documentclass"){
	    $pos = pop_output;
	    if(!(defined $pos)){$pos = "";};
	    my $ser = $currserial[$eltdepth];
	    if($agseq[$ser] == 0){
		$os = "<documentclass><dclass>" . $pos
		    . "</dclass></documentclass\n>";
		output($os);
		return;
	    };
	}
	else{
	    ;
	};
	$close = $close . "</" . $oname;
	$close = $close . $clc;
	$os = $pclose . $close;
	output($os);
    };
});

sgml('pi',sub{
    my $inst = $_[0];
    if($inst =~ /^xml /){
	$xmlinput = 1;
    }
    elsif($inst =~ /^xml-stylesheet /){
	$xmlinput = 1;
    }
    else{
	print STDERR "***** UNKNOWN PROCESSING INSTRUCTION: " . $_[0];
    };
});

sgml('re', sub{
    my $os;
    if($xmlinput == 1){
	return;
    }
    else{
	$os = "\n";
    };
    output($os);
});

#
# Default handlers (uncomment these if needed).  Right now, these are set
# up to gag on any unrecognised elements, sdata, processing-instructions,
# or entities.
#
# sgml('cdata',sub { output $_[0]; });
# sgml('sdata',sub { die "Unknown SDATA: " . $_[0]; });
# The next line is commented in the default output of Megginson's "skel.pl"
# sgml('entity',sub { die "Unknown external entity: " . $_[0]->name; });
# sgml('start_subdoc',sub { die "Unknown subdoc entity: " . $_[0]->name; });
# sgml('end_subdoc','');
# sgml('conforming','');

sub get_attributes {
    my ($elt, $rattn, $ratty, $rattv) = @_;
    # $rattn, $rattv are references to passed arrays
    my $attref = $elt->attributes;
    my %atts = %$attref;
    my @atns = keys(%atts);
    my $nat = scalar @atns;
    my $jj = 0;
    my $jty = "";
    my $jvs = "";
    while($jj < $nat){
	$$rattn[$jj] = $atns[$jj];
	$jty = $atts{$atns[$jj]}->type;
	$$ratty[$jj] = $jty;
	if($jty eq "CDATA"){
	    $jvs = $atts{$atns[$jj]}->value;
	}
	elsif($jty eq "TOKEN"){
	    $jvs = $atts{$atns[$jj]}->value;
	}
        elsif($jty eq "IMPLIED"){
	    $jvs = $atts{$atns[$jj]}->value;
	}
	elsif(($jty eq "NOTATION")||($jty eq "ENTITY")){
	    $jvs = "WARNING: attribute type " . $jty
                   . " not supported by this code";
	}
	else{
	    $jvs = "WARNING: ATTRIBUTE TYPE ERROR: " . $jty;
	}
	$$rattv[$jj] = $jvs;
	$jj++;
    };
    return $nat;
};

1;
