##########################################################################
# mval.pl an SGMLSPL script for checking a few math issues in XHTML+MathML
#   among unknown SGML elements
#
# Copyright (c) 2007 by William F. Hammond <hammond@math.albany.edu>
#
# Modified from:
# skel.pl: an SGMLSPL script for producing scripts (!!).
#
# Copyright (c) 1995 by David Megginson <dmeggins@aix1.uottawa.ca>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
##########################################################################

use SGMLS;
use SGMLS::Output;

%subdocs = ();			# Subdocument entities seen so far.
%entities = ();			# External data entities seen so far.
%sdata = ();			# SDATA strings seen so far.
%elements = ();			# Elements seen so far.
$pi = 0;			# Any processing instructions?

$intro = 0;			# Have we printed the banner yet?
$havefilename = 0;              # Have we caught the filename?
$filename = "";                 # Make $filename a safe string.

$| = 1;

sgml('end_subdoc', '');		# Ignore the ends of subdocument entities.
sgml('re', '');			# Ignore Record Ends.

# Note any processing instructions.
sgml('pi', sub { $pi = 1; });

sgml('start_subdoc', sub {
    my $subdoc = shift;
    $subdocs{$subdoc->name} = 1;
});
				# Keep track of all external data entities.
sgml('entity', sub {
    my $entity = shift;
    $entities{$entity->name} = 1;
});
				# Keep track of all SDATA strings
sgml('sdata', sub {
    my $sdata = shift;
    $sdata{$sdata} = 1;
});

sgml('start', sub{
$level = 0;
$plevel = 0;
$math = 0;
$serial = 0;
$depth = 0;
@nkids = ();   # count for given level
push_output('nul');
});

sgml('start_element', sub{
    my ($element, $event) = @_;
    my $name = "";
    $serial++;
    $plevel = $level;
    $level++;
    $pserial[$level] = $serial;
    if($level > $depth){$depth = $level;}
    $name = $element->name;
    if($name eq "math"){
	$math = 1;
    }
    elsif($math == 1){
	$pan = $element->parent->name;
	if($name =~ /^(msup|msub|msubsup|mover|munder|munderover|mfrac)$/){
	    $nkids[$level] = 0;
	};
	if($pan =~ /^(msup|msub|msubsup|mover|munder|munderover|mfrac)$/){
	    $nkids[$plevel]++;
	};
    };
});

sgml('end_element', sub{
    my ($element, $event) = @_;
    my $name = $element->name;
    if($name eq "math"){
	$math = 0;
    }
    elsif($math == 1){
	$pan = $element->parent->name;
	if($name =~ /^(msup|msub|mover|munder|mfrac)$/){
	    if ($nkids[$level] != 2){
		my $ktext = " children";
		if($nkids[$level] == 1){
		    $ktext = " child";
		};
		print STDERR "*** MathML Error, file \"" . $event->file
		    . "\" line " . $event->line . ":\n", "    Element \""
		    . $name . "\" has " . $nkids[$level] . $ktext
		    . " instead of required 2\n";
	    };
	}
	elsif($name =~ /^(msubsup|munderover)$/){
	    if ($nkids[$level] != 3){
		my $ktext = " children";
		if($nkids[$level] == 1){
		    $ktext = " child";
		};
		print STDERR "*** MathML Error, file \"" . $event->file
		    . "\" line " . $event->line . ":\n", "    Element \""
		    . $name . "\" has " . $nkids[$level] . $ktext
		    . " instead of required 3\n";
	    };
	};
    };
    $level--;
});

sgml('end', sub {
    pop_output;
});

sgml('cdata', sub{
    ;
});

sgml('entity',sub{
    print STDERR "Unknown external entity: " . \$_[0]->name;
});

1;
