Unit unixio;
{$V+}
{$R-}


{ I/o to allow read of UNIX files.

  JCC 18 Aug 91

}

{$E+}    { Force use of emulation.}
interface

uses utils;

const
   BUFSIZE = 2000;
   lf = ^J;
   EOFCHAR = #26;

type
   Pchars= ^char;
   Pfile = ^MyStream;
   MyStream = record
      data: file;
      status: (fmclosed, fminput, fmoutput);
      prev, last: integer; { pointers to buffer }
      curbufsize: integer;
      buff: string[255];
{      buff: array [0..BUFSIZE] of char;}
   end;

procedure fclose (var f: Pfile);

function feof (f: Pfile) : boolean;

function fgetc (f: Pfile): char;

{$V+}
procedure fgetline (f: Pfile; var line: longstring);

{$V+}
procedure fgets (f: Pfile; var line: longstring);

function fopen (name: string; mode: char): Pfile;



implementation
{$V+}

type
   BigArray = array[1..maxint] of char;
   PBigArray = ^BigArray;


function min (i, j: integer): integer;
   begin
      if (i < j) then
         min := i
      else
         min := j;
   end;


procedure clearstream (f: Pfile);
   begin
      if (f = nil) then exit;
      with f^ do begin
         status := fmclosed;
         curbufsize := sizeof (buff) - 1;
         prev := 0;
         last := 0;
      end;
   end;


procedure makestream (var f: Pfile);
   begin
      new (f);
      if (f <> nil) then
         clearstream (f);
   end;


procedure removestream (var f: Pfile);
   begin
      if (f <> nil) then begin
         dispose (f);
         f := nil;
      end;
   end;


procedure FillBuff (f: Pfile);
   begin
      if (f <> nil) then
      with f^ do begin
         last := 0;
         prev := 0;
         if (not eof (data)) then
            blockread (data, buff[1], sizeof(buff)-1, last);
            buff[0] := chr(last);
      end;
   end;


procedure fclose (var f: Pfile);
   begin
      if (f = nil) then exit;
      if (f^.status <> fmclosed) then
         close (f^.data);
      removestream (f);
   end;


function feof (f: Pfile) : boolean;
   begin
      if (f = nil) then
         feof := true
      else with f^ do
      begin
         if (status = fmclosed) then
            feof := true
         else if (prev < last) then
            feof := false
         else
            feof := eof (data);
      end;
   end;


function fgetc (f: Pfile): char;
   label exit;
   begin
      { Default in case of inability to read: }
      fgetc := EOFCHAR;
      if (f = nil) then
         goto exit;
      with f^ do begin
         if (status <> fminput) then
            goto exit;
         if (prev >= last) then
            FillBuff(f);
         if (last > 0) then begin
            inc (prev);
            fgetc :=  buff[prev];
         end else
            fgetc := EOFCHAR;
      end;
      exit:
   end;

{$V+}
procedure fgetline (f: Pfile; var line: longstring);
   label
      exit, domove;
   var
      c: char;
      i, numtomove, numread: integer;
      done: boolean;
   const
      max = sizeof(longstring) -1;
   begin

      { Default in case of inability to read: }
      line := '';
      numread := 0;
      if (f = nil) then
         goto exit;
      if (f^.status <> fminput) then
         goto exit;

      with f^ do begin
         done := false;
         while (not done) do begin
            {Use move to do save time on fastest part of search: }
            if (prev >= last) then
               FillBuff(f);
            numtomove := min (last-prev, max-numread);
            if ( (last <= 0) or (numtomove <= 0) ) then begin
               done := true;
               numtomove := 0;
            end;
            { Find end-of-line, if any: }
            for i := prev + 1 to prev + numtomove do begin
               if (buff[i] = lf) then begin
                  numtomove := i-prev;
                  done := true;
                  goto domove;
               end;
            end;
         domove:
            move (buff[prev+1], line[numread+1], numtomove);
            inc (prev, numtomove);
            inc (numread, numtomove);
         end;
      end;

   exit:
      line[0] := chr (numread);

   end;


{$V+}
procedure fgets (f: Pfile; var line: longstring);
   var i: integer;
   begin
      fgetline (f, line);
      i := length (line);
      while ( (i>0) and (line[i] in [cr, lf]) ) do
         dec (i);
      line[0] := chr(i);
   end;


procedure fgetlongline (f: Pfile; pc: PChars; max: integer;
                        var numread: integer);

{====BUGGY!============}
   label
      exit;
   var
      pc1: PBigArray;
      c: char;
   begin
      { Default in case of inability to read: }
      numread := 0;
      pc1 := PBigArray(pc);
      if (max < 0) then
         goto exit;
      if (f = nil) then
         goto exit;
      if (f^.status <> fminput) then
         goto exit;

      with f^ do begin
         while (numread < max) do begin
            if (prev >= last) then
               FillBuff(f);
            if (last > 0) then begin
               inc (prev);
               inc (numread);
               c :=  buff[prev];
               pc1^[numread] := c;
               if (c = lf) then
                  goto exit;
            end;
         end;
      end;

      exit:
   end;


function fopen (name: string; mode: char): Pfile;
   var
      f: Pfile;
      IOstatus: integer;
   label
      exit;
   begin
      makestream (f);
      mode := upcase (mode);
      if f = nil then goto exit;

      case mode of
      'R': begin
            assign (f^.data, name);
            {$I-} reset (f^.data, 1); {$I+}
            IOStatus := IOResult;
            if (IOStatus <> 0) then
               removestream (f)
            else
               f^.status := fminput;
         end;
      'W': begin
            assign (f^.data, name);
            {$I-} rewrite (f^.data, 1); {$I+}
            IOStatus := IOResult;
            if (IOStatus <> 0) then
               removestream (f)
            else
               f^.status := fmoutput;
         end;
      else
         removestream(f);
      end;

   exit:
      fopen := f;
   end;



{ ===============INITIALIZATION:======================}

end.

