

drop table if exists tempsearchindex;
drop table if exists talks;
drop table if exists slides;
drop table if exists slideorder;
drop table if exists wordindex;
drop table if exists talksfirstslide;
drop table if exists slidebelongstotalk;
drop table if exists slideispartoftalk;
drop table if exists searchindex;
drop table if exists thesaurustypes;
drop table if exists thesaurus;


create table tempsearchindex
(
  word varchar(40) BINARY,
  slideid mediumint unsigned,
  unique (word,slideid),
  index(word));


create table talks
(
   talkid mediumint unsigned auto_increment,
   subject varchar(255),
   title varchar(80),
   sourcefilename varchar (80),
   originalfilename varchar(80),
   unique(talkid),
   index(talkid),
   firstslideid mediumint unsigned
);

create table slides
(
  slideid mediumint unsigned auto_increment,
  index(slideid),
  unique(slideid),
  aannotation varchar(2000),
  annotation varchar(2000),
  source mediumtext,
  subject varchar(255),
  title varchar(80),
  version smallint,
  duration datetime,
  dateofcreation datetime,
  dateofmodification timestamp
);




create table talksfirstslide
(
  talkid mediumint unsigned,
  slideid mediumint unsigned,
  primary key(talkid),
  foreign key (talkid) references talks(talkid),
  foreign key (slideid) references slides(slideid)
);


create table slideorder
(
  slideid mediumint unsigned,
  predslideid mediumint unsigned,
  primary key (slideid,predslideid)
);

create table slidebelongstotalk
(
  slideid mediumint unsigned,
  talkid mediumint unsigned,
  foreign key(slideid) references slides(slideid),
  foreign key(talkid) references talks(talkid)
);

create table slideispartoftalk
(
  slideid mediumint unsigned,
  talkid mediumint unsigned,
  foreign key(slideid) references slides(slideid),
  foreign key(talkid) references talks(talkid)
);


CREATE TABLE `wordindex` (
  `wordid` mediumint(8) unsigned NOT NULL auto_increment,
  `word` varchar(63) BINARY NOT NULL default '',
  PRIMARY KEY  (`word`),
  UNIQUE KEY `wordid_2` (`wordid`),
  KEY `wordid` (`wordid`),
  KEY `word` (`word`)
);


create table searchindex
(
  wordid mediumint unsigned,
  slideid mediumint unsigned,
  foreign key (wordid) references wordindex(wordid),
  foreign key (slideid) references slides(slideid));

create table thesaurustypes
(
  typeid smallint unsigned not null auto_increment,
  typename varchar(40),
  behaviour smallint unsigned,
  primary key(typeid,typename,behaviour)
);

create table thesaurus
(
  wordid mediumint unsigned not null,
  type smallint unsigned not null,
  matchid mediumint unsigned not null,
  foreign key(wordid) references wordindex(wordid),
  foreign key(matchid) references wordindex(wordid),
  foreign key(type) references thesaurustypes(typeid),
  index(wordid)
);
