{$IFDEF WINDOWS}
{$N-,V-,W-,G+}
{$ELSE}
{$N-,E-,V-,O+,F+}
{$ENDIF}

Unit bibReadD;

Interface

Uses
{$IFDEF WINDOWS}
  wbibdisp, rc_id, WObjects, WinTypes, wbibgui,
{$ELSE}
  bibwindo, BibCrt, bibdisp, bibedit, objects,
{$ENDIF}
  bibstrg, bibtext, bibvars, bibfile, bibutil, bib8bit, bibPchec, rc_strng;



procedure GetDBEntry(Entry: EntryRecPtr; InStrm: PStream; ToEntry: Word;
                     match: string;
                     Pattern: PatRecPtr; var ok: boolean);

Implementation

procedure GetDBEntry(Entry: EntryRecPtr; InStrm: PStream; ToEntry: Word;
                     match: string;
                     Pattern: PatRecPtr; var ok: boolean);
var
  line, tmp : string;
  j,k,lmatch,count : integer;
  i,pl: word;
  Jind,Vind,TYind,Iind,Tind,Bind,Kind,Aind,Eind,Yind: byte;
  enough,leave,fitstart,fitend,BeginBrace,foundit,ReadBS: boolean;
  CaseSen,RegExp: boolean;
  ifld : byte;
  OldPlace: longint;

function EOF_bib(S: PStream): boolean;
begin
  if S=Nil then EOF_bib:=eof(bib)
  else EOF_Bib:=(S^.Status<>stok) or (S^.GetPos>=S^.GetSize);
end;

procedure GetChar(var ch: char);
begin
  if InStrm=Nil then read(bib,ch) else InStrm^.read(ch,1);
end;

procedure ReadEntry(Entry: EntryRecPtr);
Label
  GotoDBError;
var
  i,ifld,CurMaxBig,Blength : word;
  Buffer: BigTypePtr;
  CurrentBuffer: Byte;
  SBuffer: array[1..256] of char;
  ch: char;
  Ok1,fchanged,BareQuote,retain: boolean;

procedure GetNextString(var Sin; var Slen: Word; Var ch: Char; MaxBig: Word);
Label
  ExitNextString;
Var
  S: BigType ABSOLUTE Sin;
  i: Word;
begin
  WinYield;
  Slen:=0;
  if Eof_bib(InStrm) or (ch=#10) then Exit;
  repeat
    GetChar(ch);
  until Eof_bib(InStrm) or (ch=#10) or (ch=CommaSeparator) or (ch='"')
        or (ch in ['0'..'9']);
  if Eof_bib(InStrm) or (ch=#10) or (ch=CommaSeparator) then goto ExitNextString;
  if ch='"' then
  begin
    GetChar(ch);
    if (ch<>#10) and (ch<>#13) then
    begin
      inc(Slen); S[Slen]:=ch;
    end else if Eof_bib(InStrm) or (ch=#10) then goto ExitNextString;
    repeat
      GetChar(ch); if ch=#10 then goto ExitNextString;
      if (Slen>0) and (ch='"') and (S[Slen]='"') then S[Slen]:=#1
      else if (ch<>'"') and (Slen>0) and (S[Slen]='"') then
      begin
        Dec(Slen); goto ExitNextString;
      end else if (ch<>#13) and (slen<MaxBig) then
      begin
        inc(Slen); S[Slen]:=ch;
      end;
    until Eof_bib(InStrm);
    if (Slen>0) and (S[Slen]='"') then Dec(Slen);
  end else
  begin
    inc(Slen); S[Slen]:=ch;
    while (not Eof_bib(InStrm)) and (ch in [#13,'0'..'9']) do
    begin
      GetChar(ch);
      if (ch in ['0'..'9']) and (slen<MaxBig) then
      begin
        inc(Slen); S[Slen]:=ch;
      end;
    end;
  end;

ExitNextString:
  for i:=1 to Slen do if S[i]=#1 then S[i]:='"';
end;                    { GetNextString }

begin                   { ReadEntry }
  ch:=#0;
  with Entry^ do
  begin
    nentry:=0; EntryType:='';
    for i:=1 to maxfield+1 do
    begin
      index[i]:=0;
      BigIndex[i]:=0;
    end;
    for i:=1 to MaxNumberBig do
    begin
      BigFree[i]:=true; Blen[i]:=0;
    end;
    name:='';
    repeat
      if (ch=#10) and (not Eof_bib(InStrm)) then ch:=#0;
      GetNextString(name[1],i,ch,255);
    until (i>0) or (Eof_bib(InStrm)) or (ch<>#10);
    if i>0 then name[0]:=Chr(i);
    entrytype:='';
    GetNextString(entrytype[1],i,ch,255);
    if i>0 then entrytype[0]:=Chr(i); StrLwr(entrytype);
    j:=0;
    for i:=1 to numberoftypes do
      if entrytype=typeentry^[i] then j:=i;
    if j=0 then
    begin
      if Verbosity>2 then ErrorMessageRC(Str_UnknownType,EntryType);
      goto GotoDBError;
    end;
    for ifld:=1 to FieldLast do
    begin
      CurrentBuffer:=FindBigFree(Entry,false);
      if CurrentBuffer=0 then                  { All big fields are full }
      begin
        Buffer:=@SBuffer[1]; CurMaxBig:=255;
      end else
      begin
        Buffer:=@Entry^.Big[CurrentBuffer]^[1]; CurMaxBig:=MaxBig;
      end;
      Blength:=0;
      GetNextString(Buffer^,Blength,ch,MaxBig);
      
      if not OkField(Buffer^,Blength,3,'','',BareQuote) then
      begin
        if AskIfRC(Str_UnbalancedField,'','','Edit','Discard') then
        begin
{$IFDEF WINDOWS}
        if Application^.ExecDialog(New(PEditAFieldDlg,
            Init(MainW,PChar(rc_EditTibFieldDlg),Nil,true,Buffer,@Blength,CurMaxBig)
              ))<>id_ok then Blength:=0;
{$ELSE}
          MakeWindow(3,2,ScrLen-3,ScrWidth-2,EditNorm,EditNorm,2,RNorm,0,0);
          repeat
            ReadBig('Data: ',Buffer^,Blength,
                 3,2,ScrLen-3,ScrWidth-2,[#0..#31,#255]-[#21],fchanged,retain,
                 CurMaxBig,false,CaseSen,RegExp,Nil,false,false,'');
            Ok1:=OkField(Buffer^,Blength,3,
                 StringRC(Str_UnbalancedBracesInText,''),
                 StringRC(Str_IllegalMacroSyntax,''), BareQuote);
          until Ok1;
          RemoveWindow;
{$ENDIF}
        end else Blength:=0;
      end;
      
      if Blength>0 then
      begin
        inc(nentry);
        Field[nentry]:=typefield^[ifld];
        index[ifld]:=nentry;
        Content[nentry]:='';
        if Blength>255 then
        begin
          Move(Buffer^[1],Content[nentry][1],255);
          Content[nentry][0]:=#255;
          Entry^.BigFree[CurrentBuffer]:=false;
          BigIndex[ifld]:=CurrentBuffer;
          Blen[CurrentBuffer]:=Blength;
        end else
        begin
          Move(Buffer^[1],Content[nentry][1],Blength);
          Content[nentry][0]:=Chr(Blength);
          if RetainNullFields and (Content[nentry]='') then
            Content[nentry]:='~';
        end;
      end;
    end;
  end;

  Exit;

GotoDBError:

  if (Verbosity>2) and (tmp<>'') and (entry^.name<>'') then
  begin
    ErrorMessage(tmp+' in Entry "'+entry^.name+'"! ');
  end;
  LastReadLine^:=line;
  entry^.nentry:=0;
  entry^.name:='';
  entry^.entrytype:='';
  if (ch<>#10) then
  while (not Eof_bib(InStrm)) and (ch<>#10) do GetChar(ch);
end;                   { ReadEntry }

procedure GoForward(Entry: EntryRecPtr; Pattern: PatRecPtr; var ok: boolean);
var
  orig : Word;
  count: integer;
  eofbib,leave,FindOK : boolean;
  atplace: longint;

procedure FindStart(var AtPlace: longint; var ok: boolean);
var
  tmp: string;
begin
  if Eof_bib(InStrm) then
  begin
    ok:=false; Exit;
  end;
  ok:=true;
  AtPlace:=-1;;
end;             { FindStart }

begin               { GoForward }
  if ok then
  begin
    count:=0;
    if entry^.realnum>0 then orig:=entry^.realnum
    else begin
      orig:=1;
      count:=1;
    end;
    entry^.name:='';
    repeat
      FindStart(atplace,FindOK);
      if entry^.realnum=$ffff then ErrorMessageRC(Str_TooManyEntries,'');
      Inc(entry^.realnum);
      entry^.beginning:=atplace;
      if orig=entry^.realnum then count:=count-1;
      eofbib:=Eof_bib(InStrm);
      if (FindOK) then
      begin
        ReadEntry(Entry);
        if entry^.nentry=0 then
        begin
          ok:=false;
          Dec(entry^.realnum);
        end else if (Pattern<>Nil) and (Pattern^.on) then
          PatternCheck(entry,pattern,ok,true)
        else ok:=true;
      end else ok:=false;
      if ok then entry^.entrynum:=entry^.entrynum+1;
    until (ok) or (Eofbib);
    if Eofbib and (not ok) then
    begin
      ResetBib(Entry);
      repeat
        FindStart(atplace,FindOK);
        entry^.realnum:=entry^.realnum+1;
        entry^.beginning:=atplace;
        if orig=entry^.realnum then count:=count-1;
        eofbib:=Eof_bib(InStrm);
        if (FindOK) then
        begin
          ReadEntry(Entry);
          if entry^.name='' then
          begin
            ok:=false;
            Dec(entry^.realnum);
          end else if (Pattern<>Nil) and (Pattern^.on) then
            PatternCheck(entry,pattern,ok,true)
          else ok:=true;
        end else ok:=false;
      until (ok) or EofBib or (count<0);
      if ok then entry^.entrynum:=entry^.entrynum+1;
    end;
    if not ok then ResetBib(entry);
  end;
end;             { GoForward }

begin            { GetDBEntry }
  pl:=entry^.entrynum;
  ok:=true; line:=''; foundit:=false;
  if toentry>pl then
  begin
    i:=entry^.entrynum;
    while (entry^.entrynum<toentry) and (entry^.entrynum>=i) and ok do
    begin
      OldPlace:=entry^.beginning;
      GoForward(Entry,pattern,ok);
      Inc(i);
    end;
  end else if toentry<pl then
  begin
    pl:=0;
    i:=entry^.entrynum;
    ResetBib(Entry);
    while (entry^.entrynum<toentry) and (entry^.entrynum>=i) and ok do
    begin
      OldPlace:=entry^.beginning;
      GoForward(Entry,pattern,ok); Inc(i);
    end;
  end;
  foundit:=ok;
  if not foundit then ok:=false;
  if entry^.nentry=0 then ok:=false;
end;                       { GetDBEntry }


end.
  

