/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class Bib2GlsDualIndexAbbrev
extends Bib2GlsDualEntry {
    public Bib2GlsDualIndexAbbrev(Bib2Gls bib2Gls) {
        this(bib2Gls, "dualindexabbreviation");
    }

    public Bib2GlsDualIndexAbbrev(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public HashMap<String, String> getMappings() {
        return this.getResource().getDualIndexAbbrevMap();
    }

    @Override
    public String getFirstMap() {
        return this.getResource().getFirstDualIndexAbbrevMap();
    }

    @Override
    public boolean backLink() {
        return this.getResource().backLinkFirstDualIndexAbbrevMap();
    }

    @Override
    protected Bib2GlsDualEntry createDualEntry() {
        return new Bib2GlsDualIndexAbbrev(this.bib2gls, this.getEntryType() + "secondary");
    }

    @Override
    public void checkRequiredFields() {
        if (this.getField("short") == null) {
            this.missingFieldWarning("short");
        }
        if (this.getField("long") == null) {
            this.missingFieldWarning("long");
        }
    }

    @Override
    public String getSortFallbackField() {
        String string = this.resource.getCustomEntryDefaultSortField(this.getOriginalEntryType());
        if (string != null) {
            return string;
        }
        return this.isPrimary() ? "name" : this.resource.getAbbrevDefaultSortField();
    }

    @Override
    public String getFallbackValue(String string) {
        if (string.equals("sort")) {
            return this.getSortFallbackValue();
        }
        if (string.equals("name")) {
            String string2 = this.resource.getAbbrevDefaultNameField();
            String string3 = this.getFieldValue(string2);
            return string3 == null ? this.getFallbackValue(string2) : string3;
        }
        if (string.equals("text")) {
            String string4 = this.resource.getAbbrevDefaultTextField();
            String string5 = this.getFieldValue(string4);
            return string5 == null ? this.getFallbackValue(string4) : string5;
        }
        return super.getFallbackValue(string);
    }

    @Override
    public BibValueList getFallbackContents(String string) {
        if (string.equals("sort")) {
            return this.getSortFallbackContents();
        }
        if (string.equals("name")) {
            String string2 = this.resource.getAbbrevDefaultNameField();
            BibValueList bibValueList = this.getField(string2);
            return bibValueList == null ? this.getFallbackContents(string2) : bibValueList;
        }
        if (string.equals("text")) {
            String string3 = this.resource.getAbbrevDefaultTextField();
            BibValueList bibValueList = this.getField(string3);
            return bibValueList == null ? this.getFallbackContents(string3) : bibValueList;
        }
        return super.getFallbackContents(string);
    }

    @Override
    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s", this.getCsName());
        printWriter.format("{%s}", this.getId());
        if (this.isPrimary()) {
            printWriter.format("{%s}", this.getDual().getId());
        }
        printWriter.format("%%%n{", new Object[0]);
        String string = "";
        String string2 = "";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = "";
        String string7 = "";
        Set<String> set = this.getFieldSet();
        Vector<String> vector = this.resource.getOmitFieldList(this);
        for (String string8 : set) {
            if (vector != null && vector.contains(string8)) {
                this.bib2gls.verboseMessage("message.omitting.field", new Object[]{string8, this.getId()});
                continue;
            }
            if (string8.equals("description")) {
                string2 = this.getFieldValue(string8);
                continue;
            }
            if (string8.equals("name")) {
                string3 = this.getFieldValue(string8);
                continue;
            }
            if (string8.equals("short")) {
                string6 = this.getFieldValue(string8);
                continue;
            }
            if (string8.equals("long")) {
                string7 = this.getFieldValue(string8);
                continue;
            }
            if (this.bib2gls.isKnownField(string8)) {
                String string9 = this.getFieldValue(string8);
                if (string8.equals("parent")) {
                    string4 = string9;
                } else if (string8.equals("plural")) {
                    string5 = string9;
                }
                printWriter.format("%s", string);
                string = String.format(",%n", new Object[0]);
                printWriter.format("%s={%s}", string8, string9);
                continue;
            }
            if (!this.bib2gls.isDebuggingOn() || this.bib2gls.isInternalField(string8) || this.bib2gls.isKnownSpecialField(string8)) continue;
            this.bib2gls.debugMessage("warning.ignoring.unknown.field", new Object[]{string8});
        }
        if (string3 == null) {
            string3 = this.getFallbackValue("name");
            this.writePluralIfInherited(printWriter, string3, string4, string5, string);
        }
        printWriter.println(String.format("}%%%n{%s}{%s}{%s}%n{%s}", string3, string6, string7, string2));
        this.writeInternalFields(printWriter);
    }

    @Override
    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        if (this.isPrimary()) {
            this.resource.writeAbbrvFontCommands(printWriter);
            printWriter.format("\\providecommand{\\%s}[7]{%%%n", this.getCsName());
            printWriter.println("  \\longnewglossaryentry*{#1}{%");
            printWriter.print("      name={\\protect");
            String string = this.resource.getAbbrevDefaultNameField();
            if (string.equals("short")) {
                printWriter.print("\\bibglsuseabbrvfont");
            } else if (string.equals("long")) {
                printWriter.print("\\bibglsuselongfont");
            } else {
                printWriter.print("\\bibglsuseotherfont");
            }
            printWriter.println("{#4}{\\glscategory{#2}}},%");
            printWriter.println("      category={index},#3}{}%");
        } else {
            printWriter.format("\\providecommand{\\%s}[6]{%%%n", this.getCsName());
            printWriter.println("  \\ifstrempty{#6}%");
            printWriter.println("  {\\newabbreviation[#2]{#1}{#4}{#5}}%");
            printWriter.println("  {\\newabbreviation[#2,description={#6}]{#1}{#4}{#5}}%");
        }
        printWriter.println("}");
    }
}

