<TeXmacs|1.0.7.11>

<style|<tuple|tmdoc|maxima>>

<\body>
  <\tmdoc-title>
    Example <name|Octave> session
  </tmdoc-title>

  An <name|Octave> session is started using <menu|Insert|Session|Octave>.
  Below, it is shown how to do linear algebra operations with <name|Octave>,
  such as matrix multiplication, inversion and diagonalization. Notice that
  you need to use the <verbatim|tmdisp> command (at the moment) in order to
  display the output in mathematical form.

  <\session|octave|default>
    <\output>
      GNU Octave, version 2.1.40 (i386-redhat-linux-gnu).

      Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002 John W. Eaton.

      This is free software; see the source code for copying conditions.

      There is ABSOLUTELY NO WARRANTY; not even for MERCHANTIBILITY or

      FITNESS FOR A PARTICULAR PURPOSE.

      \;

      Report bugs to \<less\>bug-octave@bevo.che.wisc.edu\<gtr\>.

      \;
    </output>

    <\unfolded-io|octave\<gtr\> >
      A=[1 0 0 0;2 2 0 0;-1 0 2 0;0 -1 2 2]
    <|unfolded-io>
      A =

      \;

      \ \ \ 1 \ \ 0 \ \ 0 \ \ 0

      \ \ \ 2 \ \ 2 \ \ 0 \ \ 0

      \ \ -1 \ \ 0 \ \ 2 \ \ 0

      \ \ \ 0 \ -1 \ \ 2 \ \ 2

      \;

      \;
    </unfolded-io>

    <\unfolded-io|octave\<gtr\> >
      tmdisp(A^2)
    <|unfolded-io>
      <math|<with|math-display|true|<matrix|<tformat|<table|<row|<cell|1>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|6>|<cell|4>|<cell|0>|<cell|0>>|<row|<cell|-3>|<cell|0>|<cell|4>|<cell|0>>|<row|<cell|-4>|<cell|-4>|<cell|8>|<cell|4>>>>>>>

      \;
    </unfolded-io>

    <\unfolded-io|octave\<gtr\> >
      tmdisp(A.^2)
    <|unfolded-io>
      <math|<with|math-display|true|<matrix|<tformat|<table|<row|<cell|1>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|4>|<cell|4>|<cell|0>|<cell|0>>|<row|<cell|1>|<cell|0>|<cell|4>|<cell|0>>|<row|<cell|0>|<cell|1>|<cell|4>|<cell|4>>>>>>>

      \;
    </unfolded-io>

    <\unfolded-io|octave\<gtr\> >
      [u,v]=eig(A)
    <|unfolded-io>
      u =

      \;

      \ \ \ 0.00000 \ \ 0.00000 \ \ 0.00000 \ \ 0.21320

      \ \ \ 0.00000 \ \ 0.00000 \ \ 0.00000 \ -0.42640

      \ \ \ 0.00000 \ \ 0.00000 \ \ 0.00000 \ \ 0.21320

      \ \ \ 1.00000 \ \ 1.00000 \ -1.00000 \ -0.85280

      \;

      v =

      \;

      \ \ 2 \ 0 \ 0 \ 0

      \ \ 0 \ 2 \ 0 \ 0

      \ \ 0 \ 0 \ 2 \ 0

      \ \ 0 \ 0 \ 0 \ 1

      \;

      \;
    </unfolded-io>

    <\unfolded-io|octave\<gtr\> >
      Q=[1 0 0 0;-2 2 1 0;1 1 0 0;-4 0 0 -1]
    <|unfolded-io>
      Q =

      \;

      \ \ \ 1 \ \ 0 \ \ 0 \ \ 0

      \ \ -2 \ \ 2 \ \ 1 \ \ 0

      \ \ \ 1 \ \ 1 \ \ 0 \ \ 0

      \ \ -4 \ \ 0 \ \ 0 \ -1

      \;

      \;
    </unfolded-io>

    <\unfolded-io|octave\<gtr\> >
      P=inv(Q)
    <|unfolded-io>
      P =

      \;

      \ \ \ 1 \ -0 \ \ 0 \ \ 0

      \ \ -1 \ \ 0 \ \ 1 \ \ 0

      \ \ \ 4 \ \ 1 \ -2 \ \ 0

      \ \ -4 \ \ 0 \ \ 0 \ -1

      \;

      \;
    </unfolded-io>

    <\unfolded-io|octave\<gtr\> >
      P*A*Q
    <|unfolded-io>
      ans =

      \;

      \ \ 1 \ 0 \ 0 \ 0

      \ \ 0 \ 2 \ 0 \ 0

      \ \ 0 \ 0 \ 2 \ 0

      \ \ 0 \ 0 \ 1 \ 2

      \;

      \;
    </unfolded-io>

    <\input|octave\<gtr\> >
      \;
    </input>
  </session>

  The second part shows the graph capacity of Octave, 2D and 3D graphs. 2D
  graphs can be automatically embedded into the worksheet but 3D graphs are
  not yet.

  <\session|octave|default>
    <\input|octave\<gtr\> >
      x=linspace(-10,10,1000);
    </input>

    <\input|octave\<gtr\> >
      y=x+sin(x);
    </input>

    <\unfolded-io|octave\<gtr\> >
      plot(x,y,";Function y=x+sin(x);");
    <|unfolded-io>
      \;

      \;

      <image|<tuple|<#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>|ps>||||>

      \;
    </unfolded-io>

    <\input|octave\<gtr\> >
      x0=[2;5;10];
    </input>

    <\input|octave\<gtr\> >
      t = linspace (0,10,800);
    </input>

    <\input|octave\<gtr\> >
      function dx = butter (x ,t) \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ dx(1)
      = -10.0*(x(1)-x(2)); \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ dx(2)
      = 28.0*x(1)-x(2)-x(1)*x(3); \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ dx(3)
      = 8.0/3.0*( x(1)*x(2) -x(3) ); \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ end;
    </input>

    <\input|octave\<gtr\> >
      y=lsode("butter",x0,t);
    </input>

    <\input|octave\<gtr\> >
      gset parametric;
    </input>

    <\input|octave\<gtr\> >
      gset set term postscript enhanced color eps;
    </input>

    <\input|octave\<gtr\> >
      gset xtics 10;gset ytics 10; gset ztics 10;
    </input>

    <\input|octave\<gtr\> >
      gset out "/tmp/butterfly.eps";
    </input>

    <\input|octave\<gtr\> >
      gsplot y title "Butterfly Effect"
    </input>

    <\input|octave\<gtr\> >
      \;
    </input>
  </session>

  In order to embed the 3D graph, we first save it as butterfly.eps in /tmp
  directory. Then we can embed this EPS file into the worksheet using
  <menu|Insert|Image>.

  <big-figure|<image|<tuple|<#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>|eps>||||>|Embedded
  3D graph from Octave.>

  <tmdoc-copyright|2003|Chu-Ching Huang|Joris van der Hoeven>

  <tmdoc-license|Permission is granted to copy, distribute and/or modify this
  document under the terms of the GNU Free Documentation License, Version 1.1
  or any later version published by the Free Software Foundation; with no
  Invariant Sections, with no Front-Cover Texts, and with no Back-Cover
  Texts. A copy of the license is included in the section entitled "GNU Free
  Documentation License".>
</body>

<\initial>
  <\collection>
    <associate|language|english>
  </collection>
</initial>