// mainfrm.cpp : implementation of the CMainFrame class
// Time-stamp: "97/01/12 14:05:01 mik"
//
// Copyright (C) 1996, 97
//	Christian Schenk  <cschenk@berlin.snafu.de>
//
// This file is part of MiKTeX.
//
// MiKTeX is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// MiKTeX is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with MiKTeX; if not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "stdafx.h"
#include "yap.h"
#include "DisplayPage.h"
#include "PrinterPage.h"
#include "dvidoc.h"

#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_COMMAND(ID_VIEW_OPTIONS, OnViewOptions)
	//}}AFX_MSG_MAP
	// Global help commands
	ON_COMMAND(ID_HELP_INDEX, CMDIFrameWnd::OnHelpIndex)
	ON_COMMAND(ID_HELP_USING, CMDIFrameWnd::OnHelpUsing)
	ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWnd::OnHelpIndex)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars
	
// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
	// same order as in the bitmap 'toolbar.bmp'
	ID_FILE_OPEN,
		ID_SEPARATOR,
	ID_FILE_PRINT,
	ID_APP_ABOUT,
	ID_CONTEXT_HELP,
};

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
	// TODO: add member initialization code here
	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_wndToolBar.Create(this) ||
		!m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
		!m_wndToolBar.SetButtons(buttons,
		  sizeof(buttons)/sizeof(UINT)))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	// TODO: Remove this if you don't want tool tips
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY);

	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

void CMainFrame::OnViewOptions() 
{
  CPropertySheet dlg ("Options", 0, 0);
  DisplayPage display_page;
  dlg.AddPage (&display_page);
  PrinterPage printer_page;
  dlg.AddPage (&printer_page);
  display_page.m_mode = CDviDoc::displaymode;
  display_page.m_resolution = CDviDoc::displayres;
  display_page.m_shrink_factor.Format ("%ld", (long) CDviDoc::displayshrinkfactor);
  printer_page.m_mode = CDviDoc::printermode;
  printer_page.m_resolution = CDviDoc::printerres;
  printer_page.m_xshift = CDviDoc::pagexshift;
  printer_page.m_yshift = CDviDoc::pageyshift;
  int nResponse = dlg.DoModal ();
  if (nResponse == IDOK)
    {
      BOOL newdisplaymode = FALSE;
      if (display_page.m_mode != CDviDoc::displaymode)
	{
	  newdisplaymode = TRUE;
	  CDviDoc::displaymode = display_page.m_mode;
	}
      if (display_page.m_resolution != CDviDoc::displayres)
	{
	  newdisplaymode = TRUE;
	  CDviDoc::displayres = display_page.m_resolution;
	}
      if (atoi (display_page.m_shrink_factor) != CDviDoc::displayshrinkfactor)
	{
	  newdisplaymode = TRUE;
	  CDviDoc::displayshrinkfactor = (long) atoi (display_page.m_shrink_factor);
	}
      if (printer_page.m_mode != "")
	CDviDoc::printermode = printer_page.m_mode;
      if (printer_page.m_resolution)
	CDviDoc::printerres = printer_page.m_resolution;
	CDviDoc::pagexshift = printer_page.m_xshift;
	CDviDoc::pageyshift = printer_page.m_yshift;
      if (newdisplaymode)
	{
	  CWinApp *app = AfxGetApp ();
	  POSITION doctemplpos = app->GetFirstDocTemplatePosition ();
	  while (doctemplpos)
	    {
	      CDocTemplate *doctmpl = app->GetNextDocTemplate (doctemplpos);
	      POSITION docpos = doctmpl->GetFirstDocPosition ();
	      while (docpos)
		{
		  CDocument *doc = doctmpl->GetNextDoc (docpos);
		  if (doc->IsKindOf (RUNTIME_CLASS (CDviDoc)))
		    {
		      CDviDoc *dvidoc = (CDviDoc *) doc;
		      dvidoc->newmode (dvidoc->displaymode, dvidoc->displayres);
		      dvidoc->UpdateAllViews (0);
		    }
		}
	    }
	}
    }
}
