/* tek4010emu.h - 20:07 GMT +10:00 Sat 12 Jun 1993 - modifier Geoffrey Tobin */
/* `Tektronix 4010' EMULATION. */

/* Include file ../include/tek4010vdu.h from vis630vdu.c */

#ifndef TEK4010EMU_H
#define TEK4010EMU_H

extern int maxy;
/* TEK4010 vertical coordinates are in 0..maxy;
                             some VDUs may change default value of 779     */
extern int lineht;
/* height in TEK4010 pixels of a text line;
                             some VDUs may change default value of 26      */
extern int dragdown;
/* VIS500/550 VDUs can use this value to drag
                             Terse character baseline down to TeX ref pt   */
extern boolean havesentxy;
    /* don't need to send all 4 bytes of address?    */


extern Void InitTEK4010emu (VOID);

extern Void SendXY __((int x, int y));

extern Void TEK4010StartText (VOID);

extern Void TEK4010MoveToTextLine __((int line));

extern Void TEK4010ClearScreen (VOID);

extern Void TEK4010StartGraphics (VOID);

extern Void TEK4010LoadFont __((Char *fontname, int fontsize, double mag,
			        double hscale, double vscale));

extern Void TEK4010ShowChar __((int screenh, int screenv, Char ch));

extern Void TEK4010ShowRectangle __((int screenh, int screenv,
                                     int width, int height, Char ch));

#endif /* TEK4010EMU_H */

/* end tek4010emu.h */
