rem Ghostscript: convert PS file to EPS file
@echo off
if "%1"=="" goto usage
if "%2"=="" goto usage
set infile=%1
set outfile=%2
rem Ghostscript uses %outfile% to define the output file
@echo off
if exist %EMTEXDIR%\utils\ghostscr\gs86.exe set GSEXE=gs86
if exist %EMTEXDIR%\utils\ghostscr\gs386.exe set GSEXE=gs386
if "GSEXE" == "" goto error
%EMTEXDIR%\utils\ghostscr\%GSEXE% -q -dNOPAUSE -dNODISPLAY ps2epsi.ps < %infile%
goto end
:error
echo No Ghostscript executable....
:end
rem We bracket the actual file with a few commands to help encapsulation
echo /InitDictCount countdictstack def gsave save mark newpath >> %outfile%
rem Append the original onto the preview header
copy %outfile% + %infile%
echo countdictstack InitDictCount sub { end } repeat >> %outfile%
echo cleartomark restore grestore >> %outfile%
goto end
:usage
echo "Usage: ps2epsi <infile.ps> <outfile.epi>"
:end
