UNIT tijd;

INTERFACE

USES Dos,Utils;

CONST lijn  : integer = 1;
      kolom : integer = 10;

VAR wk,wkt,wkta                      : Windowptr;
    hh,mi,se,sec                     : Word;
    Start_Tijd,Tussen_Tijd,Toon_Tijd : Real;
    OpenToonKlok,SchrijfKlok,SchTijd : Boolean;

PROCEDURE SchrijfOokTijd;

{$F+} PROCEDURE SchrijfTijd; {$F-}

PROCEDURE DatTijdLC(lijn,kolom : Integer);

PROCEDURE EindDatTijd;

PROCEDURE StartKlok;

PROCEDURE HaltKlok;

PROCEDURE HerStartKlok;

PROCEDURE StopKlok(Var KlokTijd : Real);

PROCEDURE SchrijfOokKlok;

{$F+} PROCEDURE ToonKlok; {$F-}

PROCEDURE ToonKlokLC(lijn,kolom : Integer);

PROCEDURE EindKlokTijd;

IMPLEMENTATION

PROCEDURE SchrijfOokTijd;

BEGIN WriteToWindow(wkt);
      GotoLC(1,1);
      Write(Copy(ThisDateTimeStr,1,8));
      GotoLC(1,9);
      Write(' ');
      GetTime(hh,mi,se,sec);
      IF hh < 10 THEN write('0',hh:1,':') ELSE write(hh:2,':');
      IF mi < 10 THEN write('0',mi:1,':') ELSE write(mi:2,':');
      IF se < 10 THEN write('0',se:1) ELSE write(se:2);
END;


{$F+} PROCEDURE SchrijfTijd; {$F-}

BEGIN If SchTijd then
      BEGIN
        wk := ActiveWindow;
        WriteToWindow(wkt);
        GotoLC(1,1);
        Write(Copy(ThisDateTimeStr,1,8));
        GotoLC(1,9);
        GetTime(hh,mi,se,sec);
        Write(' ');
        IF hh < 10 THEN write('0',hh:1,':') ELSE write(hh:2,':');
        IF mi < 10 THEN write('0',mi:1,':') ELSE write(mi:2,':');
        IF se < 10 THEN write('0',se:1) ELSE write(se:2);
        IF SchrijfKlok THEN SchrijfOokKlok;
        WriteToWindow(wk);
        IF activeWindow = nil THEN EindDatTijd;
      END;
END;

PROCEDURE DatTijdLC(lijn,kolom:integer);

BEGIN wk := ActiveWindow;
      wkt := NewWindow(' ',2,17,Datacolor);
      OpenWindow(wkt,lijn,kolom);
      SmallJobProcAddr := @SchrijfTijd;
      SchrijfTijd;
      SchTijd := True;
END;

PROCEDURE EindDatTijd;

BEGIN CloseWindow(wkt);
      DisposeWindow(wkt);
      SchTijd := False;
END;


PROCEDURE StartKlok;

BEGIN GetTime(hh,mi,se,sec);
      Start_Tijd := 3600*hh+60*Mi+Se+Sec/100;
      Tussen_Tijd := 0;
      SchrijfKlok := True;
END;

PROCEDURE HaltKlok;

BEGIN GetTime(hh,mi,se,sec);
      Tussen_Tijd := 3600*hh+60*Mi+Se+Sec/100;
      IF OpenToonKlok THEN
      BEGIN ToonKlok;
            SchrijfKlok := False;
      END;
END;

PROCEDURE HerStartKlok;

BEGIN GetTime(hh,mi,se,sec);
      Tussen_Tijd := 3600*hh+60*Mi+Se+Sec/100 - Tussen_Tijd;
      Start_Tijd := Start_Tijd + Tussen_Tijd;
      SchrijfKlok := True;
END;

PROCEDURE StopKlok(Var KlokTijd : Real);

BEGIN GetTime(hh,mi,se,sec);
      KlokTijd := 3600*hh+60*Mi+Se+Sec/100 - Start_Tijd;
      IF OpenToonKlok THEN EindKlokTijd;
END;

PROCEDURE SchrijfOokKlok;

BEGIN WriteToWindow(wkta);
      GotoLC(1,1);
      Toon_Tijd := 3600*hh+60*Mi+Se+Sec/100 - Start_Tijd;
      hh := Trunc(Toon_Tijd / 3600);
      mi := Trunc((Toon_Tijd - 3600 * hh)/60);
      se := Trunc(Toon_Tijd - 3600 * hh - 60 * mi);
      sec := Trunc((Toon_Tijd - 3600 * hh - 60 * mi - se)*100);
      IF hh < 10 THEN write('0',hh:1,':') ELSE write(hh:2,':');
      IF mi < 10 THEN write('0',mi:1,':') ELSE write(mi:2,':');
      IF se < 10 THEN write('0',se:1,'.') ELSE write(se:2,'.');
      IF Sec < 10 THEN write('0',sec:1) ELSE write(sec:2);
END;

{$F+} PROCEDURE ToonKlok; {$F-}

BEGIN IF SchrijfKlok THEN
      BEGIN wk := ActiveWindow;
            WriteToWindow(wkta);
            GotoLC(1,1);
            GetTime(hh,mi,se,sec);
            Toon_Tijd := 3600*hh+60*Mi+Se+Sec/100 - Start_Tijd;
            hh := Trunc(Toon_Tijd / 3600);
            mi := Trunc((Toon_Tijd - 3600 * hh)/60);
            se := Trunc(Toon_Tijd - 3600 * hh - 60 * mi);
            sec := Trunc((Toon_Tijd - 3600 * hh - 60 * mi - se)*100);
            IF hh < 10 THEN write('0',hh:1,':') ELSE write(hh:2,':');
            IF mi < 10 THEN write('0',mi:1,':') ELSE write(mi:2,':');
            IF se < 10 THEN write('0',se:1,'.') ELSE write(se:2,'.');
            IF Sec < 10 THEN write('0',sec:1) ELSE write(sec:2);
            IF SchTijd THEN SchrijfOokTijd;
            WriteToWindow(wk);
      END;
END;


PROCEDURE ToonKlokLC(lijn,kolom : Integer);

BEGIN OpenToonKlok := True;
      wk := ActiveWindow;
      wkta := NewWindow(' ',2,11,Datacolor);
      OpenWindow(wkta,lijn,kolom);
      IF NOT SchTijd THEN SmallJobProcAddr := @ToonKlok;
      ToonKlok;
END;

PROCEDURE EindKlokTijd;

BEGIN CloseWindow(wkta);
      DisposeWindow(wkta);
      SchrijfKlok := False;
      OpenToonKlok := False;
END;

BEGIN OpenToonKlok := False;
      SchrijfKlok  := False;
      SchTijd      := False;
END.