# Filter Mathematica psfix output to change fontsize and bounding box

# 2/1/1991 Dan Dill dan@chem.bu.edu
# Based on scheme developed by Cameron Smith cameron@midd.bitnet

# Adapted to Mathematica 2.0 from 1.2 version.
# fontsize now handled by Mathematica $DefaultFont

# awk -f addBBoxpro.awk height asprat
#	height		is in "big points", 72 bp = 1 in
#	asprat		is a decimal number

BEGIN { 
	height = ARGV[1]; ARGV[1] = ""		# Don't treat arg as input file
	aspratio = ARGV[2]; ARGV[2] = ""	# ..
	width = int(height / aspratio)
	print "!%"
}
/BoundingBox/ {$4 = width; $5 = height}
/^\/M[lrtb]marg/ {$2 = 0}
/^\/Mwidth/ {$2 = width; $3 = ""; $4 = ""}
/^\/Mheight/ {$2 = height; $3 = ""; $4 = ""}
{print}


