/*
 *	DVI command definitions:
 */

#define SET_CHAR_0   0	/* Typeset character 0 and move right */
#define SET1       128	/* Typeset a character and move right */
#define SET_RULE   132	/* Typeset a rule and move right */
#define PUT1       133	/* Typeset a character */
#define PUT_RULE   137	/* Typeset a rule */
#define NOP        138	/* No operation */
#define BOP        139	/* Beginning of page */
#define EOP        140	/* Ending of page */
#define PUSH       141	/* Save the current positions */
#define POP        142	/* Restore previous positions */
#define RIGHT1     143	/* Move right */
#define W0         147	/* Move right by w */
#define W1         148	/* Move right and set w */
#define X0         152	/* Move right by x */
#define X1         153	/* Move right and set x */
#define DOWN1      157	/* Move down */
#define Y0         161	/* Move down by y */
#define Y1         162	/* Move down and set y */
#define Z0         166	/* Move down by z */
#define Z1         167	/* Move down and set z */
#define FNT_NUM_0  171	/* Set current font to 0 */
#define FNT1       235	/* Set current font */
#define XXX1       239	/* Extension to DVI primitives */
#define XXX4       242	/* Potentially long extension to DVI primitives */
#define FNT_DEF1   243	/* Define the meaning of a font number */
#define PRE        247	/* Preamble */
#define POST       248	/* Postamble beginning */
#define POST_POST  249	/* Postamble ending */
#define BEGIN_REFLECT 250	/* Begin a (possibly recursive) reflected segment */
#define END_REFLECT   251	/* End a (possibly recursive) reflected segment */

#define SIGNATURE 223	/* Signature character at end of file */
#define DVI_FORMAT_B 2
