/*
  This is the file basic.c of the CJK macro package ver. 4.1.3
  (20-Jun-1997).
*/


#include <stdio.h>
#include <errno.h>
#include "ttf.h"

/*
  True Type Fonts use Motorola's byte ordering, i.e. the most significant
  byte comes first. Thus we must provide a set of functions to access all
  values in a platform-independent way.
*/


/*@@*/

BYTE get_BYTE(fp)
  FILE *fp;
{
  int cc;
  
  cc = fgetc(fp);
  if (cc == EOF && errno)
    ttf_error(ttf_err_read, errno);
  return (BYTE)cc;
}


USHORT get_USHORT(fp)
  FILE *fp;
{
  int cc1, cc2;
  
  cc1 = fgetc(fp);
  cc2 = fgetc(fp);
  if (cc2 == EOF && errno)
    ttf_error(ttf_err_read, errno);
  return (USHORT)(((cc1 << 8) & 0xFF00) | (cc2 & 0xFF));
}


SHORT get_SHORT(fp)
  FILE *fp;
{
  int cc1, cc2;
  
  cc1 = fgetc(fp);
  cc2 = fgetc(fp);
  if (cc2 == EOF && errno)
    ttf_error(ttf_err_read, errno);
  return (SHORT)(((cc1 << 8) & 0xFF00) | (cc2 & 0xFF));
}


ULONG get_ULONG(fp)
  FILE *fp;
{
  int cc1, cc2, cc3, cc4;
  
  cc1 = fgetc(fp);
  cc2 = fgetc(fp);
  cc3 = fgetc(fp);
  cc4 = fgetc(fp);
  if (cc4 == EOF && errno)
    ttf_error(ttf_err_read, errno);
  return (ULONG)(((cc1 << 24) & 0xFF000000) | ((cc2 << 16) & 0xFF0000) |
                 ((cc3 << 8) & 0xFF00) | (cc4 & 0xFF));
}


Fixed get_Fixed(fp)
  FILE *fp;
{
  return (Fixed)get_ULONG(fp);
}


FWord get_FWord(fp)
  FILE *fp;
{
  return (FWord)get_USHORT(fp);
}


uFWord get_uFWord(fp)
  FILE *fp;
{
  return (uFWord)get_USHORT(fp);
}


/* we scale by 2^14 */
SHORT get_F2Dot14(fp)
  FILE *fp;
{
  return get_SHORT(fp) << 14;
}


/*@*/

#if 0
CHAR get_CHAR(fp)
  FILE *fp;
{
  int cc;
  
  cc = fgetc(fp);
  if (cc == EOF && errno)
    ttf_error(ttf_err_read, errno);
  return (CHAR)cc;
}


LONG get_LONG(fp)
  FILE *fp;
{
  int cc1, cc2, cc3, cc4;
  
  cc1 = fgetc(fp);
  cc2 = fgetc(fp);
  cc3 = fgetc(fp);
  cc4 = fgetc(fp);

  if (cc4 == EOF && errno)
    ttf_error(ttf_err_read, errno);
  return (LONG)(((cc1 << 24) & 0xFF000000) | ((cc2 << 16) & 0xFF0000) |
                ((cc3 << 8) & 0xFF00) | (cc4 & 0xFF));
}


FUnit get_FUnit(fp)
  FILE *fp;
{
  return (FUnit)get_USHORT(fp);
}
#endif /* 0 */


/* end of basic.c */
