---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, styles,
              mode mathématique, mode mathématique hors texte, 
              équation hors texte, mathématiques dans un paragraphe, 
              mathématiques et lignes, limites d'intégrales, grands opérateurs,
              mode en-ligne, mode hors-texte, \mathchoice
---

# Quels sont les huit styles mathématiques ?

## Définition

TeX et LaTeX possède fondamentalement quatre styles mathématiques, nommés :

- `\displaystyle` ;
- `\textstyle` ;
- `\scriptstyle` ;
- et `\scriptscriptstyle`,

chacun décliné en deux versions : normale et tassée. 
Il ne faut pas confondre les styles avec les modes (en-ligne ou hors-texte) 
même si ceux-ci sont reliés : le style par défaut du mode hors-texte 
correspond à `\displaystyle`, celui du mode en-ligne à `\textstyle`.

Ces styles déterminent de nombreux éléments de composition mathématiques, 
comme la taille des symboles, leur espacement, et la place des indices 
et exposants. Vous pouvez à tout moment changer de style avec les commandes
ci-dessus, qui agissent jusqu'à la fin du groupe 
ou jusqu'au prochain changement de style.

Le contrôle du placement des "limites" se fait indépendamment avec `\limits` 
et `\nolimits`. Comparons ainsi plusieurs formes d'écriture d'une sommation :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{graphicx}       % Définit la commande \resizebox

\begin{document}
\resizebox{6cm}{!}{
  $\sum_a^b$
  \begin{minipage}[b]{2.5ex}\[\sum_a^b\]\end{minipage}
  $\displaystyle \sum_a^b$
  $\displaystyle \sum\nolimits_a^b$
  $\sum\limits_a^b$
}
\end{document}
```

Pour accéder manuellement à la variante tassée, vous pouvez utiliser 
la commande `\cramped` de <ctanpkg:mathtools>, qui compose son argument 
en style tassé : cela change principalement la hauteur des indices 
et exposants. Il peut être utile de les compresser, par exemple 
pour préserver l'interlignage dans un paragraphe. L'effet est assez subtil,
mais un peu plus évident en comparant les deux membres de l'égalité 
dans l'exemple suivant.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\Huge  $2^{2^2} = \cramped{2^{2^2}}$
\end{document}
```


## Création d'une commande mathématique adaptée au style

Lors de la définition d'une commande mathématique, vous pouvez prévoir 
des variantes selon de style mathématique courant avec la commande 
`\mathchoice`, qui prend quatre arguments, chacun correspondant 
à ce que la fonction restitue pour chacun des styles mathématiques 
(respectivement `displaystyle`, `textstyle`, `scriptstyle` 
et `scriptscriptstyle`).

```{noedit}
\mathchoice{⟨display⟩}{⟨text⟩}{⟨script⟩}{⟨scriptscript⟩}
```

Voici un exemple dans lequel nous définissons une commande `\undemi`
pour afficher cette valeur "un demi" de différentes manières.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \newcommand\undemi{\mathchoice{\frac{1}{2}}{1 \div 2}{1/2}{0.5}}

\begin{document}
Notre fonction se comporte bien différemment selon qu'elle est utilisée 
en mode en-ligne ($\undemi$) ou en mode hors texte (avec les 
variantes selon le niveau de mise en mise en indice/exposant):
\[ \left( \undemi \right)^{(\undemi)^{\undemi}}\]
\end{document}
```


:::{sources}
- [Les huit styles mathématiques](https://www.elzevir.fr/imj/latex/tips.html#mathstyles), 
  par Manuel Pégourié-Gonnard
:::