// Python interface to TeXpk
// $Id: pkpy.cc,v 1.2 2000/11/21 22:38:43 yotam Exp $

#include <Python.h>
#include "Rect.h"
#include "TeXpk.h"
#include "pygoods.h"
#include "debug.h"


////////////////////////////////////////////////////////////////////////
static void  sDeletePK(void* pv)
{  DHERE;
   TeXpk*  pPK = static_cast<TeXpk*>(pv);
   delete pPK;
} // sDeletePK

////////////////////////////////////////////////////////////////////////
static PyObject*  pkOpen(PyObject* self, PyObject* args)
{  DHERE;
   PyObject* ret;
   char*  fn;
   if (rPyArgParse(ret, args, "s", &fn))
   {  DPR("fn=" << fn);
      TeXpk*  pTeXpk = new TeXpk(fn);  DHERE;
      ret = PyCObject_FromVoidPtr(pTeXpk, sDeletePK);
   }
   return ret;
} // pkOpen


////////////////////////////////////////////////////////////////////////
static PyObject*  pkOK(PyObject* self, PyObject* args)
{  DHERE;
   PyObject* ret;
   PyObject* obj;
   if (rPyArgParse(ret, args, "O", &obj))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      bool     active = pTeXpk->active();
      ret = PyInt_FromLong((int)active);
   }
   return ret;
} // pkOK


////////////////////////////////////////////////////////////////////////
static PyObject*  pkId(PyObject* self, PyObject* args)
{  DHERE;
   PyObject* ret;
   PyObject* obj;
   if (rPyArgParse(ret, args, "O", &obj))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US8     id = pTeXpk->id();
      ret = PyInt_FromLong((int)id);
   }
   return ret;
} // pkId


////////////////////////////////////////////////////////////////////////
static PyObject*  pkComment(PyObject* self, PyObject* args)
{  DHERE;
   PyObject* ret;
   PyObject* obj;
   if (rPyArgParse(ret, args, "O", &obj))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      const char* comment = pTeXpk->comment().c_str();
      ret = PyString_FromString(comment);
   }
   return ret;
} // pkComment


////////////////////////////////////////////////////////////////////////
static PyObject*  pkDesignSize(PyObject* self, PyObject* args)
{
   PyObject* ret;
   PyObject* obj;
   if (rPyArgParse(ret, args, "O", &obj))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US32    designSize = pTeXpk->designSize();
      ret = PyInt_FromLong(designSize);
   }
   return ret;
} // pkDesignSize


////////////////////////////////////////////////////////////////////////
static PyObject*  pkCheckSum(PyObject* self, PyObject* args)
{  DHERE;
   PyObject* ret;
   PyObject* obj;
   if (rPyArgParse(ret, args, "O", &obj))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US32    checkSum = pTeXpk->checkSum();
      ret = PyInt_FromLong(checkSum);
   }
   return ret;
} // pkCheckSum


////////////////////////////////////////////////////////////////////////
static PyObject*  pkHppp(PyObject* self, PyObject* args)
{  DHERE;
   PyObject* ret;
   PyObject* obj;
   if (rPyArgParse(ret, args, "O", &obj))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US32    hppp = pTeXpk->hppp();
      ret = PyInt_FromLong(hppp);
   }
   return ret;
} // pkHppp


////////////////////////////////////////////////////////////////////////
static PyObject*  pkVppp(PyObject* self, PyObject* args)
{  DHERE;
   PyObject* ret;
   PyObject* obj;
   if (rPyArgParse(ret, args, "O", &obj))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US32    vppp = pTeXpk->vppp();
      ret = PyInt_FromLong(vppp);
   }
   return ret;
} // pkVppp


////////////////////////////////////////////////////////////////////////
static PyObject*  pkNChars(PyObject* self, PyObject* args)
{  DHERE;
   PyObject* ret;
   PyObject* obj;
   if (rPyArgParse(ret, args, "O", &obj))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US16    nChars = pTeXpk->nChars();
      ret = PyInt_FromLong(nChars);
   }
   return ret;
} // pkNChars


////////////////////////////////////////////////////////////////////////
static PyObject*  pkHasChar(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* ret;
   PyObject* obj;
   int       ci;
   if (rPyArgParse(ret, args, "Oi", &obj, &ci))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US8     c8 = ci;
      bool    hasChar = pTeXpk->hasChar(c8);  
              DPR0("c8=" << (int)c8 << ", has=" << (int)hasChar);
      ret = PyInt_FromLong((int)hasChar);
   }
   return ret;
} // pkHasChar


////////////////////////////////////////////////////////////////////////
static PyObject*  pkTfmWidth(PyObject* self, PyObject* args)
{  DHERE;
   PyObject* ret;
   PyObject* obj;
   int       ci;
   if (rPyArgParse(ret, args, "Oi", &obj, &ci))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US8     c8 = ci;
      ret = PyInt_FromLong(pTeXpk->tfmWidth(c8));
   }
   return ret;
} // pkTfmWidth


////////////////////////////////////////////////////////////////////////
static PyObject*  pkDX(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* ret;
   PyObject* obj;
   int       ci;
   if (rPyArgParse(ret, args, "Oi", &obj, &ci))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US8     c8 = ci;
      ret = PyInt_FromLong(pTeXpk->dx(c8));
   }
   return ret;
} // pkDX


////////////////////////////////////////////////////////////////////////
static PyObject*  pkDY(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* ret;
   PyObject* obj;
   int       ci;
   if (rPyArgParse(ret, args, "Oi", &obj, &ci))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US8     c8 = ci;
      ret = PyInt_FromLong(pTeXpk->dy(c8));
   }
   return ret;
} // pkDY


////////////////////////////////////////////////////////////////////////
static PyObject*  pkBitmapWidth(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* ret;
   PyObject* obj;
   int       ci;
   if (rPyArgParse(ret, args, "Oi", &obj, &ci))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US8     c8 = ci;
      ret = PyInt_FromLong(pTeXpk->bitmapWidth(c8));
   }
   return ret;
} // pkBitmapWidth


////////////////////////////////////////////////////////////////////////
static PyObject*  pkBitmapHeight(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* ret;
   PyObject* obj;
   int       ci;
   if (rPyArgParse(ret, args, "Oi", &obj, &ci))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US8     c8 = ci;
      ret = PyInt_FromLong(pTeXpk->bitmapHeight(c8));
   }
   return ret;
} // pkBitmapHeight


////////////////////////////////////////////////////////////////////////
static PyObject*  pkHoff(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* ret;
   PyObject* obj;
   int       ci;
   if (rPyArgParse(ret, args, "Oi", &obj, &ci))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US8     c8 = ci;
      ret = PyInt_FromLong(pTeXpk->hoff(c8));
   }
   return ret;
} // pkHoff


////////////////////////////////////////////////////////////////////////
static PyObject*  pkVoff(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* ret;
   PyObject* obj;
   int       ci;
   if (rPyArgParse(ret, args, "Oi", &obj, &ci))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US8     c8 = ci;
      ret = PyInt_FromLong(pTeXpk->voff(c8));
   }
   return ret;
} // pkVoff


////////////////////////////////////////////////////////////////////////
static PyObject*  pkNRects(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* ret;
   PyObject* obj;
   int       ci;
   if (rPyArgParse(ret, args, "Oi", &obj, &ci))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US8     c8 = ci;
      ret = PyInt_FromLong(pTeXpk->nRects(c8));
   }
   return ret;
} // pkNRects


////////////////////////////////////////////////////////////////////////
static PyObject*  pkRect(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* tuple;
   PyObject* obj;
   int       ci;
   int       rectInd;
   if (rPyArgParse(tuple, args, "Oii", &obj, &ci, &rectInd))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US8     c8 = ci;
      Rect    rect;
      pTeXpk->rect(rect, c8, rectInd);
      tuple = PyTuple_New(4);
      PyTuple_SetItem(tuple, 0, PyInt_FromLong(rect.x));
      PyTuple_SetItem(tuple, 1, PyInt_FromLong(rect.y));
      PyTuple_SetItem(tuple, 2, PyInt_FromLong(rect.w));
      PyTuple_SetItem(tuple, 3, PyInt_FromLong(rect.h));
   }
   return tuple;
} // pkRect


////////////////////////////////////////////////////////////////////////
static PyObject*  pkCharFirst(PyObject* self, PyObject* args)
{  DHERE;
   PyObject* ret;
   PyObject* obj;
   if (rPyArgParse(ret, args, "O", &obj))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US8     c = pTeXpk->charFirst();
      ret = PyInt_FromLong(c);
   }
   return ret;
} // pkCharFirst


////////////////////////////////////////////////////////////////////////
static PyObject*  pkCharLast(PyObject* self, PyObject* args)
{  DHERE;
   PyObject* ret;
   PyObject* obj;
   if (rPyArgParse(ret, args, "O", &obj))
   {
      TeXpk*  pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      US8     c = pTeXpk->charLast();
      ret = PyInt_FromLong(c);
   }
   return ret;
} // pkCharLast


////////////////////////////////////////////////////////////////////////
static PyObject*  pkMaxOffset(PyObject* self, PyObject* args)
{  DHERE;
   PyObject* ret;
   PyObject* obj;
   int       idir;
   if (rPyArgParse(ret, args, "Oi", &obj, &idir))
   {
      TeXpk*            pTeXpk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(obj));
      TeXpk::Direction  dir = (TeXpk::Direction)idir;
      US32              mo = pTeXpk->maxOffset(dir);
      ret = PyInt_FromLong(mo);
   }
   return ret;
} // pkMaxOffset


////////////////////////////////////////////////////////////////////////
static PyMethodDef
pk_methods[] =
{
   {"open",          (PyCFunction)&pkOpen,         METH_VARARGS},
   {"ok",            (PyCFunction)&pkOK,           METH_VARARGS},
   {"id",            (PyCFunction)&pkId,           METH_VARARGS},
   {"comment",       (PyCFunction)&pkComment,      METH_VARARGS},
   {"designsize",    (PyCFunction)&pkDesignSize,   METH_VARARGS},
   {"checksum",      (PyCFunction)&pkCheckSum,     METH_VARARGS},
   {"hppp",          (PyCFunction)&pkHppp,         METH_VARARGS},
   {"vppp",          (PyCFunction)&pkVppp,         METH_VARARGS},
   {"nchars",        (PyCFunction)&pkNChars,       METH_VARARGS},
   {"haschar",       (PyCFunction)&pkHasChar,      METH_VARARGS},
   {"tfmwidth",      (PyCFunction)&pkTfmWidth,     METH_VARARGS},
   {"dx",            (PyCFunction)&pkDX,           METH_VARARGS},
   {"dy",            (PyCFunction)&pkDY,           METH_VARARGS},
   {"bitmapwidth",   (PyCFunction)&pkBitmapWidth,  METH_VARARGS},
   {"bitmapheight",  (PyCFunction)&pkBitmapHeight, METH_VARARGS},
   {"hoff",          (PyCFunction)&pkHoff,         METH_VARARGS},
   {"voff",          (PyCFunction)&pkVoff,         METH_VARARGS},
   {"nrects",        (PyCFunction)&pkNRects,       METH_VARARGS},
   {"rect",          (PyCFunction)&pkRect,         METH_VARARGS},
   {"charfirst",     (PyCFunction)&pkCharFirst,    METH_VARARGS},
   {"charlast",      (PyCFunction)&pkCharLast,     METH_VARARGS},
   {"maxoffset",     (PyCFunction)&pkMaxOffset,    METH_VARARGS},
   {0, 0, 0}
};


////////////////////////////////////////////////////////////////////////
PyMethodDef* pkMethods()
{
   return pk_methods;
} // pkMethods

////////////////////////////////////////////////////////////////////////
extern "C" void init_pk()
{
   DHERE;
   Py_InitModule("_pk", pk_methods);
   DHERE;
} // init_pk
