// Drawing PK bitmaps onto Gnome Canvas.
// This module is implemented as Python extension.
// $Id: pkcanvpy.cc,v 1.5 2000/12/09 14:29:23 yotam Exp $
//

#include <algorithm>
#include <vector>
#include <Python.h>

#include <gtk/gtk.h>
// #               include <gtk/gtkstyle.h>
#   include <gdk/gdk.h> // gdk_flush()
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk-pixbuf/gnome-canvas-pixbuf.h>
#include <libgnomeui/gnome-canvas.h>
#include <pygtk/pygtk.h>

#include "TeXpk.h"
#include "Rect.h"
#include "pygoods.h"
#include "debug.h"


typedef guchar*  gucharP;


////////////////////////////////////////////////////////////////////////
static void initGdk()
{ DHERE0;
   static bool  virgin = true;
   if (virgin)
   {  DHERE;
      virgin = false;
      int     dumArgc = 1;
      char**  dumArgs = new char*[2];
      dumArgs[0] = "tfmpk";
      dumArgs[1] = 0;
      gdk_init(&dumArgc, &dumArgs);
      delete [] dumArgs;
      gdk_rgb_init();
   }
} // initGdk


////////////////////////////////////////////////////////////////////////
static void fill(GdkPixbuf* pixbuf, guchar red, guchar green, guchar blue)
{
   unsigned       width  = gdk_pixbuf_get_width(pixbuf);
   unsigned       height = gdk_pixbuf_get_height(pixbuf);
   unsigned       stride = gdk_pixbuf_get_rowstride(pixbuf);
   guchar* const  pixels = gdk_pixbuf_get_pixels(pixbuf);
   // initialize with background
   gucharP       row = pixels, rowC, rowEnd;
   for (US32  r = 0;  r != height;  ++r, row += stride)
   {
      rowC = row, rowEnd = row + 3*width;
      while (rowC != rowEnd)
      {
         *rowC++ = red;
         *rowC++ = green;
         *rowC++ = blue;
      }
   }
} // fill


////////////////////////////////////////////////////////////////////////
// Assume bmh=10, rect.y=3, rect.h=2, rect.h growing up. WRONG!
// Rows indices are [0..9] growing down.
// y=3, is on the 10-3-1 = 6 row index.
// top row of rect.y+(rect.h-1) = 3+2-1 = 4,
// gets the 10-4-1=5 row index.
// unsigned topRowIndex = // bmh - (rect.y + rect.h - 1) - 1;
//                          bmh - (rect.y + rect.h);
//
// Assume bmh=10, rect.y=3, rect.h=2, rect.h growing down.
// Rows indices are [0..9] growing down.
// y=3, is on the 10-3-1 = 6 row index.
// top row of rect.y+(rect.h-1) = 3+2-1 = 4,
// gets the 10-4-1=5 row index.
static void  blackenCharFace
(
   GdkPixbuf*    pixbuf,
   const TeXpk&  pk,
   unsigned      c,
   unsigned      mag,
   guchar        red,
   guchar        green,
   guchar        blue,
   unsigned      xoffset = 0,
   unsigned      yoffset = 0
)
{
   DPR0("xoffset="<<xoffset<< ", yoffset="<<yoffset);
   unsigned       stride = gdk_pixbuf_get_rowstride(pixbuf);
   guchar* const  pixels = gdk_pixbuf_get_pixels(pixbuf);

   // blacken the rectangles that make up the character face
   unsigned  magStride = mag * stride;
   unsigned  mag3      = 3 * mag;
   for (unsigned ri = 0, nr = pk.nRects(c);  ri != nr;  ++ri)
   {
      Rect  rect;
      pk.rect(rect, c, ri);
      unsigned topRowIndex = rect.y;
      DPR0("ri="<<ri<<", R=("<<rect.x<<","<<rect.y<<")+"<<rect.w<<"x"<<rect.h);
      DASSERT((int)(rect.x + xoffset + rect.w) <= gdk_pixbuf_get_width(pixbuf));
      DASSERT((int)(topRowIndex + yoffset + rect.h) <=
                    gdk_pixbuf_get_height(pixbuf));
      for (gucharP  row = pixels + stride * (mag * topRowIndex + yoffset),
                    rowEnd = row + magStride * rect.h;
           row != rowEnd;  row += stride)
      {
         gucharP  c = row + 3*(mag*rect.x + xoffset), cEnd = c + mag3*rect.w;
         while (c != cEnd)
         {
            *c++ = red;
            *c++ = green;
            *c++ = blue;
         }
      }
   }
} // blackenCharFace


class PixBufs
{
 public:
   PixBufs(const TeXpk& pk);
   ~PixBufs();
   GdkPixbuf*    buff(US8 c) const {return _v[c - _bc];}
   static void   sDelete(void* p) {
                    PixBufs* ppb = static_cast<PixBufs*>(p);
                    delete ppb;
                 }
 private:
   GdkPixbuf*          createPixBuf(const TeXpk& pk, US8 c) const;
   US8                 _bc;
   vector<GdkPixbuf*>  _v;
}; // PixBufs


////////////////////////////////////////////////////////////////////////
PixBufs::PixBufs(const TeXpk& pk) :
   _bc(pk.charFirst()),
   _v((unsigned)(pk.charLast() - _bc + 1), (GdkPixbuf*)0)
{ DHERE;
   US8  c = _bc;
   for (vector<GdkPixbuf*>::iterator  i = _v.begin(), e = _v.end();
        i != e;  ++i, ++c)
   {
      if (pk.hasChar(c))
      { DPR("c="<<(int)c);
         *i = createPixBuf(pk, c);
      }
   }
   DHERE;
} // PixBufs::PixBufs


////////////////////////////////////////////////////////////////////////
PixBufs::~PixBufs()
{ DHERE;
   for (vector<GdkPixbuf*>::iterator  i = _v.begin(), e = _v.end();
        i != e;  ++i)
   {
      GdkPixbuf*  pixbuf = *i;
      if (pixbuf)
      {
         gdk_pixbuf_unref(pixbuf);
      }
   }
} // PixBufs::~PixBufs


////////////////////////////////////////////////////////////////////////
GdkPixbuf*  PixBufs::createPixBuf(const TeXpk& pk, US8 c) const
{
   US32          bmw = pk.bitmapWidth(c);
   US32          bmh = pk.bitmapHeight(c);
                 DPR("c="<<(int)c << ", bmw="<<bmw << ", bmh="<<bmh);
                 //  Will NEED to free it!
   GdkPixbuf*    pixbuf = 0;
   if (bmw && bmh)
   {
      pixbuf = gdk_pixbuf_new(GDK_COLORSPACE_RGB, 0, 8, bmw, bmh);
      fill(pixbuf, 0xff, 0xff, 0xff);  // initialize with white
      blackenCharFace(pixbuf, pk, c, 1, 0, 0, 0);
   }
   return pixbuf;
} // PixBufs::createPixBuf


#if 0
////////////////////////////////////////////////////////////////////////
static void  showColor(ostream& os, const GdkColor& c)
{
   os << "  r=" << c.red << ", g=" << c.green << ", b=" << c.blue << endl;
} // showColor
#endif

////////////////////////////////////////////////////////////////////////
// May need to change with future PyGtk/PyGnome versions.
// (Currently: pygnome-1.0.53)
static GtkWidget*  pyObj2widget(PyObject* pyObj)
{
   PyObject*      oObj = PyObject_GetAttrString(pyObj, "_o");
   PyGtk_Object*  pygObj = (PyGtk_Object*)oObj;
   GtkObject*     go = pygObj->obj;
   GtkWidget*     gw = (GtkWidget*)go;
#if 0
       GtkStyle*  style = gtk_widget_get_style(gw);
       // for (int i =0;  i != 5;  ++i)
       int  i = GTK_STATE_NORMAL;
       {
          cout << "i=" << i << endl;
          showColor(cout << "  fg: ",    style->fg[i]);
          showColor(cout << "  bg: ",    style->bg[i]);
          showColor(cout << "  light: ", style->light[i]);
          showColor(cout << "  dark: ",  style->dark[i]);
          showColor(cout << "  mid: ",   style->mid[i]);
          showColor(cout << "  text: ",  style->text[i]);
          showColor(cout << "  base: ",  style->base[i]);
       }
#endif
   return gw;
} // pyObj2widget


static GnomeCanvas*  pyObj2canvas(PyObject* pyObj)
{
   GtkWidget*     gw = pyObj2widget(pyObj);
   GnomeCanvas*   canvas = GNOME_CANVAS(gw);
   return canvas;
} // pyObj2canvas


////////////////////////////////////////////////////////////////////////
static GnomeCanvasGroup*  pyObj2canvasRoot(PyObject* pyObj)
{
   GnomeCanvasGroup*  canvasRoot = gnome_canvas_root(pyObj2canvas(pyObj));
   return canvasRoot;
} // pyObj2canvasRoot


////////////////////////////////////////////////////////////////////////
static PyObject*  initGDK4py(PyObject*, PyObject*)
{
   initGdk();
   Py_INCREF(Py_None);
   return Py_None;
} // initGDK4py

////////////////////////////////////////////////////////////////////////
static PyObject*  itemOp(PyObject* self, PyObject* args)
{
   PyObject*  itemObj;
   int        op;
   if (PyArg_ParseTuple(args, "Oi", &itemObj, &op))
   {  DPR0("op=" << op);
      void*             vitem = PyCObject_AsVoidPtr(itemObj);
      GnomeCanvasItem*  item = static_cast<GnomeCanvasItem*>(vitem);
      switch (op)
      {
       case -1:
         gtk_object_destroy(GTK_OBJECT(item));
         break;
       case 0:
         gnome_canvas_item_hide(item);
         break;
       case 1:
         gnome_canvas_item_show(item);
         break;
      }
   }
   Py_INCREF(Py_None);
   return Py_None;
} // itemOp


////////////////////////////////////////////////////////////////////////
static PyObject*  createPixbufs(PyObject* self, PyObject* args)
{ DHERE;
   PyObject*  pyPixbufs;
   PyObject*  pkObj;
   if (rPyArgParse(pyPixbufs, args, "O", &pkObj))
   { DHERE;
      TeXpk*    pk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(pkObj));
      PixBufs*  pixBufs = new PixBufs(*pk);
      pyPixbufs = PyCObject_FromVoidPtr(pixBufs, &PixBufs::sDelete);
   }
   return pyPixbufs;
} // createPixbufs


////////////////////////////////////////////////////////////////////////
static PyObject*  drawChar(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* pyItem;
   PyObject* canvObj;
   PyObject* pbObj;
   int       c, canvx, canvy;
   if (rPyArgParse(pyItem, args, "OOiii", &canvObj, &pbObj, &c, &canvx, &canvy))
   {
      const PixBufs*    pb = static_cast<PixBufs*>(PyCObject_AsVoidPtr(pbObj));
      GdkPixbuf*        pixbuf = pb->buff(c);
      if (pixbuf)
      {
         GnomeCanvasGroup*     canvasRoot = pyObj2canvasRoot(canvObj);
         static const GtkType  pixbufType = gnome_canvas_pixbuf_get_type();
         gdouble  dx = canvx,  dy = canvy;
         DPR0("pbt=" << pixbufType << ", dx=" << dx << ", dy=" << dy);
              gdk_flush();
         GnomeCanvasItem* item = gnome_canvas_item_new(canvasRoot, pixbufType,
                                                       "pixbuf", pixbuf,
                                                       "x", dx, "y", dy,
                                                       (void*)0);
              // gdk_flush(); DHERE;
         pyItem = PyCObject_FromVoidPtr(item, 0);
      }
      else
      {
         Py_INCREF(Py_None);
         pyItem = Py_None;
      }
   }
   return pyItem;
} // drawChar


////////////////////////////////////////////////////////////////////////
static PyObject*  drawFitChar(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* pyItem;
   PyObject* canvObj;
   PyObject* pbObj;
   int       c, canvx, canvy, wfit, hfit;
   if (rPyArgParse(pyItem, args, "OOiiiii", &canvObj, &pbObj,
                                          &c, &canvx, &canvy, &wfit, &hfit))
   {
      const PixBufs*  pb = static_cast<PixBufs*>(PyCObject_AsVoidPtr(pbObj));
      GdkPixbuf*      pixbufNatural = pb->buff(c);
      if (pixbufNatural)
      {
         GdkPixbuf*      pixbufFit = gdk_pixbuf_scale_simple(
                                        pixbufNatural, wfit, hfit,
                                        GDK_INTERP_TILES);
         GnomeCanvasGroup*     canvasRoot = pyObj2canvasRoot(canvObj);
         static const GtkType  pixbufType = gnome_canvas_pixbuf_get_type();
         gdouble  dx = canvx,  dy = canvy;
         GnomeCanvasItem* item = gnome_canvas_item_new(canvasRoot, pixbufType,
                                                       "pixbuf", pixbufFit,
                                                       "x", dx, "y", dy,
                                                       (void*)0);
         gdk_pixbuf_unref(pixbufFit);
         pyItem = PyCObject_FromVoidPtr(item, 0);
      }
      else
      {
         Py_INCREF(Py_None);
         pyItem = Py_None;
      }
   }
   return pyItem;
} // drawFitChar


////////////////////////////////////////////////////////////////////////
// similar to  PixBufs::createPixBuf  above
static PyObject*  drawMagChar(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* pyItem;
   PyObject* canvObj;
   PyObject* pkObj;
   int       c, mag, canvx, canvy;
   if (rPyArgParse(pyItem, args, "OOiiii", &canvObj, &pkObj,
                                          &c, &mag, &canvx, &canvy))
   {
      const TeXpk*       pk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(pkObj));
      GtkWidget*         gw = pyObj2widget(canvObj);
      GnomeCanvasGroup*  canvasRoot = gnome_canvas_root(GNOME_CANVAS(gw));
      GtkStyle*          style = gtk_widget_get_style(gw);
      const GdkColor&    bgColor = style->bg[GTK_STATE_NORMAL];
      US32               bmw = pk->bitmapWidth(c),  bmwMag = mag * bmw;
      US32               bmh = pk->bitmapHeight(c), bmhMag = mag * bmh;
                         DPR("bmw=" << bmw << ", bmh=" << bmh);
      GdkPixbuf*         pixbuf = 0;
      if (bmh && bmw)
      {
         pixbuf = gdk_pixbuf_new(GDK_COLORSPACE_RGB, 0, 8, bmwMag, bmhMag);
         // initialize with background
         fill(pixbuf, bgColor.red, bgColor.green, bgColor.blue);

         // blacken the rectangles that make up the character face
         blackenCharFace(pixbuf, *pk, c, mag, 0, 0, 0);

         static const GtkType  pixbufType = gnome_canvas_pixbuf_get_type();
         gdouble  dx = canvx,  dy = canvy;
         GnomeCanvasItem* item = gnome_canvas_item_new(canvasRoot, pixbufType,
                                                       "pixbuf", pixbuf,
                                                       "x", dx, "y", dy,
                                                       (void*)0);
         gdk_pixbuf_unref(pixbuf);
         pyItem = PyCObject_FromVoidPtr(item, 0);
      }
      else
      {
         Py_INCREF(Py_None);
         pyItem = Py_None;
      }
   }
   return pyItem;
} // drawMagChar


////////////////////////////////////////////////////////////////////////
static PyObject*  drawMagPair(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* pyItem;
   PyObject* canvObj;
   PyObject* pkObj;
   int       mag, bitmapWidth, bitmapHeight, canvx, canvy;
   int       c1, xoffset1, yoffset1;
   int       c2, xoffset2, yoffset2;// 123456789 1
   if (rPyArgParse(pyItem, args,    "OOiiiiiiiiiii",
                                    &canvObj, &pkObj,
                                    &mag, &bitmapWidth, &bitmapHeight,
                                    &c1, &xoffset1, &yoffset1,
                                    &c2, &xoffset2, &yoffset2,
                                    &canvx, &canvy))
   {
      DPR("mag="<<mag << ", c1="<<c1 << ", c2="<<c2 <<
          ", bmw="<<bitmapWidth << ", bmh="<<bitmapHeight);
      DPR("xoff1=" << xoffset1 << ", yoff1=" << yoffset1 <<
          ", xoff2=" << xoffset2 << ", yoff2=" << yoffset2);
      const TeXpk*       pk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(pkObj));
      GtkWidget*         gw = pyObj2widget(canvObj);
      GnomeCanvasGroup*  canvasRoot = gnome_canvas_root(GNOME_CANVAS(gw));
      GtkStyle*          style = gtk_widget_get_style(gw);
      const GdkColor&    bgColor = style->bg[GTK_STATE_NORMAL];
      GdkPixbuf*         pixbuf = gdk_pixbuf_new(GDK_COLORSPACE_RGB, 0, 8,
                                                 bitmapWidth, bitmapHeight);
      // initialize with background
      fill(pixbuf, bgColor.red, bgColor.green, bgColor.blue);

      // blacken the rectangles that make up the character face
      blackenCharFace(pixbuf, *pk, c1, mag, 0, 0, 0, xoffset1, yoffset1);
      blackenCharFace(pixbuf, *pk, c2, mag, 0, 0, 0, xoffset2, yoffset2);

      static const GtkType  pixbufType = gnome_canvas_pixbuf_get_type();
      gdouble  dx = canvx,  dy = canvy;
      GnomeCanvasItem* item = gnome_canvas_item_new(canvasRoot, pixbufType,
                                                    "pixbuf", pixbuf,
                                                    "x", dx, "y", dy,
                                                    (void*)0);
      gdk_pixbuf_unref(pixbuf);
      pyItem = PyCObject_FromVoidPtr(item, 0);
   }
   return pyItem;
} // drawMagPair


////////////////////////////////////////////////////////////////////////
static int extenRep
(
   GdkPixbuf*    pixbuf, 
   const TeXpk&  pk, 
   int           mag,      
   int           rep, 
   int           nRep, 
   int           xMin,
   int           yOffset
)
{
   unsigned  xRepOffset = - mag * pk.hoff(rep) - xMin;
   unsigned  yRepOffset = mag * pk.bitmapHeight(rep);
   DPR("mag="<<mag<< ", rep="<<rep<< ", nRep="<<nRep<< ", xMin="<<xMin);
   DPR("yOffset="<<yOffset << ", xROff="<<xRepOffset<< ", yROffs="<<yRepOffset);
   for (;  nRep--;  yOffset += yRepOffset)
   {
      blackenCharFace(pixbuf, pk, rep, mag, 0, 0, 0, xRepOffset, yOffset);
   }
   return yOffset;
} // extenRep


////////////////////////////////////////////////////////////////////////
static PyObject*  drawMagExten(PyObject* self, PyObject* args)
{  DHERE;
   PyObject* pyItem;
   PyObject* canvObj;
   PyObject* pkObj;
   int       mag, bitmapWidth, bitmapHeight, 
             top, mid, bot, rep, nRep, xMin;
   if (rPyArgParse(pyItem, args, "OOiiiiiiiii",
                                 &canvObj, &pkObj,
                                 &mag, &bitmapWidth, &bitmapHeight, &xMin,
                                 &top, &mid, &bot, &rep, &nRep))
   {
      DPR("mag="<<mag << ", bmw="<<bitmapWidth << ", bmh="<<bitmapHeight <<
          ", xMin=" << xMin << ", top="<<top << ", mid="<<mid <<
          ", bot="<<bot << ", rep="<<rep << ", nRep="<<nRep);
      const TeXpk*       pk = static_cast<TeXpk*>(PyCObject_AsVoidPtr(pkObj));
      GtkWidget*         gw = pyObj2widget(canvObj);
      GnomeCanvasGroup*  canvasRoot = gnome_canvas_root(GNOME_CANVAS(gw));
      GtkStyle*          style = gtk_widget_get_style(gw);
      const GdkColor&    bgColor = style->bg[GTK_STATE_NORMAL];
      GdkPixbuf*         pixbuf = gdk_pixbuf_new(GDK_COLORSPACE_RGB, 0, 8,
                                                 bitmapWidth, bitmapHeight);
      // initialize with background
      fill(pixbuf, bgColor.red, bgColor.green, bgColor.blue);

      int  yOffset = 0;
      if (top)
      {
         unsigned  xoffset = - mag * pk->hoff(top) - xMin;
         blackenCharFace(pixbuf, *pk, top, mag, 0, 0, 0, xoffset);
         yOffset = mag * pk->bitmapHeight(top);
      }
      yOffset = extenRep(pixbuf, *pk, mag, rep, nRep, xMin, yOffset);
      if (mid)
      {
         unsigned  xoffset = - mag * pk->hoff(mid) - xMin;
         blackenCharFace(pixbuf, *pk, mid, mag, 0, 0, 0, xoffset, yOffset);
         yOffset += mag * pk->bitmapHeight(mid);
         yOffset = extenRep(pixbuf, *pk, mag, rep, nRep, xMin, yOffset);
      }
      if (bot)
      {
         unsigned  xoffset = - mag * pk->hoff(bot) - xMin;
         blackenCharFace(pixbuf, *pk, bot, mag, 0, 0, 0, xoffset, yOffset);
      }
      static const GtkType  pixbufType = gnome_canvas_pixbuf_get_type();
      gdouble  dx = 0.,  dy = 0.;
      GnomeCanvasItem* item = gnome_canvas_item_new(canvasRoot, pixbufType,
                                                    "pixbuf", pixbuf,
                                                    "x", dx, "y", dy,
                                                    (void*)0);
      gdk_pixbuf_unref(pixbuf);
      pyItem = PyCObject_FromVoidPtr(item, 0);
   } DHERE;
   return pyItem;
} // drawMagExten


////////////////////////////////////////////////////////////////////////
static PyObject*  window2world(PyObject* self, PyObject* args)
{  DHERE0;
   PyObject* wxy;
   PyObject* canvObj;
   int       cx, cy;
   if (rPyArgParse(wxy, args, "Oii", &canvObj, &cx, &cy))
   {
      GnomeCanvas*  canvas = pyObj2canvas(canvObj);
      double        wx, wy;
      gnome_canvas_window_to_world(canvas, (double)cx, (double)cy, &wx, &wy);
      DPR0("c=(" << cx << "," << cy << ") w=(" << wx << "," << wy << ")");
      //gnome_canvas_c2w(canvas, cx, cy, &wx, &wy);
      //DPR("c=(" << cx << "," << cy << ") w=(" << wx << "," << wy << ")");
      long int  iwx = (long int)wx;
      long int  iwy = (long int)wy;
      wxy = PyTuple_New(2);
      PyTuple_SetItem(wxy, 0, PyInt_FromLong(iwx));
      PyTuple_SetItem(wxy, 1, PyInt_FromLong(iwy));
   }
   return wxy;
} // c2w

////////////////////////////////////////////////////////////////////////
static PyMethodDef
pkcanvas_methods[] =
{
   {"initgdk",       (PyCFunction)&initGDK4py,    METH_VARARGS},
   {"itemop",        (PyCFunction)&itemOp,        METH_VARARGS},
   {"createpixbufs", (PyCFunction)&createPixbufs, METH_VARARGS},
   {"drawchar",      (PyCFunction)&drawChar,      METH_VARARGS},
   {"drawfitchar",   (PyCFunction)&drawFitChar,   METH_VARARGS},
   {"drawmagchar",   (PyCFunction)&drawMagChar,   METH_VARARGS},
   {"drawmagpair",   (PyCFunction)&drawMagPair,   METH_VARARGS},
   {"drawmagexten",  (PyCFunction)&drawMagExten,  METH_VARARGS},
   {"window2world",  (PyCFunction)&window2world,  METH_VARARGS},
   {0, 0, 0}
};


////////////////////////////////////////////////////////////////////////
PyMethodDef* pkcanvasMethods()
{
   return pkcanvas_methods;
} // pkcanvasMethods


////////////////////////////////////////////////////////////////////////
extern "C" void initpkcanvas()
{
   DHERE;
   Py_InitModule("pkcanvas", pkcanvas_methods);
   DHERE;
} // initpkcanvas


#if 0
      static GdkGC*  gc = 0;
      if (gc == 0)
      {
         gc = gdk_gc_new(win); // good for all?
      }
      gdk_pixbuf_render_to_drawable(pixbuf, win, gc,
                                    0, 0,
                                    canvx, canvy,
                                    bmw, bmw,
                                    GDK_RGB_DITHER_NONE, 0, 0);
#endif
