/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;

class DviPRE
implements DviCommand {
    private DviFile m_File;
    private double m_Scale;
    private int m_Num;
    private int m_Den;
    private int m_Mag;

    public DviPRE(DviFile dviFile) {
        this.m_File = dviFile;
    }

    public void execute(int n) {
        if (n != 247) {
            this.m_File.getLog().append(" Not a DVI File (no PRE command)\n");
            return;
        }
        try {
            int n2 = this.m_File.getUnsigned(0);
            if (n2 != 2) {
                this.m_File.getLog().append(" Not a DVI file (Wrong Version: " + n2 + ")\n");
            }
            this.m_Num = this.m_File.getSigned(3);
            this.m_Den = this.m_File.getSigned(3);
            this.m_Mag = this.m_File.getSigned(3);
            this.m_Scale = (double)this.m_Num / (double)this.m_Den;
            this.m_Scale *= (double)this.m_Mag / 1000.0;
            int n3 = this.m_File.getUnsigned(0);
            byte[] byArray = new byte[n3];
            this.m_File.read(byArray, 0, n3);
            String string = new String(byArray, 0, n3);
            this.m_File.getLog().append(string + "\n");
        }
        catch (IOException iOException) {
            System.out.println("DviPRE I/O error = " + iOException.getMessage());
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    public double getScale() {
        return this.m_Scale;
    }

    public int getNum() {
        return this.m_Num;
    }

    public int getDen() {
        return this.m_Den;
    }

    public int getMag() {
        return this.m_Mag;
    }
}

