#ifndef __COMMON_H
#  define __COMMON_H
/*
*  common.h:  Basic preprocessor statements, macros, typedefs...
*
*
*  Copyright (c) 2000 Thomas Esken
*
*  This software doesn't claim completeness, correctness or usability.
*  On principle I will not be liable for ANY damages or losses (implicit
*  or explicit), which result from using or handling my software.
*  If you use this software, you agree without any exception to this
*  agreement, which binds you LEGALLY !!
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the `GNU General Public License' as published by
*  the `Free Software Foundation'; either version 2, or (at your option)
*  any later version.
*
*  You should have received a copy of the `GNU General Public License'
*  along with this program; if not, write to the:
*
*    Free Software Foundation, Inc.
*    59 Temple Place - Suite 330
*    Boston, MA 02111-1307,  USA
*/



/*
*  $Id: common.h 0.05 2000/06/06 00:00:05 tom Exp $
*/



/*
*  Include (sub)header files   ;<
*/
#  if HAVE_STDIO_H || STDC_HEADERS
#    include <stdio.h>
#  endif
#  if HAVE_STDLIB_H || STDC_HEADERS
#    include <stdlib.h>
#  endif
#  if HAVE_STRING_H || STDC_HEADERS
#    include <string.h>
#  else /* !HAVE_STRING_H && !STDC_HEADERS */
#    include <strings.h>
#    if !HAVE_STRCHR
#      ifndef strchr
#        define strchr       index
IMPORT char *strchr __P_((const char *s, int c));
#      endif
#    endif /* !HAVE_STRCHR */
#    if !HAVE_STRRCHR
#      ifndef strrchr
#        define strrchr      rindex
IMPORT char *strrchr __P_((const char *s, int c));
#      endif
#    endif /* !HAVE_STRRCHR */
#  endif /* !HAVE_STRING_H && !STDC_HEADERS */
#  ifdef __50SERIES
IMPORT char *getenv __P_((const char *env_var));
#  endif



/*
*  Basic preprocessor statements and macros.
*/
#  ifndef SPECIAL_VALUE
#    define SPECIAL_VALUE    (-1)
#  endif
#  ifndef TRUE
#    define  TRUE            (0==0)
#  endif
#  ifndef FALSE
#    define  FALSE           (!TRUE)
#  endif
#  ifndef __STDC__
#    define __STDC__         0L
#  endif
#  ifndef __LINE__
#    define __LINE__         0L
#  endif
#  ifndef __FILE__
#    define __FILE__         "???"
#  endif
#  ifndef __DATE__
#    define __DATE__         "DD-MMM-YYYY"
#  endif
#  ifndef __TIME__
#    define __TIME__         "HH:MM:SS"
#  endif
#  define  LOOP              for(;;)
#  if HAVE_VOID
#    define  VOID_PTR        void *
#  else /* !HAVE_VOID */
#    define  VOID_PTR        char *
#    define  void            int
#  endif /* !HAVE_VOID */
#  ifndef NULL
#    if !defined __cplusplus || defined __GNUC__
#      define  NULL            ((VOID_PTR)0)
#    else /* __cplusplus && !__GNUC__ */
#      define  NULL            (0)
#    endif /* __cplusplus && !__GNUC__ */
#  endif
#  if !HAVE_STRDUP
#    ifndef strdup
#      define  strdup          my_strdup
#    endif
#  endif
#  if !HAVE_STRSTR
#    ifndef strstr
#      define  strstr          my_strstr
#    endif
#  endif
#  if !HAVE_UPPER_LOWER
#    ifndef islower
#      define  islower(c) (((c) >= 'a') && ((c) <= 'z'))
#    endif
#    ifndef isupper
#      define  isupper(c) (((c) >= 'A') && ((c) <= 'Z'))
#    endif
#    ifndef tolower
#      define  tolower(c) ((isupper(c)) ? (c) - 'A' + 'a' : (c))
#    endif
#    ifndef toupper
#      define  toupper(c) ((islower(c)) ? (c) - 'a' + 'A' : (c))
#    endif
#  endif
#  if !HAVE_ISDIGIT
#    ifndef isdigit
#      define  isdigit(c) (((c) >= '0') && ((c) <= '9'))
#    endif
#  endif
#  if !HAVE_ISALPHA
#    ifndef isalpha
#      define  isalpha(c) (isupper(c) || islower(c))
#    endif
#  endif
#  if !HAVE_ISALNUM
#    ifndef isalnum
#      define  isalnum(c) (isalpha(c) || isdigit(c))
#    endif
#  endif
#  if !HAVE_ISSPACE
#    ifndef isspace
#      define  isspace(c) (   (c) == ' '  || (c) == '\f' || (c) == '\n' \
                           || (c) == '\r' || (c) == '\t' || (c) == '\v')
#    endif
#  endif



/*
*  Preprocessor statements for the exit codes.
*/
#  define  ERR_NONE                      0
/*
*  Common values.
*/
#  define  ERR_C_FUNCTION_FAILURE        48
#  define  ERR_INTERNAL_TABLE_CRASH      49
#  define  ERR_NO_MEMORY_AVAILABLE       50
#  define  ERR_IRREGULAR_FILE            103
#  define  ERR_ZERO_FILE                 104
#  define  ERR_CORRUPTED_FILE            105
#  define  ERR_CLOSE_FILE                106
#  define  ERR_READ_FILE                 107
#  define  ERR_FILE_NOT_FOUND            109
#  define  ERR_NO_FILENAME_GIVEN         110
#  define  ERR_INVALID_OPTION            126
/*
*  Force the use of THESE values!
*/
#  ifndef EXIT_FATAL
#    define  EXIT_FATAL                    2
#  endif
#  ifndef EXIT_FAILURE
#    define  EXIT_FAILURE                  1
#  endif
#  ifndef EXIT_SUCCESS
#    define  EXIT_SUCCESS                  ERR_NONE
#  endif



/*
*  Program specific preprocessor statements.
*/
/* Default length of a "string" text buffer. */
#  ifndef MAXLEN_MAX
#    define  MAXLEN_MAX       1024
#  endif

/* Default number of command line arguments in `my_argv[]' table. */
#  ifndef MY_ARGC_MAX
#    define  MY_ARGC_MAX      64
#  endif

/* Exit status on: help, version, license. */
#  ifndef  EXIT_STAT_HELP
#    define  EXIT_STAT_HELP   EXIT_SUCCESS
#  endif

/* Default length of a displayed (translated) text line. */
#  ifndef  LEN_SINGLE_LINE
#    define  LEN_SINGLE_LINE  200
#  endif



/*
*  Last but not least :)
*/
#  define  COPYRIGHT_TXT    "Copyright (c) 1990-1993, 2000 Thomas Esken"
#  define  BUG_REPORT_ADR   "esken@gmx.net"



/*
*  Common preprocessor macros.
*/
#  ifdef S_NEWLINE
#    undef  S_NEWLINE
#  endif
#  define  S_NEWLINE(fp)    fputc('\n', (fp))
#  ifdef MIN
#    undef  MIN
#  endif
#  define  MIN(x1, x2)   (((x1) < (x2)) ? (x1) : (x2))
#  ifdef MAX
#    undef  MAX
#  endif
#  define  MAX(x1, x2)   (((x1) > (x2)) ? (x1) : (x2))
#  ifdef abs
#    undef  abs
#  endif
#  define  abs(x)           (((x) < 0) ? (-(x)) : (x))
#  ifdef SGN
#    undef  SGN
#  endif
#  define  SGN(x)           (((x) < 0) ? -1 : (((x) > 0) ? 1 : 0))
#  ifdef ROUND
#    undef  ROUND
#  endif
#  define  ROUND(x)         ((abs(x)+0.5)*SGN(x))
#  ifdef IDX
#    undef  IDX
#  endif
#  define  IDX(c)           (tolower((c)) - 'a')
#  ifdef CHR2DIG
#    undef  CHR2DIG
#  endif
#  define  CHR2DIG(c)       ((c) - '0')
#  ifdef DIG2CHR
#    undef  DIG2CHR
#  endif
#  define  DIG2CHR(x)       ((x) + '0')
#  if USE_DE
#    define  GETKEY(instream, outstream, text, program_name, quitchar) \
     do \
      { \
        auto int  hidn___; \
        fprintf((outstream), (text), (program_name), (quitchar)); \
        hidn___ = fgetc((instream)); \
        if (tolower(hidn___) == (int)*(quitchar)) \
         { \
           while (   ((hidn___=fgetc((instream))) != '\n') \
                  && (hidn___ != EOF)) \
             ;   /* Void */ \
           hidn___ = EOF; \
         } \
        else \
          if (hidn___ != '\n') \
            while (   ((hidn___=fgetc((instream))) != '\n') \
                   && (tolower(hidn___) != (int)*(quitchar)) \
                   && (hidn___ != EOF)) \
              ;   /* Void */ \
        if (tolower(hidn___) == (int)*(quitchar)) \
         { \
           while (   ((hidn___=fgetc((instream))) != '\n') \
                  && (hidn___ != EOF)) \
             ;   /* Void */ \
           hidn___ = EOF; \
         } \
        if (hidn___ == EOF) \
          exit (EXIT_SUCCESS); \
      } while (FALSE)
#  else /* !USE_DE */
#    define  GETKEY(instream, outstream, text, program_name, quitchar) \
     do \
      { \
        auto int  hidn___; \
        fprintf((outstream), (text), (program_name), (quitchar)); \
        hidn___ = fgetc((instream)); \
        if (tolower(hidn___) == (int)*(quitchar)) \
         { \
           while (   ((hidn___=fgetc((instream))) != '\n') \
                  && (hidn___ != EOF)) \
             ;   /* Void */ \
           hidn___ = EOF; \
         } \
        else \
          if (hidn___ != '\n') \
            while (   ((hidn___=fgetc((instream))) != '\n') \
                   && (tolower(hidn___) != (int)*(quitchar)) \
                   && (hidn___ != EOF)) \
              ;   /* Void */ \
        if (tolower(hidn___) == (int)*(quitchar)) \
         { \
           while (   ((hidn___=fgetc((instream))) != '\n') \
                  && (hidn___ != EOF)) \
             ;   /* Void */ \
           hidn___ = EOF; \
         } \
        if (hidn___ == EOF) \
          exit (EXIT_SUCCESS); \
      } while (FALSE)
#  endif /* !USE_DE */



/*
*  Type definitions.
*/
typedef
  unsigned char
  Uchar;
typedef
  unsigned int
  Uint;
#  ifdef DJG
typedef
#    if defined(__STDC__) && __STDC__
  unsigned short int
#    else /* !__STDC__ */
  unsigned short
#    endif /* !__STDC__ */
  Usint;
#  endif /* DJG */
typedef
#  if defined(__STDC__) && __STDC__
  signed long int
#  else /* !__STDC__ */
  long
#  endif /* !__STDC__ */
  Slint;
typedef
#  if defined(__STDC__) && __STDC__
  unsigned long int
#  else /* !__STDC__ */
  unsigned long
#  endif /* !__STDC__ */
  Ulint;
typedef
  int
  Bool;
/*
*  The quicksort (`qsort()') compare function type.
*/
typedef
  int
  (*Cmp_func)__P_((const VOID_PTR, const VOID_PTR));
#endif /* __COMMON_H */
