/*
 * stat.c
 *
 * Copyright (C) 1993 Alain Knaff
 */
#include "sysincludes.h"


int ___zlibc_lstat(const char *file_name, struct stat *buf)
{
#ifdef SYS_prev_lstat
	return real_prev_lstat(file_name, buf );
#else
	return real_lstat(file_name, buf );
#endif
}


int ___zlibc_stat(const char *file_name, struct stat *buf)
{
#ifdef SYS_prev_stat
	return real_prev_stat(file_name, buf );
#else
	return real_stat(file_name, buf );
#endif
}

static int zstat(__const char *name, char *newname, struct stat *buf)
{
  int fd,st,ft;
  unsigned char size_buffer[4];

  ft = zlib_getfiletype(name,-1);
  if( (ft & PM_READ_MASK) == PM_LEAVE_COMPR ){
    errno = ENOENT ;
    return -1;
  }

  if ((ft & PM_SIZE_COMPR_MASK) == PM_SIZE_COMPR)
	  ___zlibc_stat(newname,buf);
  else {
      fd=real_open(newname, O_RDONLY | O_NDELAY, 0);
      if ( fd < 0 ){
	  if ( errno == ENOENT )
	      return -1;
	  return 2;
      } else {  
	  st = fstat(fd,buf);    
	  if ( st < 0 ){
	      close(fd);
	      return st;
	  }	
	  
	  if ( ! S_ISREG ( buf->st_mode ))
	      /* not a regular file. Don't waste time determining its size */
	      return st;

	  lseek(fd, -4 , SEEK_END);
	  read(fd, size_buffer, 4 );

	  buf->st_size = size_buffer[0] + ( size_buffer[1] << 8 ) + 
	      (size_buffer[2] << 16 ) + (size_buffer[3] << 24 );
	  close(fd);
      }	  
  }

  if ((ft & PM_READ_MASK) == PM_SHOW_PIPE)
      buf->st_mode ^= S_IFIFO | S_IFREG;
  
  if (!(ft & (PM_CREATE_COMPR | PM_APPEND_COMPR | PM_UNCOMPR_BEFORE_WRITE)))
      buf->st_mode &= ~0222;

#ifdef NEGATE_INODES
    buf->st_ino= -buf->st_ino;
#endif

  return 0;
}

static int zlibc_stat(__const char *file_name, struct stat *buf)
{
  int st, olderrno;

  errno = 0;

  st = ___zlibc_stat(file_name, buf );

  if ( st >= 0 || errno != ENOENT )
    return st;

  {
    char newname[MAXPATHLEN + MAXEXTLEN + 1];
    olderrno = errno;
    zlib_initialise();
    errno = olderrno;

    if ( zlib_mode & CM_DISAB )
      return st;

    if ( zlib_mode & CM_VERBOSE )
      fprintf(stderr,"stating %s\n", file_name);

    strncpy(newname,file_name,MAXPATHLEN);
    strcat(newname,zlib_ext);

    st = zstat(file_name,newname, buf);

    if ( zlib_mode & CM_VERBOSE )
      fprintf(stderr,"stated %s, rv=%d\n", file_name, st);

    if ( st == 2 ){
      st = stat(newname, buf);
      buf->st_size = 0;
    }

    if ( st < 0 ){
      errno = ENOENT;
      return st;
    }

  }
  return st;
}

static int zlibc_lstat(__const char *file_name, struct stat *buf)
{
  int st;

  st = ___zlibc_lstat(file_name, buf);

  if ( st >= 0 || errno != ENOENT )
    return st;

  {
    char newname[MAXPATHLEN + MAXEXTLEN + 1];

    zlib_initialise();
    if ( zlib_mode & CM_DISAB )
      return st;
    if ( zlib_mode & CM_VERBOSE )
      fprintf(stderr,"lstating %s\n", file_name);

    strncpy(newname,file_name,MAXPATHLEN);
    strcat(newname,zlib_ext);

    st = ___zlibc_lstat(newname, buf);

    if ( st < 0 ){
      errno = ENOENT;
      return st;
    }

    if ( S_ISLNK(buf->st_mode) ){
      if ( buf->st_size > zlib_extlen )
	buf->st_size -= zlib_extlen;
      return st;
    }
     
    st = zstat(file_name,newname,buf);
    if ( st == 2 )
      /* could not zstat it, keep first info */
      st=0;
  }

  return st;
}

#ifdef HAVE__XSTAT

int _xstat(int ver, __const char *name, struct stat *buf)
{
	if ( ver == LINUX_STAT_VERSION){
		return zlibc_stat(name, buf);
	} else {
		errno = EINVAL;
		return -1;
	}
}

int _lxstat(int ver, __const char *name, struct stat *buf)
{
	if ( ver == LINUX_STAT_VERSION){
		return zlibc_lstat(name, (struct stat *)buf);
	} else {
		errno = EINVAL;
		return -1;
	}
}
#else

int stat(__const char *name, struct stat *buf)
{
	return zlibc_stat(name, buf);
}

int lstat(__const char *name, struct stat *buf)
{
	return zlibc_lstat(name, buf);
}


#endif
