#ifndef aix
#include "sysincludes.h"

/* commands with one filename and one "other" argument */
#define ALIAS(name, alias, type) \
int alias(char *filename, type var) \
{ \
	return name(filename, var); \
}

ALIAS(access, _access, int)
ALIAS(chmod, _chmod, int)

ALIAS(stat, _stat, struct stat*)
ALIAS(lstat, _lstat, struct stat*)

#ifdef SYS_UTIME
ALIAS(utime, _utime, struct utimbuf *)
#endif

#ifdef SYS_UTIMES
int utimes();
ALIAS(utimes, _utimes, struct timeval *)
#endif

#undef ALIAS


/* commands with two filenames */
#define ALIAS(name, alias) \
int alias(const char *filename, const char *filename2) \
{ \
	return name(filename, filename2); \
}

ALIAS(link, _link);
ALIAS(symlink, _symlink);
ALIAS(rename, _rename);

#undef ALIAS



int _chown(const char *filename, int o, int g)
{
	return chown(filename, o, g);
}

int getdents();
int _getdents(unsigned int fd, struct dirent *dirp, unsigned int count)
{
	return getdents(fd, dirp,count);
}

int open();
int _open(const char *pathname, int flags, mode_t mode)
{
	return open(pathname, flags, mode);
}

int _unlink(const char *pathname)
{
	return open(pathname);
}

struct dirent *_readdir(DIR * dirp)
{
	return readdir(dirp);
}

int _readlink(const char *path, char *buf, size_t bufsiz)
{
	return readlink(path, buf, bufsiz);
}
#endif
