/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _html_parser_h
#define _html_parser_h

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Define the context of parsing. 
 */
typedef struct html_parser {
  /*
   * The source field contains a file name.
   */
#define HTML_SOURCE_FILENAME	0x01
  /*
   * The source field contains HTML text to process.
   */ 
#define HTML_SOURCE_STRING	0x02

  int info;

  /*
   * HTML comes from source filename if (HTML_SOURCE_FILENAME is set)
   * or from the buffer pointed by source if HTML_SOURCE_STRING is set).
   */
  char* source;
  int source_length;

  /*
   * Process at most input_limit data from source
   */
  int input_limit;

  /*
   * Ignore all tokens that match ignore
   */
  int ignore;
} html_parser_t;

#define html_parser_run(function) \
{ \
  html_parser_t* parser = &arg->parser; \
  if(parser->info & HTML_SOURCE_STRING) {  \
 \
    YY_BUFFER_STATE yy_buffer = yy_scan_bytes(parser->source, parser->source_length); \
    if(verbose) fprintf(stderr, "html_parser_parse: parsing from string\n"); \
    yy_switch_to_buffer(yy_buffer); \
    ret = function(arg); \
    yy_delete_buffer(yy_buffer); \
 \
  } else if(parser->info & HTML_SOURCE_FILENAME) { \
 \
    FILE* fp = fopen(parser->source, "r"); \
    YY_BUFFER_STATE file_buffer; \
    if(verbose) fprintf(stderr, "html_parser_parse: parsing from file %s\n", parser->source); \
    if(fp == 0) { \
      fprintf(stderr, "html_parser_parse: cannot open %s for reading\n", parser->source); \
      perror(""); \
      ret = 0; \
    } else { \
      file_buffer = yy_create_buffer(fp, YY_BUF_SIZE); \
      yy_switch_to_buffer(file_buffer); \
      ret = function(arg); \
      yy_delete_buffer(file_buffer); \
      fclose(fp); \
    } \
  } else { \
    fprintf(stderr, "html_parser_parse: no source, nothing done\n"); \
  } \
}

/*
 * Initialize the arg structure.
 */
void html_parser_reset(html_parser_t* arg);

#ifdef __cplusplus
}
#endif

#endif /* _html_parser_h */
