/* MD5.H - header file for MD5C.C
 */

/* Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All
rights reserved.

License to copy and use this software is granted provided that it
is identified as the "RSA Data Security, Inc. MD5 Message-Digest
Algorithm" in all material mentioning or referencing this software
or this function.

License is also granted to make and use derivative works provided
that such works are identified as "derived from the RSA Data
Security, Inc. MD5 Message-Digest Algorithm" in all material
mentioning or referencing the derived work.

RSA Data Security, Inc. makes no representations concerning either
the merchantability of this software or the suitability of this
software for any particular purpose. It is provided "as is"
without express or implied warranty of any kind.

These notices must be retained in any copies of any part of this
documentation and/or software.
 */

/*
 * WARNING: MD5Init exists in nsl.a on solaris-2.4
 */
#define MD5Init		MD5Init_alt
#define MD5Update	MD5Update_alt
#define MD5Final	MD5Final_alt

/* GLOBAL.H - RSAREF types and constants
 */

/* PROTOTYPES should be set to one if and only if the compiler supports
  function argument prototyping.
The following makes PROTOTYPES default to 0 if it has not already
  been defined with C compiler flags.
 */
#ifndef __STDC__
#define PROTOTYPES 0
#else
#define PROTOTYPES 1
#endif

/* POINTER defines a generic pointer type */
typedef unsigned char *POINTER;

/* UINT2 defines a two byte word */
typedef unsigned short int UINT2;

/* UINT4 defines a four byte word.
We use the Perl byte-order definition to discover if a long has more than
  4 bytes. If so we will try to use an unsigned int. This is OK for DEC
  Alpha but may not work everywhere. See the TO32 definition below.
 */
#if (PERL_BYTEORDER <= 4321) || defined(UINT4_IS_LONG)
typedef unsigned long UINT4;
#else
typedef unsigned int UINT4;
#endif

/* TO32 ensures that UINT4 values are truncated to 32 bits.
A Cray has short, int and long all at 64 bits so we need to apply this
  macro to reduce UINT4 values to 32 bits at appropriate places. If UINT4
  really does have 32 bits then this is a no-op.
 */
#if defined(cray) || defined(TRUNCATE_UINT4)
#define TO32(x)	((x) & 0xffffffff)
#else
#define TO32(x)	(x)
#endif

/* PROTO_LIST is defined depending on how PROTOTYPES is defined above.
If using PROTOTYPES, then PROTO_LIST returns the list, otherwise it
  returns an empty list.
 */
#if PROTOTYPES
#define PROTO_LIST(list) list
#else
#define PROTO_LIST(list) ()
#endif

/* MD5 context. */
typedef struct {
  UINT4 state[4];                                   /* state (ABCD) */
  UINT4 count[2];        /* number of bits, modulo 2^64 (lsb first) */
  unsigned char buffer[64];                         /* input buffer */
} MD5_CTX;

void MD5Init PROTO_LIST ((MD5_CTX *));
void MD5Update PROTO_LIST
  ((MD5_CTX *, unsigned char *, unsigned long));
void MD5Final PROTO_LIST ((unsigned char [16], MD5_CTX *));
