/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef HAVE_DMALLOC_H
#include <dmalloc.h>
#endif /* HAVE_DMALLOC_H */

#include <sqlutil.h>
#include <webbase_create.h>

static const char* default_schema[] = {
"
create table start (
  rowid int not null auto_increment,
#
# Crawl data
#
  url varchar(255) binary not null,
#  url_md5 char(32) not null default '',
  info set ('sleepy', 'unescape', 'auth', 'nocookie', 'accept', 'heuristics',
            'sticky', 'filter', 'homefree', 'virgin', 'exploring', 'explored',
            'updating', 'in_core', 'allow', 'disallow', 'hook_info'),
  url_max_size smallint default -1,
  size_limit int default 100000,
  min int default -1,
  depth int default 2,
  level int default 1000000,
  timeout smallint default -1,
  loaded_delay smallint default -1,
  modified_delay smallint default -1,
  not_found_delay smallint default -1,
  timeout_delay smallint default -1,
  robot_delay smallint default -1,
  auth varchar(255) binary,
  accept varchar(255) binary,
  filter varchar(255) binary,
  allow varchar(255) binary,
  disallow varchar(255) binary,
  hook_info varchar(255) binary,
  sources set ('all'),
  disabled enum ('yes', 'no') default 'no',
  created datetime,
  modified timestamp,
#
# Internal data
#
  count int default 0,
  delay int default 0,

#
# User defined data start, may be removed or enriched
#
  email varchar(255),
  comment varchar(255),
  town varchar(64),
  country varchar(64),
#  target varchar(64),
#  category varchar(32),
#  other_categories varchar(255),
#  title varchar(255),
#  keywords varchar(255),
#  entity varchar(32),
#  last_name varchar(64),
#  first_name varchar(64),
#  street varchar(255),
#  zip_code varchar(16),
#  company varchar(32),
#  telephone varchar(32),
#  fax varchar(32),
#
# User defined data end
#

  unique start1 (rowid),
  index start2 (url(122))
#  unique start3 (url_md5)
)",

"
create table robots (
  netloc varchar(255) binary not null,
  next_crawl int,
  queue_crawl int,
  allow text,
  disallow text,

  index robot1 (netloc)
)",

"
create table cookies (
  netloc varchar(255) binary not null,
  path varchar(255) binary not null,
  cookie_in varchar(255) binary not null,
  cookie_out varchar(255) binary,
#  expires datetime,

  unique cookies1 (netloc(122), path(122))
)",

"
create table start2url (
  start int not null,
  url int not null,
  level smallint not null default -1,

  unique start2url1 (start,url),
  index start2url2 (url)
)",

"
create table url (
  rowid int not null auto_increment,
  url varchar(255) binary not null,
#  url_md5 char(32) not null default '',
  info set ('frame', 'complete', 'cookie', 'base', 'relative', 'absolute',
            'content', 'location', 'timeout', 'not_modified', 'not_found', 'ok',
	    'error', 'http', 'ftp', 'news', 'cumulmd5', 'extract', 'title',
	    'keywords', 'description', 'reading', 'truncated', 'ftp_dir'),
  code smallint,
  mtime datetime,
  mtime_error datetime,
  tags smallint,
#
# To build this list use schema2list < meta-schema.sql
# Leave 'unknown' in the first position
# Don't forget to remove the comman on the last line.
#
  content_type enum(
    'unknown',
	'application/access',
    'application/activemessage',
    'application/andrew-inset',
    'application/applefile',
    'application/atomicmail',
    'application/cals-1840',
    'application/commonground',
    'application/cybercash',
    'application/dca-rft',
    'application/dec-dx',
    'application/dsptype',
    'application/eshop',
    'application/excel',
	'application/font-tdpfr',
	'application/fractals',
    'application/gzip',
    'application/iges',
	'application/java-archive',
    'application/mac-binhex40',
    'application/macwriteii',
    'application/mathematica',
    'application/msword',
    'application/news-message-id',
    'application/news-transmission',
    'application/octet-stream',
    'application/oda',
    'application/pdf',
    'application/pgp-encrypted',
    'application/pgp-keys',
    'application/pgp-signature',
    'application/postscript',
	'application/powerpoint',
    'application/prs.alvestrand.titrax-sheet',
    'application/remote-printing',
    'application/riscos',
    'application/rtf',
	'application/schedule',
    'application/set-payment',
    'application/set-payment-initiation',
    'application/set-registration',
    'application/set-registration-initiation',
    'application/sgml',
    'application/sgml-open-catalog',
    'application/slate',
    'application/vemmi',
    'application/vnd.businessobjects',
    'application/vnd.enliven',
    'application/vnd.fdf',
    'application/vnd.framemaker',
    'application/vnd.intertrust.digibox',
    'application/vnd.intertrust.nncp',
    'application/vnd.japannet-directory-service',
    'application/vnd.japannet-payment-wakeup',
    'application/vnd.japannet-registration-wakeup',
    'application/vnd.japannet-verification-wakeup',
    'application/vnd.koan',
	'application/vnd.lotus-1-2-3',
	'application/vnd.lotus-approach',
	'application/vnd.lotus-freelance',
	'application/vnd.lotus-organizer',
	'application/vnd.lotus-screencam',
	'application/vnd.lotus-wordpro',
    'application/vnd.meridian-slingshot',
    'application/vnd.mif',
	'application/vnd.ms-access',
    'application/vnd.ms-artgalry',
	'application/vnd.ms-excel',
    'application/vnd.ms-powerpoint',
    'application/vnd.ms-project',
	'application/vnd.ms-schedule',
    'application/vnd.ms-tnef',
    'application/vnd.ms-works',
    'application/vnd.music-niff',
    'application/vnd.noblenet-sealer',
    'application/vnd.rapid',
    'application/vnd.seemail',
    'application/vnd.street-stream',
    'application/vnd.svd',
    'application/vnd.truedoc',
    'application/vnd.xara',
    'application/wita',
    'application/wordperfect',
	'application/wordperfect5.1',
    'application/x-bcpio',
    'application/x-cpio',
    'application/x-csh',
    'application/x-dvi',
	'application/x-freelance',
    'application/x-gtar',
    'application/x-hdf',
	'application/x-javascript',
	'application/x-javascript-config',
    'application/x-latex',
    'application/x-maker',
    'application/x-mif',
    'application/x-netcdf',
	'application/x-ns-proxy-autoconfig',
    'application/x-per',
	'application/x-pkcs7-mime',
	'application/x-pkcs7-signature',
    'application/x-sh',
    'application/x-shar',
	'application/x-stuffit',
    'application/x-sv4cpio',
    'application/x-sv4cr',
    'application/x-tar',
    'application/x-tcl',
    'application/x-tex',
    'application/x-texinfo',
    'application/x-troff',
    'application/x-troff-ma',
    'application/x-troff-me',
    'application/x-troff-ms',
    'application/x-usta',
    'application/x-wais-source',
    'application/x400-bp',
    'application/zcat',
	'application/zip',
    'audio/32kadpcm',
    'audio/basic',
    'audio/vnd.qcelp',
    'audio/x-aiff',
    'audio/x-midi',
    'audio/x-mpeg',
    'audio/x-mpeg-',
    'audio/x-pn-realaudio',
    'audio/x-wav',
    'image/Graphics',
    'image/g3fax',
    'image/gif',
    'image/ief',
    'image/jpe',
    'image/jpeg',
    'image/pn',
    'image/tiff',
    'image/vnd.dwg',
    'image/vnd.dxf',
    'image/vnd.fpx',
    'image/vnd.net-fpx',
    'image/vnd.svf',
    'image/x-bm',
    'image/x-cmu-raste',
    'image/x-cmu-raster',
    'image/x-fit',
	'image/x-photo-cd',
	'image/x-png',
    'image/x-portable-anymap',
    'image/x-portable-bitmap',
    'image/x-portable-graymap',
    'image/x-portable-pixmap',
    'image/x-rgb',
    'image/x-targ',
    'image/x-xbitmap',
    'image/x-xpixmap',
    'image/x-xwindowdump',
    'magnus-internal/cgi',
    'magnus-internal/imagemap',
    'magnus-internal/parsed-html',
    'message/external-body',
    'message/http',
    'message/new',
    'message/partial',
    'message/rfc82',
    'model/iges',
    'model/mesh',
    'model/vrml',
    'multipart/alternative',
    'multipart/appledouble',
    'multipart/byteranges',
    'multipart/digest',
    'multipart/encrypted',
    'multipart/form-data',
    'multipart/header-set',
    'multipart/mixed',
    'multipart/parallel',
    'multipart/report',
    'multipart/signed',
    'multipart/voice-message',
    'text/enriched',
    'text/ftp-dir-listing',
    'text/html',
    'text/plain',
    'text/richtext',
    'text/sgml',
    'text/tab-separated-values',
    'text/vnd.fmi.flexstor',
    'text/vnd.latex-z',
    'text/x-po',
    'text/x-setext',
	'text/x-vcard',
    'video/mpeg',
    'video/quicktime',
    'video/vnd.motorola.video',
    'video/vnd.motorola.videop',
    'video/vnd.vivo',
    'video/x-msvideo',
    'video/x-sgi-movie',
	'www/unknown',
    'x-world/x-vrml'
  ),
  content_length int,
  md5 char(16),
  complete_rowid int not null default 0,
  crawl datetime not null default 0,
  hookid int,
  language enum ('unknown', 'fr', 'uk', 'de', 'it', 'es'),
  extract varchar(128) binary,
  title varchar(80) binary,

  unique url1 (rowid),
  index url2 (url),
  index url3 (complete_rowid),
  index url4 (crawl)
#  unique url5 (url_md5)
)",

"
create table url_complete (
  rowid int not null auto_increment,
  keywords varchar(255) binary,
  description varchar(255) binary,
  base_url varchar(255) binary,
  relative mediumtext,
  absolute mediumtext,
  location varchar(255) binary,

  unique urlc1 (rowid)
)",

"
create table mime_restrict (
  spec char(255) binary not null,
  ext text,
  mime text,

  unique mime_restrict1 (spec)
)",

"
create table mime2ext (
  mime char(32) binary not null,
  ext char(32) binary not null,

  unique mime2ext2 (mime),
  index mime2ext1 (ext)
)",

"
create table home_re (
  netloc char(255) binary not null,
  re char(255),

  unique home_re1 (netloc)
)",

"
create table statistics (
  type char(16) binary not null,
  rank int not null,
  info text,

  index statistics1 (type),
  index statistics2 (rank)
)",

"
create table locks (
  name varchar(255) binary not null,
  pid int not null,

  unique locks1 (name),
  index locks2 (pid)
)",

"insert into mime2ext values ('application/activemessage', '')",
"insert into mime2ext values ('application/access', 'mdb,mda,mde,')",
"insert into mime2ext values ('application/andrew-inset', '')",
"insert into mime2ext values ('application/applefile', '')",
"insert into mime2ext values ('application/atomicmail', '')",
"insert into mime2ext values ('application/cals-1840', '')",
"insert into mime2ext values ('application/commonground', '')",
"insert into mime2ext values ('application/cybercash', '')",
"insert into mime2ext values ('application/dca-rft', '')",
"insert into mime2ext values ('application/dec-dx', '')",
"insert into mime2ext values ('application/dsptype', 'tsp,')",
"insert into mime2ext values ('application/eshop', '')",
"insert into mime2ext values ('application/excel', 'xls,xlt,xlm,xld,xla,xlc,xlw,xll,')",
"insert into mime2ext values ('application/font-tdpfr', 'pfr,')",
"insert into mime2ext values ('application/fractals', 'fif,')",
"insert into mime2ext values ('application/gzip', 'gz,')",
"insert into mime2ext values ('application/iges', '')",
"insert into mime2ext values ('application/java-archive', 'jar,')",
"insert into mime2ext values ('application/mac-binhex40', 'hqx,')",
"insert into mime2ext values ('application/macwriteii', '')",
"insert into mime2ext values ('application/mathematica', '')",
"insert into mime2ext values ('application/msword', 'doc,')",
"insert into mime2ext values ('application/news-message-id', '')",
"insert into mime2ext values ('application/news-transmission', '')",
"insert into mime2ext values ('application/octet-stream', 'bin,exe,')",
"insert into mime2ext values ('application/oda', 'oda,')",
"insert into mime2ext values ('application/pdf', 'pdf,')",
"insert into mime2ext values ('application/pgp-encrypted', '')",
"insert into mime2ext values ('application/pgp-keys', '')",
"insert into mime2ext values ('application/pgp-signature', '')",
"insert into mime2ext values ('application/postscript', 'ai,eps,ps,')",
"insert into mime2ext values ('application/powerpoint', 'ppt,pot,ppa,pps,pwz,')",
"insert into mime2ext values ('application/prs.alvestrand.titrax-sheet', '')",
"insert into mime2ext values ('application/remote-printing', '')",
"insert into mime2ext values ('application/riscos', '')",
"insert into mime2ext values ('application/rtf', 'rtf,')",
"insert into mime2ext values ('application/schedule', 'scd,sch,sc2,')",
"insert into mime2ext values ('application/set-payment', '')",
"insert into mime2ext values ('application/set-payment-initiation', '')",
"insert into mime2ext values ('application/set-registration', '')",
"insert into mime2ext values ('application/set-registration-initiation', '')",
"insert into mime2ext values ('application/sgml', '')",
"insert into mime2ext values ('application/sgml-open-catalog', '')",
"insert into mime2ext values ('application/slate', '')",
"insert into mime2ext values ('application/vemmi', '')",
"insert into mime2ext values ('application/vnd.businessobjects', '')",
"insert into mime2ext values ('application/vnd.enliven', '')",
"insert into mime2ext values ('application/vnd.fdf', '')",
"insert into mime2ext values ('application/vnd.framemaker', '')",
"insert into mime2ext values ('application/vnd.intertrust.digibox', '')",
"insert into mime2ext values ('application/vnd.intertrust.nncp', '')",
"insert into mime2ext values ('application/vnd.japannet-directory-service', '')",
"insert into mime2ext values ('application/vnd.japannet-payment-wakeup', '')",
"insert into mime2ext values ('application/vnd.japannet-registration-wakeup', '')",
"insert into mime2ext values ('application/vnd.japannet-verification-wakeup', '')",
"insert into mime2ext values ('application/vnd.koan', '')",
"insert into mime2ext values ('application/vnd.lotus-1-2-3', '123,wk4,wk3,wk1,')",
"insert into mime2ext values ('application/vnd.lotus-approach', 'apr,vew,')",
"insert into mime2ext values ('application/vnd.lotus-freelance', '')",
"insert into mime2ext values ('application/vnd.lotus-organizer', 'or3,or2,org,')",
"insert into mime2ext values ('application/vnd.lotus-screencam', 'scm')",
"insert into mime2ext values ('application/vnd.lotus-wordpro', 'lwp,sam,')",
"insert into mime2ext values ('application/vnd.meridian-slingshot', '')",
"insert into mime2ext values ('application/vnd.mif', 'mif,')",
"insert into mime2ext values ('application/vnd.ms-access', '')",
"insert into mime2ext values ('application/vnd.ms-artgalry', '')",
"insert into mime2ext values ('application/vnd.ms-excel', '')",
"insert into mime2ext values ('application/vnd.ms-powerpoint', '')",
"insert into mime2ext values ('application/vnd.ms-project', '')",
"insert into mime2ext values ('application/vnd.ms-schedule', '')",
"insert into mime2ext values ('application/vnd.ms-tnef', '')",
"insert into mime2ext values ('application/vnd.ms-works', '')",
"insert into mime2ext values ('application/vnd.music-niff', '')",
"insert into mime2ext values ('application/vnd.noblenet-sealer', '')",
"insert into mime2ext values ('application/vnd.rapid', '')",
"insert into mime2ext values ('application/vnd.seemail', '')",
"insert into mime2ext values ('application/vnd.street-stream', '')",
"insert into mime2ext values ('application/vnd.svd', '')",
"insert into mime2ext values ('application/vnd.truedoc', '')",
"insert into mime2ext values ('application/vnd.xara', '')",
"insert into mime2ext values ('application/wita', '')",
"insert into mime2ext values ('application/wordperfect', 'wpd,wp6,')",
"insert into mime2ext values ('application/wordperfect5.1', '')",
"insert into mime2ext values ('application/x-bcpio', 'bcpio,')",
"insert into mime2ext values ('application/x-cpio', 'cpio,')",
"insert into mime2ext values ('application/x-csh', 'csh,')",
"insert into mime2ext values ('application/x-dvi', 'dvi,')",
"insert into mime2ext values ('application/x-freelance', 'prz,pre,')",
"insert into mime2ext values ('application/x-gtar', 'gtar,')",
"insert into mime2ext values ('application/x-hdf', 'hdf,')",
"insert into mime2ext values ('application/x-javascript', 'js,mocha,')",
"insert into mime2ext values ('application/x-javascript-config', 'jsc,')",
"insert into mime2ext values ('application/x-latex', 'latex,')",
"insert into mime2ext values ('application/x-maker', 'fm,')",
"insert into mime2ext values ('application/x-mif', 'mif,')",
"insert into mime2ext values ('application/x-netcdf', 'nc,cdf,')",
"insert into mime2ext values ('application/x-ns-proxy-autoconfig', 'pac,')",
"insert into mime2ext values ('application/x-per', 'pl,')",
"insert into mime2ext values ('application/x-pkcs7-mime', 'p7m,p7c,')",
"insert into mime2ext values ('application/x-pkcs7-signature', 'p7s,')",
"insert into mime2ext values ('application/x-sh', 'sh,')",
"insert into mime2ext values ('application/x-shar', 'shar,')",
"insert into mime2ext values ('application/x-stuffit', 'sit,')",
"insert into mime2ext values ('application/x-sv4cpio', 'sv4cpio,')",
"insert into mime2ext values ('application/x-sv4cr', 'sv4crc,')",
"insert into mime2ext values ('application/x-tar', 'tar,')",
"insert into mime2ext values ('application/x-tcl', 'tcl,')",
"insert into mime2ext values ('application/x-tex', 'tex,')",
"insert into mime2ext values ('application/x-texinfo', 'texinfo,texi,')",
"insert into mime2ext values ('application/x-troff', 't,tr,roff,')",
"insert into mime2ext values ('application/x-troff-ma', 'man,1,2,3,4,5,6,7,8,')",
"insert into mime2ext values ('application/x-troff-me', 'me,')",
"insert into mime2ext values ('application/x-troff-ms', 'ms,')",
"insert into mime2ext values ('application/x-usta', 'ustar,')",
"insert into mime2ext values ('application/x-wais-source', 'src,')",
"insert into mime2ext values ('application/x400-bp', '')",
"insert into mime2ext values ('application/zcat', 'Z,z,')",
"insert into mime2ext values ('application/zip', 'zip,')",
"insert into mime2ext values ('audio/32kadpcm', '')",
"insert into mime2ext values ('audio/basic', 'au,snd,')",
"insert into mime2ext values ('audio/vnd.qcelp', '')",
"insert into mime2ext values ('audio/x-aiff', 'aif,aiff,aifc,')",
"insert into mime2ext values ('audio/x-midi', 'mid,')",
"insert into mime2ext values ('audio/x-mpeg', 'mp2,mpa,abs,mpega,')",
"insert into mime2ext values ('audio/x-mpeg-', '')",
"insert into mime2ext values ('audio/x-pn-realaudio', 'ra,ram,')",
"insert into mime2ext values ('audio/x-wav', 'wav,')",
"insert into mime2ext values ('image/Graphics', '')",
"insert into mime2ext values ('image/g3fax', '')",
"insert into mime2ext values ('image/gif', 'gif,')",
"insert into mime2ext values ('image/ief', 'ief,')",
"insert into mime2ext values ('image/jpe', 'jpeg,jpe,jfif,')",
"insert into mime2ext values ('image/jpeg', 'jpg,')",
"insert into mime2ext values ('image/pn', 'png,')",
"insert into mime2ext values ('image/tiff', 'tiff,tif,')",
"insert into mime2ext values ('image/vnd.dwg', '')",
"insert into mime2ext values ('image/vnd.dxf', '')",
"insert into mime2ext values ('image/vnd.fpx', '')",
"insert into mime2ext values ('image/vnd.net-fpx', '')",
"insert into mime2ext values ('image/vnd.svf', '')",
"insert into mime2ext values ('image/x-bm', 'bmp,')",
"insert into mime2ext values ('image/x-cmu-raste', 'ras,')",
"insert into mime2ext values ('image/x-cmu-raster', 'ras,')",
"insert into mime2ext values ('image/x-fit', 'fts,')",
"insert into mime2ext values ('image/x-photo-cd', 'pcd,')",
"insert into mime2ext values ('image/x-png', '')",
"insert into mime2ext values ('image/x-portable-anymap', 'pnm,')",
"insert into mime2ext values ('image/x-portable-bitmap', 'pbm,')",
"insert into mime2ext values ('image/x-portable-graymap', 'pgm,')",
"insert into mime2ext values ('image/x-portable-pixmap', 'ppm,')",
"insert into mime2ext values ('image/x-rgb', 'rgb,')",
"insert into mime2ext values ('image/x-targ', 'tga,')",
"insert into mime2ext values ('image/x-xbitmap', 'xbm,')",
"insert into mime2ext values ('image/x-xpixmap', 'xpm,')",
"insert into mime2ext values ('image/x-xwindowdump', 'xwd,')",
"insert into mime2ext values ('magnus-internal/cgi', 'cgi,')",
"insert into mime2ext values ('magnus-internal/imagemap', 'map,')",
"insert into mime2ext values ('magnus-internal/parsed-html', 'shtml,')",
"insert into mime2ext values ('message/external-body', '')",
"insert into mime2ext values ('message/http', '')",
"insert into mime2ext values ('message/new', 'art,')",
"insert into mime2ext values ('message/partial', '')",
"insert into mime2ext values ('message/rfc82', 'mail,')",
"insert into mime2ext values ('model/iges', '')",
"insert into mime2ext values ('model/mesh', '')",
"insert into mime2ext values ('model/vrml', 'wrl,')",
"insert into mime2ext values ('multipart/alternative', '')",
"insert into mime2ext values ('multipart/appledouble', '')",
"insert into mime2ext values ('multipart/byteranges', '')",
"insert into mime2ext values ('multipart/digest', '')",
"insert into mime2ext values ('multipart/encrypted', '')",
"insert into mime2ext values ('multipart/form-data', '')",
"insert into mime2ext values ('multipart/header-set', '')",
"insert into mime2ext values ('multipart/mixed', '')",
"insert into mime2ext values ('multipart/parallel', '')",
"insert into mime2ext values ('multipart/report', '')",
"insert into mime2ext values ('multipart/signed', '')",
"insert into mime2ext values ('multipart/voice-message', '')",
"insert into mime2ext values ('text/enriched', '')",
"insert into mime2ext values ('text/ftp-dir-listing', '')",
"insert into mime2ext values ('text/html', 'htm,html,shtml,')",
"insert into mime2ext values ('text/plain', 'txt,text,pm,el,c,h,cc,hh,cxx,hxx,f90,')",
"insert into mime2ext values ('text/richtext', 'rtx,')",
"insert into mime2ext values ('text/sgml', '')",
"insert into mime2ext values ('text/tab-separated-values', 'tsv,')",
"insert into mime2ext values ('text/vnd.fmi.flexstor', '')",
"insert into mime2ext values ('text/vnd.latex-z', '')",
"insert into mime2ext values ('text/x-vcard', 'vcf,')",
"insert into mime2ext values ('text/x-po', 'pod,')",
"insert into mime2ext values ('text/x-setext', 'etx,')",
"insert into mime2ext values ('video/mpeg', 'mpeg,mpg,mpe,')",
"insert into mime2ext values ('video/quicktime', 'qt,mov,')",
"insert into mime2ext values ('video/vnd.motorola.video', '')",
"insert into mime2ext values ('video/vnd.motorola.videop', '')",
"insert into mime2ext values ('video/vnd.vivo', '')",
"insert into mime2ext values ('video/x-msvideo', 'avi,')",
"insert into mime2ext values ('video/x-sgi-movie', 'movie,')",
"insert into mime2ext values ('www/unknown', 'ppz,mv,ex1,ex2,ex3,ex4,ex5,ex6,')",
"insert into mime2ext values ('www/unknown1', 'ex7,ex8,ex9,mp3,dat,tmp,wave,')",
"insert into mime2ext values ('www/unknown2', 'sea,tbk,tgz,wks,cab,jbf,qtvr,')",
"insert into mime2ext values ('www/unknown3', 'dbf,cop,moov,')",
"insert into mime2ext values ('x-world/x-vrml', 'wrl,vrz,flr,')"
};

void webbase_create(MYSQL* mysql, const char** schema, int schema_length)
{
  const char** queries;
  int queries_length;

  if(schema) {
    queries = schema;
    queries_length = schema_length;
  } else {
    queries = default_schema;
    queries_length = sizeof(default_schema) / sizeof(char*);
  }
  smysql_queries(mysql, queries, queries_length);
}
