/*
 * Copyright (C) 1997 - 2001 Loic Dachary
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#if HAVE_STRING_H
# include <string.h>
# include <memory.h>
#else
# ifndef HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr (), *strrchr ();
# ifndef HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy ((s), (d), (n))
#  define memmove(d, s, n) bcopy ((s), (d), (n))
# endif
#endif

#include <salloc.h>
#include <urldirname.h>

const char* urldirname(const char* filename)
{
  static char* dir = 0;
  static int dir_size = 0;

  char* last_slash;
  if((last_slash = strrchr(filename, '/'))) {
    int filename_length = strlen(filename);
    if(last_slash - filename == filename_length - 1) {
      return filename;
    } else {
      int dir_length = last_slash - filename + 1;
      static_alloc(&dir, &dir_size, dir_length + 1);
      memcpy(dir, filename, dir_length);
      dir[dir_length] = '\0';
      return dir;
    }
  } else {
    return ".";
  }
}
