/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_DMALLOC_H
#include <dmalloc.h>
#endif /* HAVE_DMALLOC_H */
#include <stdio.h>

#include <sqlutil.h>
#include <webbase_create.h>

static const char* default_schema[] = {
" \n\
create table start ( \n\
  rowid int not null auto_increment, \n\
# \n\
# Crawl data \n\
# \n\
  url text not null, \n\
  url_key char(80) not null default '', \n\
  url_md5 char(32) binary not null default '', \n\
  info set ('sleepy', 'unescape', 'auth', 'nocookie', 'accept', 'heuristics', \n\
            'sticky', 'filter', 'homefree', 'virgin', 'exploring', 'explored', \n\
            'updating', 'in_core', 'allow', 'disallow', 'hook_info'), \n\
  url_max_size smallint default -1, \n\
  size_limit int default 100000, \n\
  min int default -1, \n\
  depth int default 2, \n\
  level int default 1000000, \n\
  timeout smallint default -1, \n\
  loaded_delay smallint default -1, \n\
  modified_delay smallint default -1, \n\
  not_found_delay smallint default -1, \n\
  timeout_delay smallint default -1, \n\
  robot_delay smallint default -1, \n\
  auth varchar(255) binary, \n\
  accept varchar(255) binary, \n\
  filter varchar(255) binary, \n\
  allow varchar(255) binary, \n\
  disallow varchar(255) binary, \n\
  hook_info varchar(255) binary, \n\
  sources set ('all'), \n\
  disabled enum ('yes', 'no') default 'no', \n\
  created datetime, \n\
  modified timestamp, \n\
# \n\
# Internal data \n\
# \n\
  count int default 0, \n\
  delay int default 0, \n\
 \n\
# \n\
# User defined data start, may be removed or enriched \n\
# \n\
  email varchar(255), \n\
  comment varchar(255), \n\
  town varchar(64), \n\
  country varchar(64), \n\
#  target varchar(64), \n\
#  category varchar(32), \n\
#  other_categories varchar(255), \n\
#  title varchar(255), \n\
#  keywords varchar(255), \n\
#  entity varchar(32), \n\
#  last_name varchar(64), \n\
#  first_name varchar(64), \n\
#  street varchar(255), \n\
#  zip_code varchar(16), \n\
#  company varchar(32), \n\
#  telephone varchar(32), \n\
#  fax varchar(32), \n\
# \n\
# User defined data end \n\
# \n\
 \n\
  unique start1 (rowid), \n\
  index start2 (url_key), \n\
  unique start3 (url_md5) \n\
)",

" \n\
create table robots ( \n\
  rowid int not null auto_increment, \n\
  netloc varchar(255) binary not null, \n\
  next_crawl int, \n\
  queue_crawl int, \n\
  allow text, \n\
  disallow text, \n\
 \n\
  unique robot1 (rowid), \n\
  unique robot2 (netloc) \n\
)",

" \n\
create table cookies ( \n\
  netloc varchar(255) binary not null, \n\
  path varchar(255) binary not null, \n\
  cookie_in varchar(255) binary not null, \n\
  cookie_out varchar(255) binary, \n\
#  expires datetime, \n\
 \n\
  unique cookies1 (netloc(122), path(122)) \n\
)",

" \n\
create table start2url ( \n\
  start int not null, \n\
  url int not null, \n\
  level smallint not null default -1, \n\
 \n\
  unique start2url1 (start,url), \n\
  index start2url2 (url) \n\
)",

" \n\
create table url ( \n\
  rowid int not null auto_increment, \n\
  url text not null, \n\
  url_md5 char(32) binary not null default '', \n\
  info set ('frame', 'complete', 'cookie', 'base', 'relative', 'absolute', \n\
            'content', 'location', 'timeout', 'not_modified', 'not_found', 'ok', \n\
	    'error', 'http', 'ftp', 'news', 'cumulmd5', 'extract', 'title', \n\
	    'keywords', 'description', 'reading', 'truncated', 'ftp_dir'), \n\
  code smallint, \n\
  mtime datetime, \n\
  mtime_error datetime, \n\
  tags smallint, \n\
# \n\
# To build this list use schema2list < meta-schema.sql \n\
# Leave 'unknown' in the first position \n\
# Don't forget to remove the comman on the last line. \n\
# \n\
  content_type enum( \n\
    'unknown', \n\
	'application/access', \n\
    'application/activemessage', \n\
    'application/andrew-inset', \n\
    'application/applefile', \n\
    'application/atomicmail', \n\
    'application/cals-1840', \n\
    'application/commonground', \n\
    'application/cybercash', \n\
    'application/dca-rft', \n\
    'application/dec-dx', \n\
    'application/dsptype', \n\
    'application/eshop', \n\
    'application/excel', \n\
	'application/font-tdpfr', \n\
	'application/fractals', \n\
    'application/gzip', \n\
    'application/iges', \n\
	'application/java-archive', \n\
    'application/mac-binhex40', \n\
    'application/macwriteii', \n\
    'application/mathematica', \n\
    'application/msword', \n\
    'application/news-message-id', \n\
    'application/news-transmission', \n\
    'application/octet-stream', \n\
    'application/oda', \n\
    'application/pdf', \n\
    'application/pgp-encrypted', \n\
    'application/pgp-keys', \n\
    'application/pgp-signature', \n\
    'application/postscript', \n\
	'application/powerpoint', \n\
    'application/prs.alvestrand.titrax-sheet', \n\
    'application/remote-printing', \n\
    'application/riscos', \n\
    'application/rtf', \n\
	'application/schedule', \n\
    'application/set-payment', \n\
    'application/set-payment-initiation', \n\
    'application/set-registration', \n\
    'application/set-registration-initiation', \n\
    'application/sgml', \n\
    'application/sgml-open-catalog', \n\
    'application/slate', \n\
    'application/vemmi', \n\
    'application/vnd.businessobjects', \n\
    'application/vnd.enliven', \n\
    'application/vnd.fdf', \n\
    'application/vnd.framemaker', \n\
    'application/vnd.intertrust.digibox', \n\
    'application/vnd.intertrust.nncp', \n\
    'application/vnd.japannet-directory-service', \n\
    'application/vnd.japannet-payment-wakeup', \n\
    'application/vnd.japannet-registration-wakeup', \n\
    'application/vnd.japannet-verification-wakeup', \n\
    'application/vnd.koan', \n\
	'application/vnd.lotus-1-2-3', \n\
	'application/vnd.lotus-approach', \n\
	'application/vnd.lotus-freelance', \n\
	'application/vnd.lotus-organizer', \n\
	'application/vnd.lotus-screencam', \n\
	'application/vnd.lotus-wordpro', \n\
    'application/vnd.meridian-slingshot', \n\
    'application/vnd.mif', \n\
	'application/vnd.ms-access', \n\
    'application/vnd.ms-artgalry', \n\
	'application/vnd.ms-excel', \n\
    'application/vnd.ms-powerpoint', \n\
    'application/vnd.ms-project', \n\
	'application/vnd.ms-schedule', \n\
    'application/vnd.ms-tnef', \n\
    'application/vnd.ms-works', \n\
    'application/vnd.music-niff', \n\
    'application/vnd.noblenet-sealer', \n\
    'application/vnd.rapid', \n\
    'application/vnd.seemail', \n\
    'application/vnd.street-stream', \n\
    'application/vnd.svd', \n\
    'application/vnd.truedoc', \n\
    'application/vnd.xara', \n\
    'application/wita', \n\
    'application/wordperfect', \n\
	'application/wordperfect5.1', \n\
    'application/x-bcpio', \n\
    'application/x-cpio', \n\
    'application/x-csh', \n\
    'application/x-dvi', \n\
	'application/x-freelance', \n\
    'application/x-gtar', \n\
    'application/x-hdf', \n\
	'application/x-javascript', \n\
	'application/x-javascript-config', \n\
    'application/x-latex', \n\
    'application/x-maker', \n\
    'application/x-mif', \n\
    'application/x-netcdf', \n\
	'application/x-ns-proxy-autoconfig', \n\
    'application/x-per', \n\
	'application/x-pkcs7-mime', \n\
	'application/x-pkcs7-signature', \n\
    'application/x-sh', \n\
    'application/x-shar', \n\
	'application/x-stuffit', \n\
    'application/x-sv4cpio', \n\
    'application/x-sv4cr', \n\
    'application/x-tar', \n\
    'application/x-tcl', \n\
    'application/x-tex', \n\
    'application/x-texinfo', \n\
    'application/x-troff', \n\
    'application/x-troff-ma', \n\
    'application/x-troff-me', \n\
    'application/x-troff-ms', \n\
    'application/x-usta', \n\
    'application/x-wais-source', \n\
    'application/x400-bp', \n\
    'application/zcat', \n\
	'application/zip', \n\
    'audio/32kadpcm', \n\
    'audio/basic', \n\
    'audio/vnd.qcelp', \n\
    'audio/x-aiff', \n\
    'audio/x-midi', \n\
    'audio/x-mpeg', \n\
    'audio/x-mpeg-', \n\
    'audio/x-pn-realaudio', \n\
    'audio/x-wav', \n\
    'image/Graphics', \n\
    'image/g3fax', \n\
    'image/gif', \n\
    'image/ief', \n\
    'image/jpe', \n\
    'image/jpeg', \n\
    'image/pn', \n\
    'image/tiff', \n\
    'image/vnd.dwg', \n\
    'image/vnd.dxf', \n\
    'image/vnd.fpx', \n\
    'image/vnd.net-fpx', \n\
    'image/vnd.svf', \n\
    'image/x-bm', \n\
    'image/x-cmu-raste', \n\
    'image/x-cmu-raster', \n\
    'image/x-fit', \n\
	'image/x-photo-cd', \n\
	'image/x-png', \n\
    'image/x-portable-anymap', \n\
    'image/x-portable-bitmap', \n\
    'image/x-portable-graymap', \n\
    'image/x-portable-pixmap', \n\
    'image/x-rgb', \n\
    'image/x-targ', \n\
    'image/x-xbitmap', \n\
    'image/x-xpixmap', \n\
    'image/x-xwindowdump', \n\
    'magnus-internal/cgi', \n\
    'magnus-internal/imagemap', \n\
    'magnus-internal/parsed-html', \n\
    'message/external-body', \n\
    'message/http', \n\
    'message/new', \n\
    'message/partial', \n\
    'message/rfc82', \n\
    'model/iges', \n\
    'model/mesh', \n\
    'model/vrml', \n\
    'multipart/alternative', \n\
    'multipart/appledouble', \n\
    'multipart/byteranges', \n\
    'multipart/digest', \n\
    'multipart/encrypted', \n\
    'multipart/form-data', \n\
    'multipart/header-set', \n\
    'multipart/mixed', \n\
    'multipart/parallel', \n\
    'multipart/report', \n\
    'multipart/signed', \n\
    'multipart/voice-message', \n\
    'text/enriched', \n\
    'text/ftp-dir-listing', \n\
    'text/html', \n\
    'text/plain', \n\
    'text/richtext', \n\
    'text/sgml', \n\
    'text/tab-separated-values', \n\
    'text/vnd.fmi.flexstor', \n\
    'text/vnd.latex-z', \n\
    'text/x-po', \n\
    'text/x-setext', \n\
	'text/x-vcard', \n\
    'video/mpeg', \n\
    'video/quicktime', \n\
    'video/vnd.motorola.video', \n\
    'video/vnd.motorola.videop', \n\
    'video/vnd.vivo', \n\
    'video/x-msvideo', \n\
    'video/x-sgi-movie', \n\
	'www/unknown', \n\
    'x-world/x-vrml' \n\
  ), \n\
  content_length int, \n\
  md5 char(32), \n\
  complete_rowid int not null default 0, \n\
  crawl datetime not null default 0, \n\
  hookid int, \n\
  language enum ('unknown', 'fr', 'uk', 'de', 'it', 'es'), \n\
  extract varchar(255) binary, \n\
  title varchar(255) binary, \n\
 \n\
  unique url1 (rowid), \n\
  unique url3 (url_md5), \n\
  index url4 (complete_rowid), \n\
  index url5 (crawl) \n\
)",

" \n\
create table url_complete ( \n\
  rowid int not null auto_increment, \n\
  keywords varchar(255) binary, \n\
  description varchar(255) binary, \n\
  base_url text, \n\
  relative mediumtext, \n\
  absolute mediumtext, \n\
  location text, \n\
 \n\
  unique urlc1 (rowid) \n\
)",

" \n\
create table mime_restrict ( \n\
  spec char(255) binary not null, \n\
  ext text, \n\
  mime text, \n\
 \n\
  unique mime_restrict1 (spec) \n\
)",

" \n\
create table mime2ext ( \n\
  mime char(32) binary not null, \n\
  ext char(32) binary not null, \n\
 \n\
  unique mime2ext2 (mime), \n\
  index mime2ext1 (ext) \n\
)",

" \n\
create table home_re ( \n\
  netloc char(255) binary not null, \n\
  re char(255), \n\
 \n\
  unique home_re1 (netloc) \n\
)",

" \n\
create table statistics ( \n\
  type char(16) binary not null, \n\
  rank int not null, \n\
  info text, \n\
 \n\
  index statistics1 (type), \n\
  index statistics2 (rank) \n\
)",

" \n\
create table locks ( \n\
  name char(32) not null, \n\
  pid int not null, \n\
 \n\
  unique locks1 (name), \n\
  index locks2 (pid) \n\
)",

"insert into mime2ext values ('application/activemessage', '') \n",
"insert into mime2ext values ('application/access', 'mdb,mda,mde,') \n",
"insert into mime2ext values ('application/andrew-inset', '') \n",
"insert into mime2ext values ('application/applefile', '') \n",
"insert into mime2ext values ('application/atomicmail', '') \n",
"insert into mime2ext values ('application/cals-1840', '') \n",
"insert into mime2ext values ('application/commonground', '') \n",
"insert into mime2ext values ('application/cybercash', '') \n",
"insert into mime2ext values ('application/dca-rft', '') \n",
"insert into mime2ext values ('application/dec-dx', '') \n",
"insert into mime2ext values ('application/dsptype', 'tsp,') \n",
"insert into mime2ext values ('application/eshop', '') \n",
"insert into mime2ext values ('application/excel', 'xls,xlt,xlm,xld,xla,xlc,xlw,xll,') \n",
"insert into mime2ext values ('application/font-tdpfr', 'pfr,') \n",
"insert into mime2ext values ('application/fractals', 'fif,') \n",
"insert into mime2ext values ('application/gzip', 'gz,') \n",
"insert into mime2ext values ('application/iges', '') \n",
"insert into mime2ext values ('application/java-archive', 'jar,') \n",
"insert into mime2ext values ('application/mac-binhex40', 'hqx,') \n",
"insert into mime2ext values ('application/macwriteii', '') \n",
"insert into mime2ext values ('application/mathematica', '') \n",
"insert into mime2ext values ('application/msword', 'doc,') \n",
"insert into mime2ext values ('application/news-message-id', '') \n",
"insert into mime2ext values ('application/news-transmission', '') \n",
"insert into mime2ext values ('application/octet-stream', 'bin,exe,') \n",
"insert into mime2ext values ('application/oda', 'oda,') \n",
"insert into mime2ext values ('application/pdf', 'pdf,') \n",
"insert into mime2ext values ('application/pgp-encrypted', '') \n",
"insert into mime2ext values ('application/pgp-keys', '') \n",
"insert into mime2ext values ('application/pgp-signature', '') \n",
"insert into mime2ext values ('application/postscript', 'ai,eps,ps,') \n",
"insert into mime2ext values ('application/powerpoint', 'ppt,pot,ppa,pps,pwz,') \n",
"insert into mime2ext values ('application/prs.alvestrand.titrax-sheet', '') \n",
"insert into mime2ext values ('application/remote-printing', '') \n",
"insert into mime2ext values ('application/riscos', '') \n",
"insert into mime2ext values ('application/rtf', 'rtf,') \n",
"insert into mime2ext values ('application/schedule', 'scd,sch,sc2,') \n",
"insert into mime2ext values ('application/set-payment', '') \n",
"insert into mime2ext values ('application/set-payment-initiation', '') \n",
"insert into mime2ext values ('application/set-registration', '') \n",
"insert into mime2ext values ('application/set-registration-initiation', '') \n",
"insert into mime2ext values ('application/sgml', '') \n",
"insert into mime2ext values ('application/sgml-open-catalog', '') \n",
"insert into mime2ext values ('application/slate', '') \n",
"insert into mime2ext values ('application/vemmi', '') \n",
"insert into mime2ext values ('application/vnd.businessobjects', '') \n",
"insert into mime2ext values ('application/vnd.enliven', '') \n",
"insert into mime2ext values ('application/vnd.fdf', '') \n",
"insert into mime2ext values ('application/vnd.framemaker', '') \n",
"insert into mime2ext values ('application/vnd.intertrust.digibox', '') \n",
"insert into mime2ext values ('application/vnd.intertrust.nncp', '') \n",
"insert into mime2ext values ('application/vnd.japannet-directory-service', '') \n",
"insert into mime2ext values ('application/vnd.japannet-payment-wakeup', '') \n",
"insert into mime2ext values ('application/vnd.japannet-registration-wakeup', '') \n",
"insert into mime2ext values ('application/vnd.japannet-verification-wakeup', '') \n",
"insert into mime2ext values ('application/vnd.koan', '') \n",
"insert into mime2ext values ('application/vnd.lotus-1-2-3', '123,wk4,wk3,wk1,') \n",
"insert into mime2ext values ('application/vnd.lotus-approach', 'apr,vew,') \n",
"insert into mime2ext values ('application/vnd.lotus-freelance', '') \n",
"insert into mime2ext values ('application/vnd.lotus-organizer', 'or3,or2,org,') \n",
"insert into mime2ext values ('application/vnd.lotus-screencam', 'scm') \n",
"insert into mime2ext values ('application/vnd.lotus-wordpro', 'lwp,sam,') \n",
"insert into mime2ext values ('application/vnd.meridian-slingshot', '') \n",
"insert into mime2ext values ('application/vnd.mif', 'mif,') \n",
"insert into mime2ext values ('application/vnd.ms-access', '') \n",
"insert into mime2ext values ('application/vnd.ms-artgalry', '') \n",
"insert into mime2ext values ('application/vnd.ms-excel', '') \n",
"insert into mime2ext values ('application/vnd.ms-powerpoint', '') \n",
"insert into mime2ext values ('application/vnd.ms-project', '') \n",
"insert into mime2ext values ('application/vnd.ms-schedule', '') \n",
"insert into mime2ext values ('application/vnd.ms-tnef', '') \n",
"insert into mime2ext values ('application/vnd.ms-works', '') \n",
"insert into mime2ext values ('application/vnd.music-niff', '') \n",
"insert into mime2ext values ('application/vnd.noblenet-sealer', '') \n",
"insert into mime2ext values ('application/vnd.rapid', '') \n",
"insert into mime2ext values ('application/vnd.seemail', '') \n",
"insert into mime2ext values ('application/vnd.street-stream', '') \n",
"insert into mime2ext values ('application/vnd.svd', '') \n",
"insert into mime2ext values ('application/vnd.truedoc', '') \n",
"insert into mime2ext values ('application/vnd.xara', '') \n",
"insert into mime2ext values ('application/wita', '') \n",
"insert into mime2ext values ('application/wordperfect', 'wpd,wp6,') \n",
"insert into mime2ext values ('application/wordperfect5.1', '') \n",
"insert into mime2ext values ('application/x-bcpio', 'bcpio,') \n",
"insert into mime2ext values ('application/x-cpio', 'cpio,') \n",
"insert into mime2ext values ('application/x-csh', 'csh,') \n",
"insert into mime2ext values ('application/x-dvi', 'dvi,') \n",
"insert into mime2ext values ('application/x-freelance', 'prz,pre,') \n",
"insert into mime2ext values ('application/x-gtar', 'gtar,') \n",
"insert into mime2ext values ('application/x-hdf', 'hdf,') \n",
"insert into mime2ext values ('application/x-javascript', 'js,mocha,') \n",
"insert into mime2ext values ('application/x-javascript-config', 'jsc,') \n",
"insert into mime2ext values ('application/x-latex', 'latex,') \n",
"insert into mime2ext values ('application/x-maker', 'fm,') \n",
"insert into mime2ext values ('application/x-mif', 'mif,') \n",
"insert into mime2ext values ('application/x-netcdf', 'nc,cdf,') \n",
"insert into mime2ext values ('application/x-ns-proxy-autoconfig', 'pac,') \n",
"insert into mime2ext values ('application/x-per', 'pl,') \n",
"insert into mime2ext values ('application/x-pkcs7-mime', 'p7m,p7c,') \n",
"insert into mime2ext values ('application/x-pkcs7-signature', 'p7s,') \n",
"insert into mime2ext values ('application/x-sh', 'sh,') \n",
"insert into mime2ext values ('application/x-shar', 'shar,') \n",
"insert into mime2ext values ('application/x-stuffit', 'sit,') \n",
"insert into mime2ext values ('application/x-sv4cpio', 'sv4cpio,') \n",
"insert into mime2ext values ('application/x-sv4cr', 'sv4crc,') \n",
"insert into mime2ext values ('application/x-tar', 'tar,') \n",
"insert into mime2ext values ('application/x-tcl', 'tcl,') \n",
"insert into mime2ext values ('application/x-tex', 'tex,') \n",
"insert into mime2ext values ('application/x-texinfo', 'texinfo,texi,') \n",
"insert into mime2ext values ('application/x-troff', 't,tr,roff,') \n",
"insert into mime2ext values ('application/x-troff-ma', 'man,1,2,3,4,5,6,7,8,') \n",
"insert into mime2ext values ('application/x-troff-me', 'me,') \n",
"insert into mime2ext values ('application/x-troff-ms', 'ms,') \n",
"insert into mime2ext values ('application/x-usta', 'ustar,') \n",
"insert into mime2ext values ('application/x-wais-source', 'src,') \n",
"insert into mime2ext values ('application/x400-bp', '') \n",
"insert into mime2ext values ('application/zcat', 'Z,z,') \n",
"insert into mime2ext values ('application/zip', 'zip,') \n",
"insert into mime2ext values ('audio/32kadpcm', '') \n",
"insert into mime2ext values ('audio/basic', 'au,snd,') \n",
"insert into mime2ext values ('audio/vnd.qcelp', '') \n",
"insert into mime2ext values ('audio/x-aiff', 'aif,aiff,aifc,') \n",
"insert into mime2ext values ('audio/x-midi', 'mid,') \n",
"insert into mime2ext values ('audio/x-mpeg', 'mp2,mpa,abs,mpega,') \n",
"insert into mime2ext values ('audio/x-mpeg-', '') \n",
"insert into mime2ext values ('audio/x-pn-realaudio', 'ra,ram,') \n",
"insert into mime2ext values ('audio/x-wav', 'wav,') \n",
"insert into mime2ext values ('image/Graphics', '') \n",
"insert into mime2ext values ('image/g3fax', '') \n",
"insert into mime2ext values ('image/gif', 'gif,') \n",
"insert into mime2ext values ('image/ief', 'ief,') \n",
"insert into mime2ext values ('image/jpe', 'jpeg,jpe,jfif,') \n",
"insert into mime2ext values ('image/jpeg', 'jpg,') \n",
"insert into mime2ext values ('image/pn', 'png,') \n",
"insert into mime2ext values ('image/tiff', 'tiff,tif,') \n",
"insert into mime2ext values ('image/vnd.dwg', '') \n",
"insert into mime2ext values ('image/vnd.dxf', '') \n",
"insert into mime2ext values ('image/vnd.fpx', '') \n",
"insert into mime2ext values ('image/vnd.net-fpx', '') \n",
"insert into mime2ext values ('image/vnd.svf', '') \n",
"insert into mime2ext values ('image/x-bm', 'bmp,') \n",
"insert into mime2ext values ('image/x-cmu-raste', 'ras,') \n",
"insert into mime2ext values ('image/x-cmu-raster', 'ras,') \n",
"insert into mime2ext values ('image/x-fit', 'fts,') \n",
"insert into mime2ext values ('image/x-photo-cd', 'pcd,') \n",
"insert into mime2ext values ('image/x-png', '') \n",
"insert into mime2ext values ('image/x-portable-anymap', 'pnm,') \n",
"insert into mime2ext values ('image/x-portable-bitmap', 'pbm,') \n",
"insert into mime2ext values ('image/x-portable-graymap', 'pgm,') \n",
"insert into mime2ext values ('image/x-portable-pixmap', 'ppm,') \n",
"insert into mime2ext values ('image/x-rgb', 'rgb,') \n",
"insert into mime2ext values ('image/x-targ', 'tga,') \n",
"insert into mime2ext values ('image/x-xbitmap', 'xbm,') \n",
"insert into mime2ext values ('image/x-xpixmap', 'xpm,') \n",
"insert into mime2ext values ('image/x-xwindowdump', 'xwd,') \n",
"insert into mime2ext values ('magnus-internal/cgi', 'cgi,') \n",
"insert into mime2ext values ('magnus-internal/imagemap', 'map,') \n",
"insert into mime2ext values ('magnus-internal/parsed-html', 'shtml,') \n",
"insert into mime2ext values ('message/external-body', '') \n",
"insert into mime2ext values ('message/http', '') \n",
"insert into mime2ext values ('message/new', 'art,') \n",
"insert into mime2ext values ('message/partial', '') \n",
"insert into mime2ext values ('message/rfc82', 'mail,') \n",
"insert into mime2ext values ('model/iges', '') \n",
"insert into mime2ext values ('model/mesh', '') \n",
"insert into mime2ext values ('model/vrml', 'wrl,') \n",
"insert into mime2ext values ('multipart/alternative', '') \n",
"insert into mime2ext values ('multipart/appledouble', '') \n",
"insert into mime2ext values ('multipart/byteranges', '') \n",
"insert into mime2ext values ('multipart/digest', '') \n",
"insert into mime2ext values ('multipart/encrypted', '') \n",
"insert into mime2ext values ('multipart/form-data', '') \n",
"insert into mime2ext values ('multipart/header-set', '') \n",
"insert into mime2ext values ('multipart/mixed', '') \n",
"insert into mime2ext values ('multipart/parallel', '') \n",
"insert into mime2ext values ('multipart/report', '') \n",
"insert into mime2ext values ('multipart/signed', '') \n",
"insert into mime2ext values ('multipart/voice-message', '') \n",
"insert into mime2ext values ('text/enriched', '') \n",
"insert into mime2ext values ('text/ftp-dir-listing', '') \n",
"insert into mime2ext values ('text/html', 'htm,html,shtml,') \n",
"insert into mime2ext values ('text/plain', 'txt,text,pm,el,c,h,cc,hh,cxx,hxx,f90,') \n",
"insert into mime2ext values ('text/richtext', 'rtx,') \n",
"insert into mime2ext values ('text/sgml', '') \n",
"insert into mime2ext values ('text/tab-separated-values', 'tsv,') \n",
"insert into mime2ext values ('text/vnd.fmi.flexstor', '') \n",
"insert into mime2ext values ('text/vnd.latex-z', '') \n",
"insert into mime2ext values ('text/x-vcard', 'vcf,') \n",
"insert into mime2ext values ('text/x-po', 'pod,') \n",
"insert into mime2ext values ('text/x-setext', 'etx,') \n",
"insert into mime2ext values ('video/mpeg', 'mpeg,mpg,mpe,') \n",
"insert into mime2ext values ('video/quicktime', 'qt,mov,') \n",
"insert into mime2ext values ('video/vnd.motorola.video', '') \n",
"insert into mime2ext values ('video/vnd.motorola.videop', '') \n",
"insert into mime2ext values ('video/vnd.vivo', '') \n",
"insert into mime2ext values ('video/x-msvideo', 'avi,') \n",
"insert into mime2ext values ('video/x-sgi-movie', 'movie,') \n",
"insert into mime2ext values ('www/unknown', 'ppz,mv,ex1,ex2,ex3,ex4,ex5,ex6,') \n",
"insert into mime2ext values ('www/unknown1', 'ex7,ex8,ex9,mp3,dat,tmp,wave,') \n",
"insert into mime2ext values ('www/unknown2', 'sea,tbk,tgz,wks,cab,jbf,qtvr,') \n",
"insert into mime2ext values ('www/unknown3', 'dbf,cop,moov,bz2,wdz') \n",
"insert into mime2ext values ('x-world/x-vrml', 'wrl,vrz,flr,') \n"
};

void webbase_create(MYSQL* mysql, const char** schema, int schema_length)
{
  const char** queries;
  int queries_length;

  if(schema) {
    queries = schema;
    queries_length = schema_length;
  } else {
    queries = default_schema;
    queries_length = sizeof(default_schema) / sizeof(char*);
  }
  smysql_queries(mysql, queries, queries_length);
}

void webbase_schema()
{
  unsigned int i;
  for(i = 0; i < sizeof(default_schema) / sizeof(char*); i++)
    printf("%s", default_schema[i]);
}
