/*
 * Copyright (c) 1995,1999 Theo de Raadt.  All rights reserved.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "includes.h"
/* RCSID("$OpenBSD: atomicio.c,v 1.12 2003/07/31 15:50:16 avsm Exp $"); */

#include "atomicio.h"

/*
 * ensure all of data on socket comes through. f==read || f==vwrite
 */
ssize_t
atomicio(f, fd, _s, n)
	ssize_t (*f) (int, void *, size_t);
	int fd;
	void *_s;
	size_t n;
{
	const int pipe_buf_size = 512;
	char *s = _s;
	ssize_t res, pos = 0;
	size_t rq;

	while (n > (size_t)pos) {
		rq = n - pos;
		if ((int)rq > pipe_buf_size) {
			rq = pipe_buf_size;
		}
		res = (f) (fd, s + pos, rq /*n - pos*/);
		switch (res) {
		case -1:
#ifdef EWOULDBLOCK
			if (errno == EINTR || errno == EAGAIN || errno == EWOULDBLOCK) {
#else
			if (errno == EINTR || errno == EAGAIN) {
#endif
				fprintf(stderr, "atomicio: res=%d errno=%d: %s\n", (int)res, errno, strerror(errno));
				continue;
			}
		case 0:
			return (res);
		default:
			/*
			 * we are assuming that 'res' will never be negative here.
			 */ 
			pos += res;
		}
	}
	return (pos);
}
