<?php
/* Intro.
   Copyright (C) 2006, 2007 David Englund.

This file is part of GNU Sovix.

GNU Sovix is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

GNU Sovix is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with GNU Sovix.  If not, see <http://www.gnu.org/licenses/>. */

if ($sovix__format==html) {
  if ($sovix__xhtml==true) {
    if (!empty($sovix__first_line)) echo "$sovix__first_line\n";
    echo "<?xml-stylesheet href=\"#internalStyle\" type=\"text/css\"?>\n"; # http://www.w3.org/TR/xhtml1/#C_14
  }
# <?xml-stylesheet didnt work so we use <link rel="Stylesheet" type="text/css" href="http://www.w3.org/StyleSheets/TR/W3C-REC.css"$sovix__close_tag> with together with other included CSS files:

  if (!empty($$sovix__file__header_before_dtd)) require "$sovix__file__header_before_dtd"; # Needed to import files via XML, eg: <?xml-stylesheet
  echo "$sovix__begin_dtd_tag";

  if (!empty($sovix__file__header_dtd_end)) {echo "\n"; require "$sovix__file__header_dtd_end"; } # Needed to set entities in RDFa, eg: <!ENTITY
  echo ">\n";
  echo "$sovix__begin_html_tag";

  if (!empty($sovix__file__header_html_end)) {echo "\n"; require "$sovix__file__header_html_end";} # Needed to import XML Name Space, eg: xmlns=..., xmlns:dc=...
  echo ">\n"; ?>
  <!-- Header _______________________________________________________________________________ -->
  
  <!-- Spamtrap, do not email or place next line under any other email, its useless then:
    <a href="mailto:<?php echo "$sovix__email_spamtrap"; ?>"><?php echo "$sovix__email_spamtrap"; ?></a>
    <?php
# Intresting information that does not fit into meta tags
 echo "Served to ".$_SERVER["REMOTE_ADDR"]." using ".$_SERVER["HTTP_USER_AGENT"]; ?> -->

<?php echo "  $sovix__head"; ?>
    <title><?php
    if (!empty($sovix__topic)) echo $sovix__topic;
    elseif (!empty($sovix__topic__translated)) echo $sovix__topic__translated;
    else echo basename($sovix__pagename);
    echo " - $sovix__title";
?></title>
  
    <!-- Sovix -->
    <meta http-equiv="Content-Type" content="<?php
if ($sovix__xhtml==true) echo "application/xhtml+xml";
else echo "text/html";
if (substr("$sovix__dtd", 0, 9)=="w3c-html-") echo "; $sovix__charset";  ?>"<?php echo $sovix__close_tag; ?>>
    <meta http-equiv="Content-Script-Type" content="text/javascript"<?php echo $sovix__close_tag; ?>>
<?php if ($sovix__allow_uri_in_meta=="y") echo "    <meta http-equiv=\"PICS-Label\" content='$sovix__meta_pics_label' />\n"; ?>
    <meta name="generator" content="Sovix - http://sovix.org<?php if (!empty($sovix__meta_generator)) echo ", $sovix__meta_generator"; ?>"<?php echo $sovix__close_tag; ?>>
    <meta name="code_language" content="PHP, SQL, JavaScript"<?php echo $sovix__close_tag; ?>><!-- Sovix -->
    <meta name="date" content="<?php echo date("Y-m-d H:i:s") ?>"<?php echo $sovix__close_tag; ?>>
    
    <!-- Custom -->
    <base href="<?php echo "http://" . $_SERVER["SERVER_NAME"]; echo $_SERVER["PHP_SELF"]; ?>"<?php echo $sovix__close_tag; ?>>
    <meta name="DC.date.modified" content="<?php echo date ("Y-m-d H:i:s", filemtime($_SERVER['SCRIPT_FILENAME'])); ?>"<?php echo $sovix__close_tag; ?>>
    <meta http-equiv="Content-MD5" content="<?php echo md5_file($_SERVER['SCRIPT_FILENAME']) ?>"<?php echo $sovix__close_tag; ?>>
<?php
$sovix__meta = array(
  array(
  'meta_type' => "name",
  'meta' => "Author",
  'content' => "$sovix__meta_author",
  'enable' => "",
  ),
  array(
  'meta_type' => "name",
  'meta' => "DC.publisher",
  'content' => "$sovix__meta_publisher",
  'enable' => "",
  ),
  array(
  'meta_type' => "name",
  'meta' => "description",
  'content' => "$sovix__meta_description",
  'enable' => "",
  ),
  array(
  'meta_type' => "name",
  'meta' => "distribution",
  'content' => "$sovix__meta_distribution",
  'enable' => "",
  ),
 array(
  'meta_type' => "name",
  'meta' => "geo.position",
  'content' => "$sovix__meta_geo__position", # A2B-enable website
  'enable' => "",
  ),
 array(
  'meta_type' => "name",
  'meta' => "geo.placename",
  'content' => "$sovix__meta_geo__placename",
  'enable' => "",
  ),
 array(
  'meta_type' => "name",
  'meta' => "geo.region",
  'content' => "$sovix__iso_3166_1-$sovix__region_code",
  'enable' => "$sovix__meta_geo__region__enable",
  ),
 array(
  'meta_type' => "name",
  'meta' => "keywords",
  'content' => "$sovix__meta_keywords",
  'enable' => "",
  ),
  array(
  'meta_type' => "name",
  'meta' => "MSSmartTagsPreventParsing",
  'content' => "$sovix__meta_mssmarttagspreventparsing",
  'enable' => "",
  ),
  array(
  'meta_type' => "name",
  'meta' => "security",
  'content' => "$sovix__meta_security",
  'enable' => "",
  ),
  array(
  'meta_type' => "name",
  'meta' => "version",
  'content' => "$sovix__meta_site_version",
  'enable' => "",
  ),
);
 

for($sovix__i = 0; $sovix__i < count($sovix__meta); $sovix__i++){ 
  if ("{$sovix__meta[$sovix__i]['content']}"!="" && "{$sovix__meta[$sovix__i]['enable']}"=="y" || "{$sovix__meta[$sovix__i]['content']}"!="" && "{$sovix__meta[$sovix__i]['enable']}"=="") {
 echo "    <meta ".
"{$sovix__meta[$sovix__i]['meta_type']}"."=\"".
"{$sovix__meta[$sovix__i]['meta']}"."\" content=\"".
"{$sovix__meta[$sovix__i]['content']}".
"\"$sovix__close_tag>\n";
  }
}
if ($sovix__browser_interface=="GUI") echo "    <link rel=\"icon\" type=\"image/png\" href=\"$sovix__file__icon\"$sovix__close_tag>"; ?>

  <?php if(!empty($sovix__file__header_head)) { echo "<!-- Custom head section -->"; require "$sovix__file__header_head"; }
 echo "  <script type=\"text/javascript\" src=\"$sovix__url__websrc/js/select.js\"></script>\n";
if ($sovix__use_w3c_recommended_css_file=="y") echo "    <link rel=\"Stylesheet\" type=\"text/css\" href=\"$sovix__url__websrc/css/W3C-REC.css\"$sovix__close_tag>\n"; # To be avalible for intranets so copy from http://www.w3.org/StyleSheets/TR/W3C-REC.css
echo "    <link rel=\"stylesheet\" type=\"text/css\" media=\"";
if (!empty($_SESSION['sovix__media'])) echo $_SESSION['sovix__media'];
elseif (!empty($sovix__media)) echo $sovix__media;
else echo "all";
echo "\" href=\"$sovix__url__websrc/css/main.css\"$sovix__close_tag>\n";
// echo "    <link rel=\"alternate\" type=\"application/rss+xml\" title=\"$sovix__title RSS\" href=\"http://" . $_SERVER["SERVER_NAME"]."/rss.xml\"$sovix__close_tag>";
?>

    <style type="text/css"<?php if (substr("$sovix__dtd", 0, 10)=="w3c-xhtml-" && substr("$sovix__dtd", 0, 13)!="w3c-xhtml-1.1") echo " id=\"internalStyle\""; # http://www.w3.org/TR/xhtml1/#C_14
echo ">\n";
 if ($sovix__xhtml==true) echo "      <!--/*--><![CDATA[/*><!--*/"; # If the same file may be served or processed as both XML (application/xhtml+xml) and HTML compatible text/html to target Internet Explorer 6 and as many other historic and non-conforming browsers as possible, constructs as complex as the following may be necessary --http://www.hixie.ch/advocacy/xhtml
 echo "\n\n";

 require_once "$sovix__directory__src/themes.inc";
 echo "        # Base\n";
 require_once "$sovix__directory__src/css/base.css.inc";
 echo "        # Special\n";
 require_once "$sovix__directory__src/css/special.css.inc";
 echo "        # Header and footer\n";
 require_once "$sovix__directory__src/css/header-footer.css.inc";
 echo "        # Generated user defined CSS\n";
 require_once "$sovix__directory__src/defcss.inc";
 require_once "$sovix__directory__src/css/menu-bar.css.inc";
 echo "        # General\n";
 require_once "$sovix__directory__src/css/general.css.inc";

 if ($sovix__xhtml==true) echo "      /*]]>*/-->\n";
?>
    </style>
    <script type="text/javascript">function getSelect(s) {return s.options[s.selectedIndex].value}</script>
  </head>
  <body<?php if (!empty($sovix__file__header_bodytag_end)) { echo " "; require "$sovix__file__header_bodytag_end"; } ?>>
<?php } ?>
