<?php
/* Arrays.
   Copyright (C) 2006, 2007, 2008 David Englund.

This file is part of GNU Sovix.

GNU Sovix is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

GNU Sovix is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with GNU Sovix.  If not, see <http://www.gnu.org/licenses/>. */

$sovix__array__commands = array( /* separator: current_path, current_file, /path/, space. directshow: input, split, self */
 array(
    'sovix__array__commands__command' => "?",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "split",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Lists command possibilities.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "character-encoding-ibm864",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=IBM864",
    'sovix__array__commands__description' => "Arabic (IBM-864) as character encoding in document type. DOS code page for Arabic, cp864.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-6",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-6",
    'sovix__array__commands__description' => "Arabic (ISO-8859-6) as character encoding in document type. ISO Latin/Arabic.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-macarabic",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-MacArabic",
    'sovix__array__commands__description' => "Arabic (MacArabic) as character encoding in document type. Macintosh encoding for Arabic, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-windows-1256",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=windows-1256",
    'sovix__array__commands__description' => "Arabic (Windows-1256) as character encoding in document type. Windows Arabic.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-armscii-8",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=armscii-8",
    'sovix__array__commands__description' => "Armenian (ARMSCII-8) as character encoding in document type. &#8220;Armenian ASCII&#8221;, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-13",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-13",
    'sovix__array__commands__description' => "Baltic (ISO-8859-13) as character encoding in document type. ISO Latin 7, &#8220;Baltic Rim&#8221;.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-4",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-4",
    'sovix__array__commands__description' => "Baltic (ISO-8859-4) as character encoding in document type. ISO Latin 4, &#8220;North European&#8221;.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-windows-1257",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=windows-1257",
    'sovix__array__commands__description' => "Baltic (Windows-1257) as character encoding in document type. Windows Baltic.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-14",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-14",
    'sovix__array__commands__description' => "Celtic (ISO-8859-14) as character encoding in document type. ISO Latin 8; no wide support.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-ibm852",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=IBM852",
    'sovix__array__commands__description' => "Central European (IBM-852) as character encoding in document type. DOS code page for Central European, cp852.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-2",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-2",
    'sovix__array__commands__description' => "Central European (ISO-8859-2) as character encoding in document type. ISO Latin 2.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-ce",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-ce",
    'sovix__array__commands__description' => "Central European (MacCE) as character encoding in document type. Macintosh encoding for Central European, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-windows-1250",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=windows-1250",
    'sovix__array__commands__description' => "Central European (Windows-1250) as character encoding in document type. Windows Latin 2.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-gb18030",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=gb18030",
    'sovix__array__commands__description' => "Chinese Simplified (GB18030) as character encoding in document type. Newer encoding for Chinese in Simplified writing system.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-gb2312",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=gb2312",
    'sovix__array__commands__description' => "Chinese Simplified (GB2312) as character encoding in document type. Older encoding for Chinese in Simplified writing system.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-gbk",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-gbk",
    'sovix__array__commands__description' => "Chinese Simplified (GBK) as character encoding in document type. An extension of GB2312 (MIME name: GBK).",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-hz-gb-2312",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=HZ-GB-2312",
    'sovix__array__commands__description' => "Chinese Simplified (HZ) as character encoding in document type. An encoding designed for E-mail.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-2022-cn",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-2022-CN",
    'sovix__array__commands__description' => "Chinese Simplified (ISO-2022-CN) as character encoding in document type. ISO 2022 based encoding for Chinese.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-big5",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=Big5",
    'sovix__array__commands__description' => "Chinese Traditional (Big5) as character encoding in document type. Chinese encoding, used especially in Taiwan.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-big5-hkscs",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=Big5-HKSCS",
    'sovix__array__commands__description' => "Chinese Traditional (Big5-HKSCS) as character encoding in document type. Chinese encoding, used especially in Hong Kong.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-euc-tw",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-euc-tw",
    'sovix__array__commands__description' => "Chinese Traditional (EUC-TW) as character encoding in document type. Chinese encoding, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-croatian",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-croatian",
    'sovix__array__commands__description' => "Croatian (MacCroatian) as character encoding in document type. Macintosh encoding for Croatian, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-ibm855",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=IBM855",
    'sovix__array__commands__description' => "Cyrillic (IBM-855) as character encoding in document type. DOS code page for Cyrillic, cp855.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-5",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-5",
    'sovix__array__commands__description' => "Cyrillic (ISO-8859-5) as character encoding in document type. ISO Latin/Cyrillic.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-ir-111",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-IR-111",
    'sovix__array__commands__description' => "Cyrillic (ISO-IR-111) as character encoding in document type. ECMA Cyrillic.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-koi8-r",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=KOI8-R",
    'sovix__array__commands__description' => "Cyrillic (KOI8-R) as character encoding in document type. Russian version of KOI8.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-cyrillic",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-cyrillic",
    'sovix__array__commands__description' => "Cyrillic (MacCyrillic) as character encoding in document type. Macintosh encoding for Cyrillic, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-windows-1251",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=windows-1251",
    'sovix__array__commands__description' => "Cyrillic (Windows-1251) as character encoding in document type. Windows Cyrillic.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-ibm866",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=IBM866",
    'sovix__array__commands__description' => "Cyrillic/Russian (CP-866) as character encoding in document type. DOS code page for Russian.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-koi8-u",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=KOI8-U",
    'sovix__array__commands__description' => "Cyrillic/Ukrainian (KOI8-U) as character encoding in document type. Ukrainian version of KOI8.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-ukrainian",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-ukrainian",
    'sovix__array__commands__description' => "Cyrillic/Ukrainian (MacUkrainian) as character encoding in document type. Macintosh encoding for Ukrainian.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-farsi",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-farsi",
    'sovix__array__commands__description' => "Farsi (MacFarsi) as character encoding in document type. Macintosh encoding for Farsi (Persian), unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-geostd8",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=GEOSTD8",
    'sovix__array__commands__description' => "Georgian (GEOSTD8) as character encoding in document type. Encoding for the Georgian language, unregistered",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-7",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-7",
    'sovix__array__commands__description' => "Greek (ISO-8859-7) as character encoding in document type. ISO Latin/Greek.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-greek",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-greek",
    'sovix__array__commands__description' => "Greek (MacGreek) as character encoding in document type. Macintosh encoding for Greek, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-windows-1253",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=windows-1253",
    'sovix__array__commands__description' => "Greek (Windows-1253) as character encoding in document type. Windows Greek.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-gujarati",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-gujarati",
    'sovix__array__commands__description' => "Gujarati (MacGujarati) as character encoding in document type. Macintosh encoding for Gujarati, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-gurmukhi",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-gurmukhi",
    'sovix__array__commands__description' => "Gurmukhi (MacGurmukhi) as character encoding in document type. Macintosh encoding for Gurmukhi, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-ibm862",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=IBM862",
    'sovix__array__commands__description' => "Hebrew (IBM-862) as character encoding in document type. DOS code page for Hebrew, cp862.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-8-i",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-8-I",
    'sovix__array__commands__description' => "Hebrew (ISO-8859-8-I) as character encoding in document type. ISO-8859-8 (ISO Latin/Hebrew) in logical order.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-hebrew",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-hebrew",
    'sovix__array__commands__description' => "Hebrew (MacHebrew) as character encoding in document type. Macintosh encoding for Hebrew, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-windows-1255",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=windows-1255",
    'sovix__array__commands__description' => "Hebrew (Windows-1255) as character encoding in document type. Windows Hebrew.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-devanagari",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-devanagari",
    'sovix__array__commands__description' => "Hindi (MacDevanagari) as character encoding in document type. Macintosh encoding for Devanagari, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-icelandic",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-icelandic",
    'sovix__array__commands__description' => "Icelandic (MacIcelandic) as character encoding in document type. Macintosh encoding for Icelandic, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-euc-jp",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=EUC-JP",
    'sovix__array__commands__description' => "Japanese (EUC-JP) as character encoding in document type. Common Japanese encoding.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-2022-jp",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-2022-JP",
    'sovix__array__commands__description' => "Japanese (ISO-2022-JP) as character encoding in document type. Another common Japanese encoding.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-shift_jis",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=Shift_JIS",
    'sovix__array__commands__description' => "Japanese (Shift_JIS) as character encoding in document type. Yet another common Japanese encoding.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-euc-kr",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=EUC-KR",
    'sovix__array__commands__description' => "Korean (EUC-KR) as character encoding in document type. Common Korean encoding.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-10",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-10",
    'sovix__array__commands__description' => "Nordic (ISO-8859-10) as character encoding in document type. ISO Latin 6, &#8220;Nordic&#8221; (Sámi etc.); no wide support.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-16",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-16",
    'sovix__array__commands__description' => "Romanian (ISO-8859-16) as character encoding in document type. ISO Latin 10; no wide support.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-romanian",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-romanian",
    'sovix__array__commands__description' => "Romanian (MacRomanian) as character encoding in document type. Macintosh encoding for Romanian, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-3",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-3",
    'sovix__array__commands__description' => "South European (ISO-8859-3) as character encoding in document type. ISO Latin 3, for Maltese and Esperanto; no wide support.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-11",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-11",
    'sovix__array__commands__description' => "Thai (ISO-8859-11) as character encoding in document type. ISO Latin/Thai.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-tis-620",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=TIS-620",
    'sovix__array__commands__description' => "Thai (TIS-620) as character encoding in document type. Encoding for Thai, national standard.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-windows-874",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=windows-874",
    'sovix__array__commands__description' => "Thai (Windows-874) as character encoding in document type. Windows Thai.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-ibm857",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=IBM857",
    'sovix__array__commands__description' => "Turkish (IBM-857) as character encoding in document type. DOS code page for Turkish, cp857.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-9",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-9",
    'sovix__array__commands__description' => "Turkish (ISO-8859-9) as character encoding in document type. ISO Latin 5.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-turkish",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-turkish",
    'sovix__array__commands__description' => "Turkish (MacTurkish) as character encoding in document type. Macintosh encoding for Turkish, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-windows-1254",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=windows-1254",
    'sovix__array__commands__description' => "Turkish (Windows-1254) as character encoding in document type. Windows Turkish.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-utf-16be",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=UTF-16BE",
    'sovix__array__commands__description' => "Unicode (UTF-16 Big Endian) as character encoding in document type. UTF-16 Big Endian (high byte first).",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-utf-16le",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=UTF-16LE",
    'sovix__array__commands__description' => "Unicode (UTF-16 Little Endian) as character encoding in document type. UTF-16 Little Endian (low byte first).",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-utf-16",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=UTF-16",
    'sovix__array__commands__description' => "Unicode (UTF-16) as character encoding in document type. UTF-16, with endianness to be inferred.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-utf-32be",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=UTF-32BE",
    'sovix__array__commands__description' => "Unicode (UTF-32 Big Endian) as character encoding in document type. UTF-32 Big Endian.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-utf-32le",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=UTF-32LE",
    'sovix__array__commands__description' => "Unicode (UTF-32 Little Endian) as character encoding in document type. UTF-32 Little Endian.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-utf-32",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=UTF-32",
    'sovix__array__commands__description' => "Unicode (UTF-32) as character encoding in document type. UTF-32, with endianness to be inferred.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-utf-8",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=UTF-8",
    'sovix__array__commands__description' => "Unicode (UTF-8) as character encoding in document type. UTF-8, the preferred Unicode encoding on the Internet.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-user-defined",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-user-defined",
    'sovix__array__commands__description' => "User Defined:: Unspecified encoding, usually for use with specific font.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-ibm850",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=IBM850",
    'sovix__array__commands__description' => "Western (IBM-850) as character encoding in document type. DOS code page for West European languages, cp850.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-1",
    'sovix__array__commands__description' => "Western (ISO-8859-1) as character encoding in document type. ISO Latin 1, the default encoding.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-iso-8859-15",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=ISO-8859-15",
    'sovix__array__commands__description' => "Western (ISO-8859-15) as character encoding in document type. ISO Latin 9, with euro sign, not widely supported.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-mac-roman",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-mac-roman",
    'sovix__array__commands__description' => "Western (MacRoman) as character encoding in document type. Macintosh encoding for Western European, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-windows-1252",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=windows-1252",
    'sovix__array__commands__description' => "Western (Windows-1252) as character encoding in document type. Windows Latin 1.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-viet-tcvn5712",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-viet-tcvn5712",
    'sovix__array__commands__description' => "Vietnamese (TCVN) as character encoding in document type. TCVN 5712, VISCII-2, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-windows-1258",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=windows-1258",
    'sovix__array__commands__description' => "Vietnamese (Windows-1258) as character encoding in document type. Windows Vietnamese.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-viscii",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=VISCII",
    'sovix__array__commands__description' => "Vietnamese (VISCII) as character encoding in document type. &#8220;Vietnamese extension to ASCII&#8221;.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "character-encoding-x-viet-vps",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?charset=x-viet-vps",
    'sovix__array__commands__description' => "Vietnamese (VPS) as character encoding in document type. VPS, unregistered.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
     ),
 array(
    'sovix__array__commands__command' => "client-http-accept",
    'sovix__array__commands__execute' => $_SERVER['HTTP_ACCEPT'],
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "input",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Shows which document types, images etc that is accepted for the webbrowser.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "client-http-accept-charset",
    'sovix__array__commands__execute' => $_SERVER['HTTP_ACCEPT_CHARSET'],
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "input",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Shows which character encoding that is accepted for the webbrowser.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "client-http-accept-language",
    'sovix__array__commands__execute' => $_SERVER['HTTP_ACCEPT_LANGUAGE'],
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "input",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Shows which language that is accepted for the web server.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "client-http-user-agent",
    'sovix__array__commands__execute' => $_SERVER['HTTP_USER_AGENT'],
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "input",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Shows the HTTP User Agent of the webbrowser.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "client-remote-ip",
    'sovix__array__commands__execute' => $_SERVER['REMOTE_ADDR'],
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "input",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Shows the remote IP address from which the user is viewing the current page.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "copy-file",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_path", # can be both a file or a directory
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Copy file to newname. Both args must be strings.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => $_SESSION['sovix__user']=="root",
    ),
 array(
    'sovix__array__commands__command' => "copying",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__url__sovix/COPYING",
    'sovix__array__commands__description' => "Reads copying conditions for Sovix.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 /* array(
    'sovix__array__commands__command' => "customize",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__directory__src/Customize",
    'sovix__array__commands__description' => "Loads a file to customize accessibility in Sovix.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),*/
array(
    'sovix__array__commands__command' => "delete-directory",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_path",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Remove DIRECTORY.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => $_SESSION['sovix__user']=="root",
    ),
 array(
    'sovix__array__commands__command' => "delete-file",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_file",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Delete FILE.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => $_SESSION['sovix__user']=="root",
    ),
 array(
    'sovix__array__commands__command' => "describe-function",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "split",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Display the full documentation of FUNCTION (a symbol).",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "describe-variable",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "split",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Display the full documentation of VARIABLE (a symbol).<br />
Returns the documentation as a string, also.<br />
If VARIABLE has a buffer-local value in BUFFER (default to the current buffer),<br />
it is displayed along with the global value.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "download-file",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_file",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__url__websrc/Download_file.php?sovix__directory__src=$sovix__directory__src&sovix__directory__dotsovix=$sovix__directory__dotsovix&sovix__2=$sovix__2",
    'sovix__array__commands__description' => "Download FILE.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-2.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-2.0",
    'sovix__array__commands__description' => "Use HTML 2.0 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-2.0-level-1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-2.0-level-1",
    'sovix__array__commands__description' => "Use HTML 2.0 Level 1 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-2.0-level-2",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-2.0-level-2",
    'sovix__array__commands__description' => "Use HTML 2.0 Level 2 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-2.0-strict",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-2.0-strict",
    'sovix__array__commands__description' => "Use HTML 2.0 Strict as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-2.0-strict-level-1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-2.0-strict-level-1",
    'sovix__array__commands__description' => "Use HTML 2.0 Strict Level 1 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-2.0-strict-level-2",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-2.0-strict-level-2",
    'sovix__array__commands__description' => "Use HTML 2.0 Strict Level 2 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-3.2",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-3.2",
    'sovix__array__commands__description' => "Use HTML 3.2 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-3.2-final",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-3.2-final",
    'sovix__array__commands__description' => "Use HTML 3.2 Final as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-4.0-transitional",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-4.0",
    'sovix__array__commands__description' => "Use HTML 4.0 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-4.0-transitional-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-4.0-without-system-identifier",
    'sovix__array__commands__description' => "Use HTML 4.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-4.0-strict",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-4.0-strict",
    'sovix__array__commands__description' => "Use HTML 4.0 Strict as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-4.0-strict-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-4.0-strict-without-system-identifier",
    'sovix__array__commands__description' => "Use HTML 4.0 Strict without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-4.0-frameset",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-4.0-frameset",
    'sovix__array__commands__description' => "Use HTML 4.0 Framset as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-4.0-frameset-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-4.0-frameset-without-system-identifier",
    'sovix__array__commands__description' => "Use HTML 4.0 Framset without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-4.01-transitional",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-4.01",
    'sovix__array__commands__description' => "Use HTML 4.01 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-4.01-transitional-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-4.01-without-system-identifier",
    'sovix__array__commands__description' => "Use HTML 4.01 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-4.01-strict",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-4.01-strict",
    'sovix__array__commands__description' => "Use HTML 4.01 Strict as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-4.01-strict-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-4.01-strict-without-system-identifier",
    'sovix__array__commands__description' => "Use HTML 4.01 Strict without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-4.01-frameset",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-4.01-frameset",
    'sovix__array__commands__description' => "Use HTML 4.01 Framset as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-html-4.01-frameset-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=html-4.01-frameset-without-system-identifier",
    'sovix__array__commands__description' => "Use HTML 4.01 Framset without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-mathml-1.01",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=mathml-1.01",
    'sovix__array__commands__description' => "Use MathMl 1.01 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-mathml-1.01-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=mathml-1.01-without-system-identifierx",
    'sovix__array__commands__description' => "Use MathMl 1.01 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-mathml-2.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=mathml-2.0",
    'sovix__array__commands__description' => "Use MathMl 2.0 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-mathml-2.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=mathml-2.0-without-system-identifier",
    'sovix__array__commands__description' => "Use MathMl 2.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-smil-1.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=smil-1.0",
    'sovix__array__commands__description' => "Use SMIL 1.0 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-smil-1.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=smil-1.0-without-system-identifier",
    'sovix__array__commands__description' => "Use SMIL 1.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-smil-2.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=smil-2.0",
    'sovix__array__commands__description' => "Use SMIL 2.0 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-smil-2.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=smil-2.0-without-system-identifier",
    'sovix__array__commands__description' => "Use SMIL 2.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-svg-1.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=svg-1.0",
    'sovix__array__commands__description' => "Use SVG 1.0 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-svg-1.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=svg-1.0-without-system-identifier",
    'sovix__array__commands__description' => "Use SVG 1.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-svg-1.1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=svg-1.1",
    'sovix__array__commands__description' => "Use SVG 1.1 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-svg-1.1-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=svg-1.1-without-system-identifier",
    'sovix__array__commands__description' => "Use SVG 1.1 without system identifier as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-svg-1.1-modlular-framework",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=svg-1.1",
    'sovix__array__commands__description' => "Use SVG 1.1 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-svg-1.1-modlular-framework-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=svg-1.1-without-system-identifier",
    'sovix__array__commands__description' => "Use SVG 1.1 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-svg-1.1-tiny",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=svg-1.1-tiny",
    'sovix__array__commands__description' => "Use SVG 1.1 Tiny as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-svg-1.1-tiny-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=svg-1.1-tiny-without-system-identifier",
    'sovix__array__commands__description' => "Use SVG 1.1 Tiny without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-svg-1.1-basic",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=svg-1.1-basic",
    'sovix__array__commands__description' => "Use SVG 1.1 Basic as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-svg-1.1-basic-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=svg-1.1-basic-without-system-identifier",
    'sovix__array__commands__description' => "Use SVG 1.1 Basic without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-plus-rdfa-1.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-plus-rdfa-1.0",
    'sovix__array__commands__description' => "Use XHTML plus RDFa 1.0 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-plus-rdfa-1.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-plus-rdfa-1.0-without-system-identifier",
    'sovix__array__commands__description' => "Use XHTML plus RDFa 1.0 without system identifier as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-basic-1.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-basic-1.0",
    'sovix__array__commands__description' => "Use XHTML Basic 1.0 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-basic-1.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-basic-1.0-without-system-identifier",
    'sovix__array__commands__description' => "Use XHTML Basic 1.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-basic-1.1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-basic-1.1",
    'sovix__array__commands__description' => "Use XHTML Basic 1.1 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-basic-1.1-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-basic-1.1-without-system-identifier",
    'sovix__array__commands__description' => "Use XHTML Basic 1.1 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-print-1.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-print-1.0",
    'sovix__array__commands__description' => "Use XHTML-Print 1.0 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-print-1.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-print-1.0-without-system-identifier",
    'sovix__array__commands__description' => "Use XHTML-Print 1.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.0-strict",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.0-strict",
    'sovix__array__commands__description' => "Use XHTML 1.0 Strict as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.0-strict-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.0-strict-without-system-identifier",
    'sovix__array__commands__description' => "Use XHTML 1.0 Strict without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.0-transitional",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.0-transitional",
    'sovix__array__commands__description' => "Use XHTML 1.0 Transitional as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.0-transitional-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.0-transitional-without-system-identifier",
    'sovix__array__commands__description' => "Use XHTML 1.0 Transitional without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.0-frameset",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.0-frameset",
    'sovix__array__commands__description' => "Use XHTML 1.0 Framset as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.0-frameset-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.0-frameset-without-system-identifier",
    'sovix__array__commands__description' => "Use XHTML 1.0 Framset without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.1",
    'sovix__array__commands__description' => "Use XHTML 1.1 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.1-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.1-without-system-identifier",
    'sovix__array__commands__description' => "Use XHTML 1.1 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.1-plus-mathml-2.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.1-plus-mathml-2.0",
    'sovix__array__commands__description' => "Use XHTML 1.1 plus MathMl 2.0 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.1-plus-mathml-2.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.1-plus-mathml-2.0-without-system-identifier",
    'sovix__array__commands__description' => "Use XHTML 1.1 plus MathMl 2.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.1-plus-mathml-2.0-plus-svg-1.1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.1-plus-mathml-2.0-plus-svg-1.1",
    'sovix__array__commands__description' => "Use XHTML 1.1 plus MathMl 2.0 plus SVG 1.1 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.1-plus-mathml-2.0-plus-svg-1.1-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.1-plus-mathml-2.0-plus-svg-1.1-without-system-identifier",
    'sovix__array__commands__description' => "Use XHTML 1.1 plus MathMl 2.0 plus SVG 1.1 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.1-plus-mathml-2.0-plus-svg-1.1-using-svg-as-the-host",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.1-plus-mathml-2.0-plus-svg-1.1-using-svg-as-the-host",
    'sovix__array__commands__description' => "Use XHTML 1.1 plus MathMl 2.0 plus SVG 1.1 (using the SVG as the host) as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-1.1-plus-mathml-2.0-plus-svg-1.1-using-svg-as-the-host-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-1.1-plus-mathml-2.0-plus-svg-1.1-using-svg-as-the-host-without-system-identifier",
    'sovix__array__commands__description' => "Use XHTML 1.1 plus MathMl 2.0 plus SVG 1.1 (using the SVG as the host) without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-2.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-2.0",
    'sovix__array__commands__description' => "Use XHTML 2.0 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xhtml-2.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xhtml-2.0-without-system-identifier",
    'sovix__array__commands__description' => "Use XHTML 2.0 without system identifier as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-xhtml-iso/iec-15445:1999",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=dtd-xhtml-iso-iec-15445-1999",
    'sovix__array__commands__description' => "Use ISO/IEC 15445:1999 (\"ISO HTML\") as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-xhtml-iso/iec-15445:1999-short-form",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=dtd-xhtml-iso-iec-15445-1999-short-form",
    'sovix__array__commands__description' => "Use short form of ISO/IEC 15445:1999 (\"ISO HTML\") as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-xhtml-iso/iec-15445:2000",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=dtd-xhtml-iso-iec-15445-2000",
    'sovix__array__commands__description' => "Use ISO/IEC 15445:2000 (\"ISO HTML\") as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-xhtml-iso/iec-15445:2000-short-form",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=dtd-xhtml-iso-iec-15445-2000-short-form",
    'sovix__array__commands__description' => "Use short form of ISO/IEC 15445:2000 (\"ISO HTML\") as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xml-specification-v2.1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xml-specification-v2.1",
    'sovix__array__commands__description' => "Use XML Specification V2.1 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "dtd-w3c-xml-specification-v2.1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?dtd=xml-specification-v2.1",
    'sovix__array__commands__description' => "Use XML Specification V2.1 as DTD.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "extensions",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Lists installed Sovix extension applications.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "file-get-contents",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_file",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Show content of FILENAME.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => isset($_SESSION['sovix__user']),
    ),
 /* array(
    'sovix__array__commands__command' => "faq",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__url__sovix/FAQ.html",
    'sovix__array__commands__description' => "",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),*/
 array(
    'sovix__array__commands__command' => "file-require",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_path",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Frame FILENAME.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => isset($_SESSION['sovix__user']),
    ),
 array(
    'sovix__array__commands__command' => "format-txt",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?format=txt&sovix__directory__dotsovix=$sovix__directory__dotsovix",
    'sovix__array__commands__description' => "Shows Table Of Content only.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "fullscreen",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?screen_mode=fullscreen",
    'sovix__array__commands__description' => "Show full screen in the web browser.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "fit-in-window",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?class_toc-width=100%",
    'sovix__array__commands__description' => "Maximum with of TOC.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "footer",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://".$_SERVER['SERVER_NAME']."$sovix__2#footer",
    'sovix__array__commands__description' => "Go to end of page.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 /*
 array(
    'sovix__array__commands__command' => "server-hits",
    'sovix__array__commands__execute' => "$hits uniqe hits",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "input",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Shows the HTTP User Agent of the webbrowser.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 */
 array(
    'sovix__array__commands__command' => "server-hits-uniqe",
    'sovix__array__commands__execute' => "$hits uniqe hits",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "input",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Shows the HTTP User Agent of the webbrowser.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),


 array(
    'sovix__array__commands__command' => "html-entities",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__url__websrc/HTML_entities.php?sovix__directory__src=$sovix__directory__src&sovix__directory__dotsovix=$sovix__directory__dotsovix&sovix__2=$sovix__2",
    'sovix__array__commands__description' => "Lists HTML entities.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),


 array(
    'sovix__array__commands__command' => "identify",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_file",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Identify various properties of FILENAME.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "insert-file",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_path",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Insert contents of file FILENAME into buffer after point.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => isset($_SESSION['sovix__user']),
    ),
 array(
    'sovix__array__commands__command' => "make-wiki",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "/Main/",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Insert contents of file FILENAME in /Main/ into buffer after point.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => isset($_SESSION['sovix__user']),
    ),
 array(
    'sovix__array__commands__command' => "known-problems",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__directory__src/help.php?sovix__directory__src=$sovix__directory__src&sovix__directory__dotsovix=$sovix__directory__dotsovix&url=$sovix__url__etc/PROBLEMS&task=read-pre",
    'sovix__array__commands__description' => "Describes known problems from the file PROBLEMS.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "login",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__url__login?sovix__directory__src=$sovix__directory__src&sovix__directory__dotsovix=$sovix__directory__dotsovix&query=$sovix__2",
    'sovix__array__commands__description' => "",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "logout",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__url__websrc/Login.php?sovix__directory__src=$sovix__directory__src&sovix__directory__dotsovix=$sovix__directory__dotsovix&query=$sovix__2&action=logout",
    'sovix__array__commands__description' => "Logout by go to the Login page with a logout variable.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => isset($_SESSION['sovix__user']),
    ),
 /* array(
    'sovix__array__commands__command' => "manual",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "split",
    'sovix__array__commands__goto' => "$sovix__url__sovix/Manual.php",
    'sovix__array__commands__description' => "",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),*/
 array(
    'sovix__array__commands__command' => "make-directory",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_path",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Make directories.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => $_SESSION['sovix__user']=="root",
    ),
 array(
    'sovix__array__commands__command' => "menu-style-tree",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?menustyle=tree",
    'sovix__array__commands__description' => "Set tree as menu style.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "menu-style-dropdown",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?menu-style=dropdown",
    'sovix__array__commands__description' => "Set menu style to drop down.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "new-message",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "mailto:",
    'sovix__array__commands__description' => "Opens you mail client to compose a new message",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "new-call",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "callto:",
    'sovix__array__commands__description' => "Opens you phone client to compose a new message",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "news",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__directory__src/help.php?sovix__directory__src=$sovix__directory__src&sovix__directory__dotsovix=$sovix__directory__dotsovix&url=$sovix__url__sovix/NEWS&task=read-pre",
    'sovix__array__commands__description' => "Lists news in the current version of Sovix from the file NEWS",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "open-file",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_file",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Open FILE in edit mode.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => isset($_SESSION['sovix__user']),
    ),
 array(
    'sovix__array__commands__command' => "open-wiki",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "/Main/",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Open FILE in /Main/ in edit mode",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => isset($_SESSION['sovix__user']),
    ),
 array(
    'sovix__array__commands__command' => "printerfriendly",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__2?screen_mode=fullscreen&dtd=w3c-xhtml-print-1.0",
    'sovix__array__commands__description' => "Show printer friendly version.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "read-file",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_file",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Read FILE or PAGE.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "read-file-textarea",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_file",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Read FILE or PAGE in textarea.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "read-file-pre",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_file",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Read FILE or PAGE in textarea.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "read-pagesource",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_uri",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Read FILE or PAGE.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "rename-file",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_path",
    'sovix__array__commands__directshow' => "self",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Rename file as newname.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => $_SESSION['sovix__user']=="root",
    ),
 array(
    'sovix__array__commands__command' => "report-sovix-bug",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "mailto:bug-sovix@gnu.org",
    'sovix__array__commands__description' => "Open application associated with MIME mailto.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
  array(
    'sovix__array__commands__command' => "search",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => " ",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__url__websrc/Search.php?sovix__directory__src=$sovix__directory__src&sovix__directory__dotsovix=$sovix__directory__dotsovix&query=$sovix__2",
    'sovix__array__commands__description' => "Search filenames that contains STRING with highlights.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "send-link",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "mailto:?subject=".basename(urldecode(str_replace('_',' ', preg_replace('#(.+)\..+#','\\1', $sovix__file))))." - $sovix__title&body=".$_SERVER['PHP_SELF'],
    'sovix__array__commands__description' => "Mail URL.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "server-phpinfo()",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__url__websrc/phpinfo.php",
    'sovix__array__commands__description' => "Show detailed information about PHP with the program phpinfo().",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => isset($_SESSION['sovix__user']),
    ),
 array(
    'sovix__array__commands__command' => "server-time",
    'sovix__array__commands__execute' => date("r"),
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "input",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Show server time.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "server-remote-ip",
    'sovix__array__commands__execute' => $_SERVER['SERVER_ADDR'],
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "input",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Shows the remote IP address of the server.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "shell",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__directory__src/help.php?sovix__directory__src=$sovix__directory__src&sovix__directory__dotsovix=$sovix__directory__dotsovix&url=$sovix__url__websrc/Shell.php&task=file-require",
    'sovix__array__commands__description' => "The file is used for single line shell mode.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' =>  $_SESSION['sovix__user']=="root",
    ),
 array(
    'sovix__array__commands__command' => "sovix.org-donate",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://sovix.org/Donate",
    'sovix__array__commands__description' => "",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "sovix.org-download",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://ftp.gnu.org/gnu/sovix/",
    'sovix__array__commands__description' => "",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "sovix.org-report-broken-website",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://sovix.org/Order_services#Report_broken_website",
    'sovix__array__commands__description' => "",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "sovix.org-order-services",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://sovix.org/Order_services",
    'sovix__array__commands__description' => "",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "sovix.org-translate-sovix",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://sovix.org/Order_services#Report_broken_website",
    'sovix__array__commands__description' => "",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "sovix.org-update-website",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://sovix.org/Order_services#Update",
    'sovix__array__commands__description' => "",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "standards",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__url__sovix/Standards.php",
    'sovix__array__commands__description' => "Lists standards used in this distribution of Sovix.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 /* array(
    'sovix__array__commands__command' => "tutorial",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__url__sovix/Tutorial.php",
    'sovix__array__commands__description' => "Open Sovix Tutorial",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),*/
 array(
    'sovix__array__commands__command' => "upload-file",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "$sovix__url__websrc/Upload_file.php?sovix__directory__src=$sovix__directory__src&sovix__directory__dotsovix=$sovix__directory__dotsovix",
    'sovix__array__commands__description' => "Upload SOURCE to DESTINATION",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => $_SESSION['sovix__user']=="root",
    ),
 array(
    'sovix__array__commands__command' => "server-uptime",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "input",
    'sovix__array__commands__goto' => "$sovix__url__websrc/Uptime.php?sovix__directory__src=$sovix__directory__src&sovix__directory__dotsovix=$sovix__directory__dotsovix&url=$sovix__2",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Show the uptime for the server.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "validate-css",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_file",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://jigsaw.w3.org/css-validator/validator?uri=http://". $_SERVER["SERVER_NAME"] ."$sovix__2",
    'sovix__array__commands__description' => "Validates CSS of current page source.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "validate-markup",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=http://". $_SERVER["SERVER_NAME"] ."$sovix__2",
    'sovix__array__commands__description' => "Validates the markup at validator.w3.org.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-2.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-2.0",
    'sovix__array__commands__description' => "Validates the markup as HTML 2.0.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-2.0-level-1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-2.0-level-1",
    'sovix__array__commands__description' => "Validates the markup as HTML 2.0 Level 1.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-2.0-level-2",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-2.0-level-2",
    'sovix__array__commands__description' => "Validates the markup as HTML 2.0 Level 2.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-2.0-strict",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-2.0-strict",
    'sovix__array__commands__description' => "Validates the markup as HTML 2.0 Strict.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-2.0-strict-level-1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-2.0-strict-level-1",
    'sovix__array__commands__description' => "Validates the markup as HTML 2.0 Strict Level 1.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-2.0-strict-level-2",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-2.0-strict-level-2",
    'sovix__array__commands__description' => "Validates the markup as HTML 2.0 Strict Level 2.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-3.2",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-3.2",
    'sovix__array__commands__description' => "Validates the markup as HTML 3.2.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-3.2-final",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-3.2-final",
    'sovix__array__commands__description' => "Validates the markup as HTML 3.2 Final.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-4.0-transitional",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-4.0",
    'sovix__array__commands__description' => "Validates the markup as HTML 4.0.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-4.0-transitional-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-4.0-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as HTML 4.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-4.0-strict",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-4.0-strict",
    'sovix__array__commands__description' => "Validates the markup as HTML 4.0 Strict.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-4.0-strict-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-4.0-strict-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as HTML 4.0 Strict without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-4.0-frameset",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-4.0-frameset",
    'sovix__array__commands__description' => "Validates the markup as HTML 4.0 Framset.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-4.0-frameset-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-4.0-frameset-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as HTML 4.0 Framset without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-4.01-transitional",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-4.01",
    'sovix__array__commands__description' => "Validates the markup as HTML 4.01.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-4.01-transitional-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-4.01-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as HTML 4.01 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-4.01-strict",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-4.01-strict",
    'sovix__array__commands__description' => "Validates the markup as HTML 4.01 Strict.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-4.01-strict-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-4.01-strict-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as HTML 4.01 Strict without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-4.01-frameset",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-4.01-frameset",
    'sovix__array__commands__description' => "Validates the markup as HTML 4.01 Framset.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-4.01-frameset-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-4.01-frameset-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as HTML 4.01 Framset without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-html-5",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=html-5",
    'sovix__array__commands__description' => "Validates the markup as HTML 5.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-mathml-1.01",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=mathml-1.01",
    'sovix__array__commands__description' => "Validates the markup as MathMl 1.01.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-mathml-1.01-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=mathml-1.01-without-system-identifierx",
    'sovix__array__commands__description' => "Validates the markup as MathMl 1.01.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-mathml-2.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=mathml-2.0",
    'sovix__array__commands__description' => "Validates the markup as MathMl 2.0.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-mathml-2.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=mathml-2.0-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as MathMl 2.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-smil-1.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=smil-1.0",
    'sovix__array__commands__description' => "Validates the markup as SMIL 1.0.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-smil-1.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=smil-1.0-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as SMIL 1.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-smil-2.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=smil-2.0",
    'sovix__array__commands__description' => "Validates the markup as SMIL 2.0.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-smil-2.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=smil-2.0-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as SMIL 2.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-svg-1.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=svg-1.0",
    'sovix__array__commands__description' => "Validates the markup as SVG 1.0.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-svg-1.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=svg-1.0-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as SVG 1.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-svg-1.1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=svg-1.1",
    'sovix__array__commands__description' => "Validates the markup as SVG 1.1.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-svg-1.1-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=svg-1.1-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as SVG 1.1 without system identifier.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-svg-1.1-modlular-framework",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=svg-1.1",
    'sovix__array__commands__description' => "Validates the markup as SVG 1.1.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-svg-1.1-modlular-framework-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=svg-1.1-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as SVG 1.1 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-svg-1.1-tiny",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=svg-1.1-tiny",
    'sovix__array__commands__description' => "Validates the markup as SVG 1.1 Tiny.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-svg-1.1-tiny-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=svg-1.1-tiny-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as SVG 1.1 Tiny without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-svg-1.1-basic",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=svg-1.1-basic",
    'sovix__array__commands__description' => "Validates the markup as SVG 1.1 Basic.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-svg-1.1-basic-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=svg-1.1-basic-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as SVG 1.1 Basic without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-plus-rdfa-1.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-plus-rdfa-1.0",
    'sovix__array__commands__description' => "Validates the markup as XHTML plus RDFa 1.0.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-plus-rdfa-1.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-plus-rdfa-1.0-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as XHTML plus RDFa 1.0 without system identifier.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-basic-1.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-basic-1.0",
    'sovix__array__commands__description' => "Validates the markup as XHTML Basic 1.0.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-basic-1.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-basic-1.0-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as XHTML Basic 1.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-basic-1.1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-basic-1.1",
    'sovix__array__commands__description' => "Validates the markup as XHTML Basic 1.1.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-basic-1.1-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-basic-1.1-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as XHTML Basic 1.1 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-print-1.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-print-1.0",
    'sovix__array__commands__description' => "Validates the markup as XHTML-Print 1.0.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-print-1.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-print-1.0-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as XHTML-Print 1.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.0-strict",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.0-strict",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.0 Strict.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.0-strict-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.0-strict-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.0 Strict without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.0-transitional",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.0-transitional",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.0 Transitional.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.0-transitional-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.0-transitional-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.0 Transitional without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.0-frameset",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.0-frameset",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.0 Framset.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.0-frameset-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.0-frameset-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.0 Framset without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.1",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.1.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.1-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.1-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.1 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.1-plus-mathml-2.0",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.1-plus-mathml-2.0",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.1 plus MathMl 2.0.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.1-plus-mathml-2.0-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.1-plus-mathml-2.0-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.1 plus MathMl 2.0 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.1-plus-mathml-2.0-plus-svg-1.1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.1-plus-mathml-2.0-plus-svg-1.1",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.1 plus MathMl 2.0 plus SVG 1.1.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.1-plus-mathml-2.0-plus-svg-1.1-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.1-plus-mathml-2.0-plus-svg-1.1-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.1 plus MathMl 2.0 plus SVG 1.1 without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.1-plus-mathml-2.0-plus-svg-1.1-using-svg-as-the-host",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.1-plus-mathml-2.0-plus-svg-1.1-using-svg-as-the-host",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.1 plus MathMl 2.0 plus SVG 1.1 (using the SVG as the host) as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xhtml-1.1-plus-mathml-2.0-plus-svg-1.1-using-svg-as-the-host-without-system-identifier",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xhtml-1.1-plus-mathml-2.0-plus-svg-1.1-using-svg-as-the-host-without-system-identifier",
    'sovix__array__commands__description' => "Validates the markup as XHTML 1.1 plus MathMl 2.0 plus SVG 1.1 (using the SVG as the host) without system identifier as document type.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-xhtml-iso/iec-15445:1999",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=dtd-xhtml-iso-iec-15445-1999",
    'sovix__array__commands__description' => "Validates the markup as ISO/IEC 15445:1999 (\"ISO HTML\").",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-xhtml-iso/iec-15445:1999-short-form",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=dtd-xhtml-iso-iec-15445-1999-short-form",
    'sovix__array__commands__description' => "Validates the markup as short form of ISO/IEC 15445:1999 (\"ISO HTML\").",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-xhtml-iso/iec-15445:2000",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=dtd-xhtml-iso-iec-15445-2000",
    'sovix__array__commands__description' => "Validates the markup as ISO/IEC 15445:2000 (\"ISO HTML\").",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-xhtml-iso/iec-15445:2000-short-form",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=dtd-xhtml-iso-iec-15445-2000-short-form",
    'sovix__array__commands__description' => "Validates the markup as short form of ISO/IEC 15445:2000 (\"ISO HTML\").",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xml-specification-v2.1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xml-specification-v2.1",
    'sovix__array__commands__description' => "Validates the markup as XML Specification V2.1.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "validate-markup-as-w3c-xml-specification-v2.1",
    'sovix__array__commands__execute' => "",
    'sovix__array__commands__separator' => "current_url",
    'sovix__array__commands__directshow' => "",
    'sovix__array__commands__goto' => "http://validator.w3.org/check?uri=$sovix__2?dtd=xml-specification-v2.1",
    'sovix__array__commands__description' => "Validates the markup as XML Specification V2.1.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
       ),
 array(
    'sovix__array__commands__command' => "version",
    'sovix__array__commands__execute' => "GNU Sovix $sovix__version of $sovix__build_date",
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "input",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Show Sovix version.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 array(
    'sovix__array__commands__command' => "whoami",
    'sovix__array__commands__execute' => $_SESSION['sovix__user'],
    'sovix__array__commands__separator' => "",
    'sovix__array__commands__directshow' => "input",
    'sovix__array__commands__goto' => "",
    'sovix__array__commands__description' => "Show current user.",
    'sovix__array__commands__located_menu' => "",
    'sovix__array__commands__require' => "None",
    ),
 );
?>
