/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 dialog.h - dialogs for displaying messages and getting simple input

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#ifndef DIALOG_H
#define DIALOG_H

void dialog_error(char *wintitle, char *title, char *text, char *opt);
void dialog_warning(char *wintitle, char *title, char *text, char *opt);
void dialog_info(char *wintitle, char *title, char *text, char *opt);
void dialog_message(char *wintitle, char *title, char *text, char *opt);

int dialog_confirm(char *wintitle, char *title, char *text1, char *text2,
		   char *text3);

char *dialog_input_opendir(char *title, char *startpath);
int dialog_input_select_string(char *title, char *text,
			       struct srcinst_string_list *s);
int dialog_input_package(char **filename, char **packagename);
int dialog_input_package2(char *title, char **filename,
			  char **packagename);
int dialog_configure(struct srcinst_configure_sets *opts, char **prefix,
		     struct srcinst_string_list *s, char *old_configure);

char *dialog_input_export_info(char *title, char *defaultname,
			       SRCINST_EXPORT * fmt);

char *dialog_input_export_bin(char *title, char *defaultname,
			      SRCINST_COMP fmt);

#endif				/* DIALOG_H */
